;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; 饹ɥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_stew
               (list 0  0  gv-bed       "sleeping")
               (list 7  0  ghg-s4       "eating")
               (list 8  0  gc-hall "idle")
               (list 12 0  ghg-s1       "eating")
               (list 13 0  gc-hall "idle")
               (list 18 0  ghg-s1       "eating")
               (list 19 0  gc-hall "idle")
               (list 20 0  gv-bed       "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (stew-mk) (list 'townsman #f))
(define (stew-met? stew) (cadr stew))
(define (stew-met! stew) (set-car! (cdr stew) #t))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ȥꥢϥ饹ɥΰŪʻƳԤǡԤ̾äƤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (stew-hail knpc kpc)
  (if (not (stew-met? (kobj-gob-data knpc)))
      (begin
        (say knpc "ΤʤϰҸɺȲä"
             "褦¤ͤ衣ʤ뤳ȤʹƤޤ")
        (stew-met! (kobj-gob-data knpc)))
      (say knpc "ΤʤϰҸɺȲä"
           "ޤ񤤤ޤ͡¤ͤ衣")))

(define (stew-default knpc kpc)
  (say knpc "ϼǤޤ"))

(define (stew-name knpc kpc)
  (say knpc "ϥȥꥢ饹ɥԤǤ"))

(define (stew-join knpc kpc)
  (say knpc "ʡ"))

(define (stew-job knpc kpc)
  (say knpc "饹ɥԤǤ"))

(define (stew-bye knpc kpc)
  (say knpc "ƻʤߤʤ¤ͤ衣"))

;; Warritrix...
(define (stew-warr knpc kpc)
  (cond ((player-found-warritrix?)
      (if (ask? knpc kpc "äȤʹޤ䤬ؤäȤϡͤƤޤ͡")
          (say knpc "Ǥ蘆̵뤷ʤϻŨ᤿ΤǤ")
          (begin
            (say knpc "ˤʤΤʤСǤʤ"
                 "Ǥٹ𤷤ޤʤϽɤʤ˷ƻϤϤǺǤϤΤĮλۼԤʤΤǤ"
                 "ϻȤʤθդƱƵιȯͤϸȳǤ礦")
            (aside kpc 'ch_ini "¤ʤɤʤ΢ڤԤ衢桹Ϥʤʤ롣"
                   "ʤʾθդǤäơ")
            )
          ))
      ((quest-data-assigned? 'questentry-wise)
		(say knpc "Ф餯äƤޤ󡣲Ǥ̳οȻפޤ")
		(quest-data-update 'questentry-warritrix 'assignment 1)
		)
	(else
		(say knpc "κǤͥ줿ΤǤϷ˽ФƤȻפޤ")
		 (quest-data-update 'questentry-warritrix 'general-loc 1)
		 )
      ))

(define (stew-erra knpc kpc)
  (say knpc "ե꡼ᴱʹƤʤܤȤΤäƤϤǤ"))

;; Steward...
(define (stew-stew knpc kpc)
  (say knpc "饹ɥФ줿ԤˤäƼƤޤ"
       "̳Įڤ뤳Ȥˤޤ"))

(define (stew-real knpc kpc)
  (say knpc "饹ɥڤϡμӤοޤǤǤ"
       "ϾϲΰݻԤäƤޤ"))

;; Rune...
(define (stew-rune knpc kpc)
	(if (quest-data-assigned? 'questentry-wise)
		(say knpc "ƮΤǤ˳ݤƤޤĤޤ"
			"Ǥ⡢񤫤ƤΤΤޤ")
		(say knpc "ƮΤǤ˳ݤƤޤ"
			"Ǥ⡢񤫤ƤΤΤޤ")
		)
       (quest-data-assign-once 'questentry-rune-l)
       )

(define (stew-wore knpc kpc)
	(if (quest-data-assigned? 'questentry-wise)
		(say knpc "ΤǤְ㤨Ǥ")
		(stew-default knpc kpc)
	))

;; Absalot...
(define (stew-absa knpc kpc)
  (say knpc "֥åȤϤϤ¤ǡ"
       "˴˼ʤФʤޤǤ"
       "ηǤˤĤƤ򤷤Ƥޤ͡")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "Τʤͤޤ̿ȤȤǤ"
           "εʤ臘ȤϤǤʤΤǤ")
      (say knpc "ʤ˲狼ȤΤǤ"
           "ʤϤΤʤ餺ԤǤ礦")))

(define (stew-inno knpc kpc)
  (say knpc "֥åȤƤμԤٰä櫓ǤϤޤ"
       "ٰˤꡢФǤ"))

(define (stew-wick knpc kpc)
  (say knpc "֥åȤο͡Ͽʹ֤Ӥ䰭ҤԤäƤޤ"
       "¾ĮĤĮˤԤϤޤ"))

(define (stew-conv knpc kpc)
  (say knpc "ΤȤΤäȤзˤޤ"
       "ϸԤ¾ĮλƳԤȲ񤤡ɤΤޤ")
  (prompt-for-key)
  (say knpc "Ԥβͤޤ"
       "䤿ȿаոѲϢ緳ޤ"
       "ƥ֥åȤ˿ʷ٤ȺƷǤ̤褦˲ϩΤǤ"))

(define (stew-wise knpc kpc)
  (say knpc "ԤĮλƳԤƤޤͤǤϾϤޤ"
       "Ĥƻ䤿ȿФƻդǤ饹ɥϤˤ񹳤ǤޤǤ")
       (quest-wise-subinit 'questentry-enchanter)
       )

(define (stew-rogu knpc kpc)
  (say knpc "ʤϤɤ褿ΤǤ桹ϤǤŪϡ"
       "⤷۹η͸Ǥϡ")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ࡣ⤷ʤθȤʤ顢Ԥꤲߡ"
           "ˤƤǤФǤ礦"
           "ºݤˤϸۤ򤫤Ω결Ǥ礦"
           "¤ͤ衢̵ФǤ褦̵˾äʤ")
      (say knpc "ʤ϶褿˷Ǥ礦"
           "ˤ衢¤ͤ衢ʤˤդ٤Ǥ"
           "Įؤ褦ʤȤСԤμˤäƻܤΤ뤳ȤǤ礦"))
  (kern-conv-end))

;; Townspeople...
(define (stew-glas knpc kpc)
  (say knpc "饹ɥϰŰǤˤƳθǤ"
       "ΤϤڤΤ˿Ȥ򤵤Ǥ򲡤ᤷƤޤ"
       "Ⱦο͡ϤĮβäˤäƤޤ"))

(define (stew-unde knpc kpc)
  (say knpc "ϲΤʤʪޤǤ"
       "ˤƤˤȤäƶҤǤ밭Ԥݤ̳ޤ"))

(define stew-conv
  (ifc glasdrin-conv

       ;; basics
       (method 'default stew-default)
       (method 'hail stew-hail)
       (method 'bye  stew-bye)
       (method 'job  stew-job)
       (method 'name stew-name)
       (method 'join stew-join)

       (method 'city stew-glas)
       (method 'town stew-glas)
       (method 'glas stew-glas)
       (method 'warr stew-warr)
       (method 'erra stew-erra)
       (method 'stew stew-stew)
       (method 'real stew-real)
       (method 'absa stew-absa)
       (method 'wore stew-wore)
       (method 'rune stew-rune)
       (method 'inno stew-inno)
       (method 'wick stew-wick)
       (method 'conv stew-conv)
       (method 'wise stew-wise)
       (method 'rogu stew-rogu)
       (method 'wrog stew-rogu)
       (method 'unde stew-unde)
       ))

(define (mk-steward)
  (bind 
   (kern-char-force-drop
    (kern-mk-char 'ch_steward         ; tag
                  "ȥꥢ"      ; name
                  sp_human            ; species
                  nil                 ; occ
                  s_lady              ; sprite
                  faction-glasdrin         ; starting alignment
                  1 3 0               ; str/int/dex
                  0 0                 ; hp mod/mult
                  0 0                 ; mp mod/mult
                  max-health -1 max-health 0 6  ; hp/xp/mp/AP_per_turn/lvl
                  #f                  ; dead
                  'stew-conv          ; conv
                  sch_stew            ; sched
                  'townsman-ai                 ; special ai
                  (mk-inventory (list (list 1 t_sword_4)
                                      (list 1 t_stewardess_chest_key)
                                      ))    ; container
                  nil                 ; readied
                  )
    #t)
   (stew-mk)))
