;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define the-man-start-lvl 9)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ˱줿ˤˤ󤲤α
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_man
               (list 0  0 mans-bed    "sleeping")
               (list 7  0 mans-supper "eating")
               (list 8  0 mans-hall   "idle")
               (list 12 0 mans-supper "eating")
               (list 13 0 mans-tools  "idle")
               (list 15 0 mans-hall   "idle")
               (list 18 0 mans-supper "eating")
               (list 19 0 mans-dock   "idle")
               (list 22 0 mans-bed    "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (man-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ֤ˤ󤲤פȤΤ륤̤ۤѤäʤ餺Ԥν
;; 롣ΤƤʤ(ˤ󤲤α)˽Ǥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (man-hail knpc kpc)
  (say knpc "ΤʤϿͤĤ褦ʡǭΤ褦˿ȷڤǯνȲä"
       "ˤϡƤ"))

(define (man-default knpc kpc)
  (say knpc "ҸƤߤ"))

(define (man-name knpc kpc)
  (say knpc "ϥ̡ǤͤϤˤ󤲤ȸƤ֤"))

(define (man-join knpc kpc)
  (say knpc "̥ŪΤʤȤϸʤ͡Ǥ⡢򤹤ʤͤ"))

(define (man-job knpc kpc)
  (say knpc "͡Ω֤ɤ֤ϴñϤʤ餺Ԥ衣"))

(define (man-bye knpc kpc)
  (say knpc "ХХ"))


;; Misc
(define (man-man knpc kpc)
  (say knpc "ϾФäϤ⤷ơˤȻפäƤ顩")
  (kern-conv-get-yes-no? kpc)
  (say knpc "ˤ󤲤(MAN)϶ߤʵν(Mistress of Acquisitive Nature)Ƭʸ衣"
       "äƤ줿顩")
  (kern-conv-get-yes-no? kpc)
  (say knpc "դǽˤƤȻפ"
       "äƺ줿֤ˤޤΤ͡"))

(define (man-wrog knpc kpc)
  (say knpc "ʤ餺ԤȤϵ§ˤȤ衣"
       "Τ衢Ƥʡ§ˤΤϹ")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "϶äդ򤷤ϤȤƤ̥Ūä"
           "Ҥ͡ʿǤ򤷤ƶ餷ʤФʤʤ͡")
      (say knpc "䤪䡢ɤƤʤ˻ͳĥäƤΡͳĥäΤ˹衣"
           "⤷ȤǻᤤƤΤ顩Ϥʤ̵ٵ˸")))

(define (man-rule knpc kpc)
  (say knpc "§̩档ϤƲθˤΤ򸫤"
       "Ϲ񿴤ΤᡢĩΤ衣"
       "ޤ򸫤ơˤ٤狼뤫顩")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ϤϤҶ򤹤ΤȤⲿ⸫ƤʤΤ")
      (say knpc "Ϥ̾ȰäƤʤ˶ߤǤϤʤ"
           "ϡֻġפȤˤ϶̣ϤʤΡ֤פ衣"
           "٤äƤޤСθˤ϶̣Ϥʤ"
           "䤬Ǥⶽ̣ͤΤϡ̩ΤΤ衣")))

(define (man-secr knpc kpc)
  (say knpc "ǻƤʤ"))

(define (man-enem knpc kpc)
  (say knpc "ƮΤζϤŨϥ饹ɥԤΤʤ"))

(define (man-stew knpc kpc)
  (say knpc "ɤȤΡ"
       "館ۤΤ⤷ʤ"
       "ϥ֥åȤؤƮΤǤΤ衣"))

(define (man-hate knpc kpc)
  (say knpc "ԤʬɤǤߤʤ"
       "ɤФΤꤿ")
  (if (yes? kpc)
      (say knpc "ĤθդФƤФ<Wis Quas>衣"
           "ʤϱԤɤˤ뤫Ϥ狼Ǥ礦")
      (say knpc "Ǥ⤢ʤϸȤƤ"
           "Ūά衣")))


;; Wise Queries
(define (man-wiza knpc kpc)
  (say knpc "ȤƤ⶯Ǥ̩ߤ"))

(define (man-wrig knpc kpc)
  (say knpc "«Ǥ䤬ʤϤޤʤ褦͡"))

(define (man-warr knpc kpc)
  (say knpc "Ϥͥʿ񤤤ΤƤ롣"
       "ΤȤϾܤΤʤɡŨϡ⤷Ȥ褯ΤäƤ뤫⤷ʤ"))

(define (man-necr knpc kpc)
  (say knpc "ͧã衣"
       "ͤƤͤ˺줿ΤȤΤäƤ롣"
       "ϤɤäʹФΤΤäƤΤ衣"))

(define (man-alch knpc kpc)
  (say knpc "ͤʤΤϤ狼äƤ뤱ɡȤϹʤ͡"))

(define (man-engi knpc kpc)
  (say knpc "߷׽«ĩ路Ƥߤ"
       "Ǥ⡢ˤϱƤ̩ʤΤ衪"))

(define (man-ench knpc kpc)
  (say knpc "κǰѻա"
       "äʹ˹ԤΤ⡢ιʤ繥衪"
       "Ǥ⼫ʬʪϤäȤȤޤä֤٤͡"))

;; Accursed Queries
(define (man-accu knpc kpc)
  (say knpc "餬ͳˤĤäȤ¾Ԥˤ뼫ͳ̣롣"
       "§ˤä˲ääԤ⤤Ǥ狼äΤ鼫ȤǤĤʤƤȤȤ"
       "Բ«衣"))


;; Rune
(define (man-rune knpc kpc)
  (say knpc "ǡĤĤƳ±äƤΤΤäƤ"
       "ƥȡֻῼ׹äΤäƤ뤫顩")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ιƤΤ͡и˭ʿͤϹ衣")
      (say knpc "ѡǥƥˤĤʹƤʤ"))
  (say knpc "⤷ῼ򸫤Ĥ顢ʸǰ夲"
       "ʸϤ狼롩")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ޤʤϤˡΤäƤΡ"
           "ˡΤʤФɡˡȤ")
      (begin
			(say knpc "ޥɥ쥤ݡλĴ礷ơ"
			"<Vas Uus Ylem>Ⱦ롣"
			"ؤʤ")
			(quest-data-update 'questentry-rune-c 'shipraise 1)
		)
	)
  (say knpc "ƥϥǤξʤǤ礦͡"
       "ǤǤޤäƤ˾ϤȤǰλ򤷤Ƥ⡪"
       "ƥ˾ǤΤϡ^c+m^c-Τߤ衣"
       "θդαƤʤͩȤäȤפФΤ衣")
	(quest-data-update 'questentry-rune-c 'info 1)
	(quest-data-assign-once 'questentry-rune-c)
	(quest-data-update 'questentry-ghertie 'ghertieid 1)
	(quest-data-update-with 'questentry-ghertie 'revenge 1 (quest-notify nil))
	(quest-data-assign-once 'questentry-ghertie)
	)

(define (man-chan knpc kpc)
  (say knpc "ɥȲäΡϻε򤷤٤ä˰㤤ʤ"
       "Ϥ̵Ǥʤʤ餺Ԥϸʤ褦͡"))

(define man-conv
  (ifc basic-conv

       ;; basics
       (method 'default man-default)
       (method 'hail man-hail)
       (method 'bye  man-bye)
       (method 'job  man-job)
       (method 'name man-name)
       (method 'join man-join)
       
       ;; special
       (method 'man man-man)
       (method 'wrog man-wrog)
       (method 'rogu man-wrog)  ;; a synonym
       (method 'rule man-rule)
       (method 'secr man-secr)
       (method 'enem man-enem)
       (method 'stew man-stew)
       (method 'diar man-hate)
       (method 'evid man-hate)
       (method 'hate man-hate)
       (method 'wiza man-wiza)
       (method 'wrig man-wrig)
       (method 'warr man-warr)
       (method 'necr man-necr)
       (method 'alch man-alch)
       (method 'engi man-engi)
       (method 'ench man-ench)
       (method 'accu man-accu)
       (method 'rune man-rune)
       (method 'chan man-chan)
       ))

(define (mk-the-man)
  (bind 
   (kern-mk-char 'ch_man           ; tag
                 "ˤ󤲤"            ; name
                 sp_human            ; species
                 oc_wrogue           ; occ
                 s_brigandess        ; sprite
                 faction-men         ; starting alignment
                 0 3 10               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health ; hp
                 -1                   ; xp
                 max-health ; mp
                 0
                 the-man-start-lvl
                 #f                  ; dead
                 'man-conv         ; conv
                 sch_man           ; sched
                 'townsman-ai                 ; special ai
                 nil                 ; container
                 (list t_armor_leather_4
                 		t_leather_helm_2
                 		t_magic_axe)                 ; readied
                 )
   (man-mk)))
