;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define thud-start-lvl  6)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ܥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_thud
               (list 0  0  bole-bedroom-thud "idle")
               (list 9  0  bole-dining-hall  "idle")
               (list 10 0  bole-courtyard   "idle")
               (list 12 0  bole-dining-hall   "idle")
               (list 23 0  bole-bedroom-thud "idle")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (thud-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ɥϥ㥹ѿǡϤΤťȻפܥαޤ
;; Ƥ롣¿¾оʪϥɥȾʬϿʹ֤ǥη줬ήƤ롢ޤ
;; (Ԥ줿ޤϺ줿)ȹͤƤġ
;; 
;; ɥ֤ˤʤ(΢ڤ)
;; ϥ㥹֤ǡ֤˲ää롣
;;----------------------------------------------------------------------------
(define (thud-hail knpc kpc)
  (say knpc "ΤʤˤΤϳΤ˥ΰ"
       "Ĺ3᡼ȥꡢҰŪ"
       "ܤ٤Ƥʤˤ"))

(define (thud-default knpc kpc)
  (say knpc "ΰҰŪܤưʤä"))

(define (thud-name knpc kpc)
  (say knpc "ɥϡ"))

(define (thud-join knpc kpc)
  (if (is-player-party-member? ch_kathryn)
      (begin
        (say knpc "Υ㥹Ȥʤ򸫤ȡƱդ")
        (kern-char-join-player knpc)
        (kern-conv-end))
      (say knpc "ϤФä")))

(define (thud-job knpc kpc)
  (say knpc "ɥϡΤ繥"))

(define (thud-kathryn knpc kpc)
  (say knpc "ɥϡʤ"))

(define (thud-thud knpc kpc)
  (say knpc "ΤȤΡȡɥϡΡǡ򡡤ۤ뤾"))

(define (thud-thief knpc kpc)
  (say knpc "ܤФťϡɥ򡡤ޤɥϡť򡡸Ĥ롪ɥϡť򡡻"))

(define (thud-find knpc kpc)
  (say knpc "Ͼ夤֤ʽť򡡸Ĥ롣ťϡ졡ʤ"))

(define (thud-red-lady knpc kpc)
  (say knpc "϶ܤĤǤʤ򸫤֤ʽ顡Υ"))

(define thud-conv
  (ifc nil
       (method 'default thud-default)
       (method 'hail thud-hail)
       (method 'bye 
               (lambda (knpc kpc) 
                 (say knpc "Ϥ󤶤ꤷܤǤʤΤ򸫤Ƥ")))
       (method 'job  thud-job)
       (method 'name thud-name)
       (method 'join thud-join)

       (method 'find thud-find)
       (method 'kath thud-kathryn)
       (method 'kill thud-job)
       (method 'lady thud-red-lady)
       (method 'love thud-job)
       (method 'red  thud-red-lady)
       (method 'thie thud-thief)
       (method 'thud thud-thud)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-thud)
  (bind 
    (kern-char-arm-self
     (kern-mk-char 
      'ch_thud ;;.....tag
      "ɥ" ;;.......name
      sp_troll ;;.....species
      oc_warrior ;;...occupation
      s_troll ;;......sprite
      faction-men ;;..faction
      4 ;;............custom strength modifier
      0 ;;............custom intelligence modifier
      2 ;;............custom dexterity modifier
      2 ;;............custom base hp modifier
      1 ;;............custom hp multiplier (per-level)
      0 ;;............custom base mp modifier
      0 ;;............custom mp multiplier (per-level)
      max-health;;..current hit points
      -1  ;;...........current experience points
      max-health ;;..current magic points
      0
      thud-start-lvl  ;;..current level
      #f ;;...........dead?
      'thud-conv ;;...conversation (optional)
      sch_thud ;;.....schedule (optional)
      'townsman-ai ;;..........custom ai (optional)
      nil ;;..........container (and contents)
      ;;.........readied arms (in addition to the container contents)
      (list
       t_2h_axe
       t_iron_helm
       t_armor_plate
       )
      nil ;;..........hooks in effect
      ))
   (thud-mk)))
