;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define tooth-lvl 2)
(define tooth-species sp_rat)
(define tooth-occ oc_wrogue)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ʪ¼
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_tooth
               (list 0 0 campfire-4 "sleeping")
               (list 6 0 black-market-counter "working")
               (list 19 0 cantina-12 "idle")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (tooth-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ޥФϿмʥͥ߿ʹ֤ǡʪ¼ǰǻԤȼĤǤ롣
;; ζʳޤμꤹ(ޤ϶Ǿɾ)Ƕ줷Ǥ褦˸롣
;;----------------------------------------------------------------------------

;; Basics...
(define (tooth-hail knpc kpc)
  (kern-log-msg "ʤϤ븭ǯϷ礭ΥͥߤȲäϿм˿̤Τɤ餷Ƥ롣"
                "եμꤹ֥åФʤˤϲ狼ʤ")
  (say knpc "äȡ䤫Ϥ衣ɤʾ⤢衪䡪䡪"
       "äȤ졢Ѱդ衢Ȥ졪ʹƤʤʤ")
  )

(define (tooth-default knpc kpc)
  (say knpc "ΤʤΤʤ󡩲ˤϴطʤ")
  )

(define (tooth-name knpc kpc)
  (say knpc "ޥСͭ̾衪ɾȽ衣ҤϤߤʵäƤ롣"
       "ߤʤޤ롣ҤΤͧãϲΤäƤ롩̡"
       "ϤȤäƤ⤤衣ҤϤߤ̩ˤƤ롣Ϥ̩̩ͭ̾")
  )

(define (tooth-join knpc kpc)
  (say knpc "Ǥʤͧ衣Źʤ㡣ڶ֤ʤ㡣ʼƨʤ㡣˻롪ưʤ㡪")
  )

(define (tooth-job knpc kpc)
  (say knpc "䡪䡪䡪䡪䡪䡪"
       "ǤˤǤ")
  (tooth-trade knpc kpc)
  )

(define (tooth-bye knpc kpc)
  (say knpc "ʤ᤯ԤΡ⤦ΡäȤ衪󤢤衪"
       "ΡǤ⤳ˤϤʤ䡪êǤäǤǡġ"
       "ϤʤޤǤΤ褦ʤȤ³")
  )

(define tooth-merch-msgs
  (list nil ;; closed
        "츫ơΤθơΩġ¾ˤʤ" ;; buy
        "ʪ롣ɤǸĤɤǤ⤤" ;; sell
        "㤤ɤä٤Ƥ롩狼ʤʬǳΤơ" ;; trade
        "ޤ衪" ;; sold-something
        "ԤơɤԤäơ̤θơδʪ쥯󸫤" ;; sold-nothing
        "äȤäޤơĤǤ⸫衪" ;; bought-something
        "äȤΡˡΤΡСݽʡ" ;; bought-nothing
        "ܤ˺ʤбӥСƻ" ;; traded-something
        "ԤơɤԤäơ̤θơδʪ쥯󸫤" ;; traded-nothing
        ))

(define tooth-catalog
  (list
   (list t_picklock            5 "򳫤롪äȵ롪")
   (list t_gem                20 "̩ƻ򸫤Ĥ롪ťϥ줬繥")
   (list t_grease             25 "Ȥ롩")

   (list t_oil                 5 "Ǵݤ臘Τ˰֡")
   (list t_slime_vial         30 "Kal Xen NoxӵͤᤷʼƨΤˤ")
   (list t_arrow               3 "ϤäѤ衪")
   (list t_bolt                3 "Ƥ¿뤳ȤϤʤ")
   (list t_smoke_bomb          4 "褯ƨƻ롪")

   (list t_spiked_helm       300 "Ƭ廊")
   (list t_spiked_shield     300 "ʪ⤬繥ʿͤˡ")

   (list t_dagger_4           (* 4 65) "ȤäƤ⤤롢Ǥݤ")
   (list t_sword_2            (* 2 85) "̤ηꤤڤ򸫤ơ")
   (list t_sword_4            (* 4 85) "֤ǶʪληݽѲȤ")
   (list t_morning_star_2     (* 2 105) "˥åޤȤݤ")

   (list t_leather_helm_2     (* 2 100) "ä;ʬɸ椬פʤ餺Ը")
   (list t_chain_coif_4       (* 4 100) "ΤĤܸơζӤĤɤʿϤ¤餲롪")
   (list t_iron_helm_4        (* 4 150) "ȤäƤƬ򲥤Ƥ餤ˤʤ")

   (list t_armor_leather_2    (* 2 150) "ͤˤťˤʤꤿȥ뤫ФߤߤʷڤƤĤפ롪")
   (list t_armor_leather_4    (* 4 150) "ΤΤʤ餺ԤäƤߤΥ٥åɤǯäƻ󤿤Ǥ롪")
   (list t_armor_chain_4      (* 4 330) "ϴưΥޤˤʤʤƶ")
   (list t_armor_plate_4      (* 4 660) "ͤȥȥ뤬äƤʤʳˤʤ")

   (list t_xen_corp_scroll    (* 7 base-scroll-cost) "ŻԤ롪")
   (list t_sanct_lor_scroll   (* 7 base-scroll-cost) "ʤ餺Ԥʤʤäƽꤹ롪")
   (list t_an_xen_ex_scroll   (* 6 base-scroll-cost) "ݤʤĤϤμʸ֤ˤ")
   (list t_in_ex_por_scroll   (* 4 base-scroll-cost) "ĤäѤСˡߤʤ")
   (list t_wis_quas_scroll    (* 4 base-scroll-cost) "ʤ(ƸʤŨ)򸫤ĤΤ˴")
   (list t_in_quas_xen_scroll (* 7 base-scroll-cost) "ʬߤδʪɤᡪ")
   (list t_an_tym_scroll      (* 8 base-scroll-cost) "˥ХȤϤδʪɤǻ֤ߤƨ")
   ))

(define (tooth-trade knpc kpc) (conv-trade knpc kpc "trade" tooth-merch-msgs tooth-catalog))
(define (tooth-buy   knpc kpc) (conv-trade knpc kpc "buy"   tooth-merch-msgs tooth-catalog))
(define (tooth-sell  knpc kpc) (conv-trade knpc kpc "sell"  tooth-merch-msgs tooth-catalog))

(define tooth-conv
  (ifc nil

       ;; basics
       (method 'default tooth-default)
       (method 'hail tooth-hail)
       (method 'bye  tooth-bye)
       (method 'job  tooth-job)
       (method 'name tooth-name)
       (method 'join tooth-join)

       (method 'trad tooth-trade)
       (method 'buy  tooth-buy)
       (method 'sell tooth-sell)
       (method 'deal tooth-trade)
       ))

(define (mk-tooth)
  (bind 
   (kern-mk-char 
    'ch_tooth           ; tag
    "ޥ"             ; name
    tooth-species         ; species
    tooth-occ              ; occ
    s_rat     ; sprite
    faction-men      ; starting alignment
    0 4 1            ; str/int/dex
    0  ; hp bonus
    0 ; hp per-level bonus
    0 ; mp off
    1 ; mp gain
    max-health ; hp
    -1                  ; xp
    max-health ; mp
    0
    tooth-lvl
    #f               ; dead
    'tooth-conv         ; conv
    sch_tooth           ; sched
    'townsman-ai              ; special ai
    nil
    nil              ; readied
    )
   (tooth-mk)))
