;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define warr-lvl 8)
(define warr-species sp_ghast)
(define warr-occ oc_warrior)

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (warr-mk) (list 3))
(define (warr-must-go? gob) (= 0 (car gob)))
(define (warr-end-conv gob) (set-car! gob (- (car gob) 1)))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; å(ƮΤȤΤƤ)ϡƤȤˤʤȵ
;; ΤǤä줿˴¦(줿Ʋ˲줿)
;; ǤϤˤäƱƤˤʤäƤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (warr-hail knpc kpc)
  (meet "ŤʰҸΤ˴ʤܤˤ롣")
  (say knpc "褯褿ʡ¤ͤ衣")
  (quest-data-update 'questentry-warritrix 'found 1)
  (quest-data-icon! 'questentry-warritrix 's_ghost)
  (quest-data-complete 'questentry-warritrix)
  )

(define (warr-name knpc kpc)
  (say knpc "ϥå¿μԤˤƮΤȤΤƤ")
  )

(define (warr-join knpc kpc)
  (say knpc "ƤȤ˲äƤС")
  )

(define (warr-job knpc kpc)
  (say knpc "˻Ť뤳ȤޤƱ")
  (if (yes? kpc)
      (begin
        (say knpc "˻Ť뤿ˤΤͤФʤ̡"
             "Ϥƶõ뤳Ȥ̿줿"
             "⤬ʪȤ襤Ǽ̤ƤȤ"
             "줿ԤΰŻԤԤ˲äƤߤʻ줿"
             "Ƥ졣΢ڤԤؤ̤Ƥ뤫")
        (yes? kpc)
        (say knpc "ȳǤϤʤ󤤤ˤäƤ⤿餵롣"
             "򻦤ԤˤϤҤդ路"
             "άͤԤϼμӤ򾷤"
             "ϤԤϼνȤˤϤ򼺤Τ"
             "ʡ⿿¤٤")
        )
      (say knpc "ϲ⤷ʤȤˤäƤʤΤ"))
  )

(define (warr-trut knpc kpc)
  (say knpc "¤衣ΤˤϾڵɬפ"))

(define (warr-warr knpc kpc)
  (say knpc "¾μԤ˫Τ뤽̾ˤϤ󤶤ꤷƤ"
       "ΤȤСΤΰͤ˲᤮ʤäΤ"))

(define (warr-evid knpc kpc)
  (say knpc "ʤ餺Ԥ¾ȤΤõȤĹƤ롣"
       "ƤƤΤʤ餺Ԥĺˤ󤲤")
       (quest-wise-subinit 'questentry-the-man)
       (quest-data-update 'questentry-the-man 'common 1)
       )

(define (warr-wise knpc kpc)
  (say knpc "ԤǤ蘆ʬǤ줿"
       "줿ԤϤ褯äΤ"))

(define (warr-bye knpc kpc)
  (if (warr-must-go? (gob knpc))
      (begin
        (say knpc "⤦񤦤ȤϤʤ¤ͤ衣")
        (kern-log-msg "Ͼää")
        (kern-obj-remove knpc))
      (begin
        (say knpc "ʹȤʹ")
        (if (yes? kpc)
            (say knpc "⤦ԤͤФʤ̡ؤȸƤФƤΤ")
            (say knpc "ʤФ⤦αޤäƤ褦")
            )
        (warr-end-conv (gob knpc)))))

;; Quest-related
(define (warr-rune knpc kpc)
  (say knpc "ޤǤ򽸤ƤΤʡŪϤ狼̤"
       "ǯδ֤̾⤭ӥ̾ŤοƤäǤ⤤Ƥ"))

(define (warr-clov knpc kpc)
  (say knpc "ӥǤ⤤Ƥ"
       "ϥ֥Ǥ襤̿ȤǤõƤ뤫")
  (if (yes? kpc)
  		(begin
      (say knpc "⤷ɤˤ뤫ΤäƤԤȤСϥ֥"
           "ФعԤõ^c+mӥ^c-ΤȤҤͤʤ")
       	(quest-data-update 'questentry-rune-f 'gen 1)
        (quest-data-assign-once 'questentry-rune-f)
           )
      (say knpc "⤷õĤʤ顢˿Ҥͤʤ"
           "ƤλԤƱ褦˵ؤȰ󤻤Ƥ롣Ĺ֤ˤϤʤ"
           ))
  )

(define (warr-just knpc kpc)
  (say knpc "ñʤɸ˲᤮٤⡢ۤ⡢ĤɬפȤʤ"
       "Ǥʤɸ"))

(define (warr-absa knpc kpc)
  (say knpc "ԤϤ줿Ԥν򹭤Ƥ뤳Ȥ¤"
       "˥֥åȤ˲褦̿"
       "Ϥؤμ˼줿ԤξڤǤϤʤΤ")
  (yes? kpc)
  (say knpc "ʤΤǤʡ")
  )

(define (warr-void knpc kpc)
  (say knpc "Ƥϵ¤ͤǤ롣"))

(define (warr-assa knpc kpc)
  (say knpc "ϻ䤿ԤƤ"
       "뤳ȤΤäƤΤϡ饹ɥԤȻᴱΥե꡼ʳϤʤˤؤ餺"))

(define (warr-jeff knpc kpc)
  (say knpc "Τ褦ʼ㤤ι⵮ʹԤϡФȤäƤβǵ򼺤ä"
       "ͺˤäԤʤСʳƮ̤ۤޤ褤"))

(define (warr-powe knpc kpc)
  (say knpc 
       "ΤŨȤߤʤԤϷ褷ƽʬϤ뤳ȤϤǤʤ"
       "Τ̼ԤϷΤǤϤ߼Τ"))

(define warr-conv
  (ifc basic-conv

       ;; basics
       (method 'hail warr-hail)
       (method 'bye  warr-bye)
       (method 'job  warr-job)
       (method 'name warr-name)
       (method 'join warr-join)
       
       (method 'rune warr-rune)
       (method 'clov warr-clov)
       (method 'just warr-just)
       (method 'absa warr-absa)
       (method 'stew warr-absa)
       (method 'warr warr-warr)
       (method 'evid warr-evid)
       (method 'wise warr-wise)
       (method 'void warr-void)
       (method 'trut warr-trut)
       (method 'assa warr-assa)
       (method 'jeff warr-jeff)
       (method 'powe warr-powe)
       ))

(define (mk-warritrix)
  (bind 
   (kern-mk-char 
    'ch_warr           ; tag
    "Ʈ"             ; name
    warr-species         ; species
    warr-occ              ; occ
    s_ghost     ; sprite
    faction-men      ; starting alignment
    10 0 10            ; str/int/dex
    5 2              ; hp mod/mult
    5 2              ; mp mod/mult
    max-health ; hp
    -1                   ; xp
    max-health ; mp
    0  ;; AP_per_turn
    warr-lvl
    #f               ; dead
    'warr-conv         ; conv
    nil              ; schedule
    nil              ; special ai
    nil              ; container
    nil              ; readied
    )
   (warr-mk)))
