/*
    TCFbEOutputCash.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEOutputCash.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEOutputCash::TCFbEOutputCash(TCFbECommandLineParser* Parser, TCFbEDataLoader* DataLoader, bool IsVerbose)
{                                    
    // ϐ̏
    this->Parser = Parser;
    this->DataLoader = DataLoader;
    this->FResultTable = new TCFbETable();
    this->FNeighborsList = new TObjectList();
    this->FDistributionList = new TObjectList();

    try {
        if (IsVerbose) {
            fprintf(stderr, "(3/4) Estimation is started with the following algorithms.\n");
            fprintf(stderr, "  %s\n", Parser->SimilarityComputationName);
            fprintf(stderr, "  %s\n", Parser->PredictionName);
            if (Parser->NeighborsSize > 0) {
                fprintf(stderr, "  ( Neighbors size is %d )\n", Parser->NeighborsSize);
            } else {
                fprintf(stderr, "  ( All neighbors are used )\n");
            }

            fprintf(stderr, "    ..... completed:  0.00\%");
        }

        TCFbEToolkit::GetToolkit()->SetApplicationPriority(tpLower);

        // ResultTable ̏
        for (int j = 0; j < this->DataLoader->EstimatingData->NumberOfColumns; j++) {
            this->FResultTable->AddColumn(this->DataLoader->EstimatingData->ColumnLabelList->Strings[j]);
        }
        for (int i = 0; i < this->DataLoader->EstimatingData->NumberOfRows; i++) {
            this->FResultTable->AddRow(this->DataLoader->EstimatingData->RowLabelList->Strings[i]);
        }

        // \ׂ Cell  Enabled = true ɂ
        if (Parser->TargetColumnLabelList->Count > 0) {
            if (Parser->TargetColumnLabelList->Text.Trim() != "*") {    // w\
                for (int i = 0; i < this->DataLoader->EstimatingData->NumberOfRows; i++) {
                    for (int k = 0; k < Parser->TargetColumnLabelList->Count; k++) {
                        int j = this->FResultTable->ColumnLabelList->IndexOf(Parser->TargetColumnLabelList->Strings[k]);
                        this->FResultTable->CellsByIndex[i][j]->Enabled = true;
                    }
                }
            } else {    // SĂ̗񂪗\Ώ
                for (int i = 0; i < this->DataLoader->EstimatingData->NumberOfRows; i++) {
                    for (int j = 0; j < this->DataLoader->EstimatingData->NumberOfColumns; j++) {
                        this->FResultTable->CellsByIndex[i][j]->Enabled = true;
                    }
                }
            }
        } else if (Parser->TargetColumnLabelList->Count == 0) {    // Estimating Data  Enabled = false ̗\
            for (int i = 0; i < this->DataLoader->EstimatingData->NumberOfRows; i++) {
                for (int j = 0; j < this->DataLoader->EstimatingData->ColumnLabelList->Count; j++) {
                    if (!this->DataLoader->EstimatingData->EnabledByIndex[i][j]) {
                        this->FResultTable->CellsByIndex[i][j]->Enabled = true;
                    }
                }
            }
        }

        // \̊Jn
        for (int i = 0; i < this->FResultTable->NumberOfRows; i++) {
            int    TargetRowIndex;
            if (this->DataLoader->EstimatingData == this->DataLoader->LearningData) {
                TargetRowIndex = i;
            } else {
                TargetRowIndex = this->DataLoader->LearningData->CopyRowFrom(this->DataLoader->EstimatingData, i, false);
            }

            this->DataLoader->LearningData->PrepareCF(Parser->ValueBase, Parser->AlgorithmBase, Parser->SimilarityComputationAlgorithm, Parser->PredictionAlgorithm, Parser->NeighborsSize, Parser->DefaultValueEnabled, Parser->DefaultValue, Parser->InverseCaseFrequencyEnabled, Parser->CaseAmplifier);

            for (int j = 0; j < this->FResultTable->NumberOfColumns; j++) {
                TCFbECell* Result = this->FResultTable->CellsByIndex[i][j];
                if (Result->Enabled) {
                    int TargetColumnIndex = this->DataLoader->LearningData->ColumnLabelList->IndexOf(this->FResultTable->ColumnLabelList->Strings[j]);
                    this->DataLoader->LearningData->TemporaryUnable(TargetRowIndex, TargetColumnIndex);    // \Ώۂ̃gNXꎞI Enabled = false ɂ

                    try {
                        Result->Value = this->DataLoader->LearningData->PredictedValuesByIndex[TargetRowIndex][TargetColumnIndex];
                        Result->Rank = 1.0;    // ̂Ƃ Rank = 1.0 Ƃ
                    } catch (...) {
                        Result->Enabled = false;
                        Result->Rank = 0.0;    // ŝƂ Rank = 0.0 Ƃ
                    }

                    this->DataLoader->LearningData->RecoverEnabled();

                    // NearestNeighbors Ɨގx̕z𒲂ׂiׂׂŏ Column ɂĂׂ
                    if (this->FNeighborsList->Count <= i) {
                        TObjectList*    NeighborList = new TObjectList();
                        TList*    Distribution = new TList();
                        try {
                            if (Parser->AlgorithmBase == abColumn) {    // ACex[X̂Ƃ
                                this->DataLoader->LearningData->GetNearestNeighbors(TargetColumnIndex, TargetRowIndex, Parser->NeighborsSize, NeighborList);
                                this->CountDistribution(this->DataLoader->LearningData, TargetColumnIndex, Distribution);
                            } else {
                                this->DataLoader->LearningData->GetNearestNeighbors(TargetRowIndex, TargetColumnIndex, Parser->NeighborsSize, NeighborList);
                                this->CountDistribution(this->DataLoader->LearningData, TargetRowIndex, Distribution);
                            }
                        } catch (...) {    // ŝł߂
                            delete Distribution;
                            delete NeighborList;
                        }
                        this->FNeighborsList->Add(NeighborList);
                        this->FDistributionList->Add(Distribution);
                    }
                }
            }

            if (this->DataLoader->EstimatingData != this->DataLoader->LearningData) {
                this->DataLoader->LearningData->DeleteRow(this->DataLoader->LearningData->RowLabelList->Strings[TargetRowIndex]);
            }

            if (IsVerbose) {
                fprintf(stderr, "\b\b\b\b\b\b%5.2f\%", (double)i / (double)this->DataLoader->EstimatingData->NumberOfRows * 100.0);
            }
        }

        // j ڂ̒l\ꂽǂ𒲂ׂĂ
        this->FIsResultedColumn.Length = this->FResultTable->NumberOfColumns;
        for (int j = 0; j < this->FResultTable->NumberOfColumns; j++) {
            this->FIsResultedColumn[j] = false;
            for (int i = 0; i < this->FResultTable->NumberOfRows; i++) {
                if (this->FResultTable->CellsByIndex[i][j]->Enabled) {
                    this->FIsResultedColumn[j] = true;
                    break;
                }
            }
        }

        TCFbEToolkit::GetToolkit()->SetApplicationPriority(tpNormal);

        if (IsVerbose) {
            fprintf(stderr, "\b\b\b\b\b\b100.00\%\n\n");
        }

    } catch (...) {
        delete this->FResultTable;
        delete this->FNeighborsList;
        delete this->FDistributionList;
        throw;
    }

    return;
}

//---------------------------------------------------------------------------
__fastcall TCFbEOutputCash::~TCFbEOutputCash()
{
    this->FIsResultedColumn.Length = 0;
    delete this->FDistributionList;
    delete this->FNeighborsList;
    delete this->FResultTable;
}

//---------------------------------------------------------------------------
AnsiString __fastcall TCFbEOutputCash::GetResultRowLabel(int RowIndex)
{
    return this->FResultTable->RowLabelList->Strings[RowIndex];
}

//---------------------------------------------------------------------------
AnsiString __fastcall TCFbEOutputCash::GetResultColumnLabel(int ColumnIndex)
{
    return this->FResultTable->ColumnLabelList->Strings[ColumnIndex];
}

//---------------------------------------------------------------------------
// ȉCprotected \bh̒`
//---------------------------------------------------------------------------
// DataSet ɂ TargetRowIndex sڂ̍sɑ΂ގx̕z StoredList Ɋi[ĕԂ
void __fastcall TCFbEOutputCash::CountDistribution(TCFbEDataSet* DataSet, int TargetRowIndex, TList* StoredList)
{
    StoredList->Clear();
    for (int k = 0; k < 20; k++) {
        StoredList->Add((void*)0);
    }

    double MaxSimilarity;
    double MinSimilarity;
    bool First = true;
    for (int i = 0; i < DataSet->SimilarityComputationTable->NumberOfRows; i++) {
        if (i != TargetRowIndex) {
            double Similarity = DataSet->SimilaritiesByIndex[TargetRowIndex][i];
            if (First || (Similarity > MaxSimilarity)) {
                MaxSimilarity = Similarity;
            }
            if (First || (Similarity < MinSimilarity)) {
                MinSimilarity = Similarity;
                First = false;
            }
        }
    }

    if ((MaxSimilarity > 1.0) || (MinSimilarity < -1.0)) {
        for (int i = 0; i < DataSet->SimilarityComputationTable->NumberOfRows; i++) {
            if (i != TargetRowIndex) {
                double NormalizedSimilarity = (DataSet->SimilaritiesByIndex[TargetRowIndex][i] - MinSimilarity) / (MaxSimilarity - MinSimilarity);
                int Index = Floor(NormalizedSimilarity * 20.0 + 0.5);
                if (Index >= 20) {
                    Index = 19;
                }
                StoredList->Items[Index] = (void*)(1 + (int)StoredList->Items[Index]);
            }
        }
    } else {
        for (int i = 0; i < DataSet->SimilarityComputationTable->NumberOfRows; i++) {
            if (i != TargetRowIndex) {
                int Index = Floor((DataSet->SimilaritiesByIndex[TargetRowIndex][i] + 1.0) * 10.0);
                if (Index >= 20) {
                    Index = 19;
                }
                StoredList->Items[Index] = (void*)(1 + (int)StoredList->Items[Index]);
            }
        }
    }


    return;
}

//---------------------------------------------------------------------------

