/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.applications.hexplorer;

import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.Node;
import java.applet.AppletContext;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;

public class GraphPanel
extends hypergraph.visualnet.GraphPanel {
    private static String homepageUrl = "http://hypergraph.sourceforge.net";
    private JApplet explorer;

    public GraphPanel(Graph graph, JApplet jApplet) {
        super(graph);
        this.explorer = jApplet;
        this.getEdgeRenderer().setLabelVisible(true);
    }

    public void setHoverElement(Element element, boolean bl) {
        if (this.getHoverElement() != element) {
            AppletContext appletContext;
            if (element == null) {
                appletContext = this.explorer.getAppletContext();
                appletContext.showStatus("");
                this.setToolTipText(null);
            }
            if (element != null && element.getElementType() == 1) {
                appletContext = this.explorer.getAppletContext();
                AttributeManager attributeManager = this.getGraph().getAttributeManager();
                String string = (String)attributeManager.getAttribute("xlink:href", element);
                if (string == null) {
                    string = "No reference";
                }
                appletContext.showStatus(string);
                this.setToolTipText(string);
            }
            if (element != null && element.getElementType() == 2) {
                this.setToolTipText(((Edge)element).getLabel());
            }
        }
        super.setHoverElement(element, bl);
        if (this.getHoverElement() == null) {
            this.explorer.getAppletContext().showStatus("");
        }
    }

    protected void logoClicked(MouseEvent mouseEvent) {
        super.logoClicked(mouseEvent);
        try {
            this.explorer.getAppletContext().showDocument(new URL(homepageUrl));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        if (this.isOnLogo(mouseEvent.getPoint())) {
            this.explorer.getAppletContext().showStatus(homepageUrl);
        }
    }

    public void nodeClicked(int n, Node node) {
        Object object;
        AttributeManager attributeManager = this.getGraph().getAttributeManager();
        String string = (String)attributeManager.getAttribute("xlink:href", node);
        if (string != null && string.charAt(0) == '#' && (object = this.getGraph().getElement(string.substring(1))).getElementType() == 1) {
            this.centerNode((Node)object);
        }
        if (string != null && string.charAt(0) != '#') {
            object = (String)attributeManager.getAttribute("xlink:show", node);
            String string2 = this.getPropertyManager().getString("hypergraph.applications.hexplorer.GraphPanel.target");
            String string3 = null;
            if (object != null && ((String)object).equals("replace")) {
                string3 = "_self";
            }
            if (object != null && ((String)object).equals("new")) {
                string3 = "_blank";
            }
            if (string3 == null && string2 != null) {
                string3 = string2;
            }
            if (string3 == null) {
                string3 = "_self";
            }
            try {
                URL uRL = new URL(this.explorer.getDocumentBase(), string);
                AppletContext appletContext = this.explorer.getAppletContext();
                appletContext.showDocument(uRL, string3);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        if (string == null) {
            super.nodeClicked(n, node);
        }
    }
}

