/*
    TCFbECell.h    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbECellH
#define TCFbECellH
//---------------------------------------------------------------------------
#include <Math.hpp>
#include "TCFbEToolkit.h"
//---------------------------------------------------------------------------
class TCFbECell : public TObject
{
public:
    virtual void __fastcall SetValue(double value) {
        this->FEnabled = true;
        this->FValue = value;
    }

    virtual double __fastcall GetValue(void){
        if (!this->FEnabled) {
            throw EInvalidArgument("The cell's value is unavailable.");
        }
        return this->FValue;
    }

    virtual bool __fastcall     GetEnabled(void)        { return this->FEnabled; }
    virtual void __fastcall     SetEnabled(bool Value)  { this->FEnabled = Value; }
    virtual double __fastcall   GetRank(void)           { return this->FRank; }
    virtual void __fastcall     SetRank(double Value)   { this->FRank = Value; }

    virtual __fastcall TCFbECell(void);                    // RXgN^i肳ĂȂgNX𐶐
    virtual __fastcall TCFbECell(double value);            // RXgN^i肳Ă郁gNX𐶐
    virtual __fastcall TCFbECell(TCFbECell* Source);    // Rs[RXgN^
    __fastcall ~TCFbECell();                                // fXgN^
    virtual void __fastcall Assign(TCFbECell* Source);    // this ̊el Source ̊el

protected:
    double  FValue;
    bool    FEnabled;
    double  FRank;

private:

};

//---------------------------------------------------------------------------
// I[_OɎgpr֐
//---------------------------------------------------------------------------
// ~\[g
// > 0 ()    Item1  Item2 菬
//   0    Item1  Item2 
// < 0 ()    Item1  Item2 傫
int __fastcall CompareCell(void *Item1, void *Item2)
{
    if (TCFbEToolkit::GetToolkit()->Equals(((TCFbECell*)Item1)->GetValue(), ((TCFbECell*)Item2)->GetValue())) {
        return 0;
    } else if ( ((TCFbECell*)Item1)->GetValue() < ((TCFbECell*)Item2)->GetValue() ) {
        return 1;
    } else {
        return -1;
    }
}

//---------------------------------------------------------------------------
#endif
