// LinearHtmlDocumenterConfig.cs - the MsdnHelp documenter config class
// Copyright (C) 2001  Kral Ferch, Jason Diamond
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

using System;
using System.ComponentModel;
using System.Drawing.Design;
using System.IO;
// In mono 0.25, most classes that should actually be in the System.Design assembly
// are in the System.Windows.Forms assembly.
#if !MONO 
using System.Windows.Forms.Design;
#endif

using NDoc.Core;

namespace NDoc.Documenter.LinearHtml
{
	/// <summary>The LinearHtmlDocumenterConfig class.</summary>
	public class LinearHtmlDocumenterConfig : BaseDocumenterConfig
	{
		/// <summary>Initializes a new instance of the MsdnHelpConfig class.</summary>
		public LinearHtmlDocumenterConfig() : base("LinearHtml")
		{
			_OutputDirectory = @".\doc\";
			_Title = "NDoc ō쐬ꂽNX Cu";
			_HeaderHtml = string.Empty;
			_FooterHtml = string.Empty;
			_FilesToInclude = string.Empty;
			_IncludeHierarchy = false;
			_SortTOCByNamespace = true;

			_NamespaceExcludeRegexp = string.Empty;
			_TypeIncludeRegexp = string.Empty;
			_MethodParametersInTable = false;
			_IncludeTypeMemberDetails = false;
		}

		bool _IncludeTypeMemberDetails;

		/// <summary>Gets or sets the IncludeTypeMemberDetails property.</summary>
		[Category("LinearHtml ̃X^Cݒ")]
		[Description(""
			+ "hLgɃo(\bhAtB[hAvpeBȂ)̏ڍׂڂ邩ǂݒ肵܂B"
			+ "tB[hƃvpeB̏ꍇAe[u remarks ܂ł邩ǂӖ܂B"
			+ "\bh̏ꍇA\bh̏ڍ(p[^Ȃ)ʁX̃TuZNVɍL邩ǂӖ܂B")]
		public bool IncludeTypeMemberDetails
		{
			get { return _IncludeTypeMemberDetails; }

			set
			{
				_IncludeTypeMemberDetails = value;
				SetDirty();
			}
		}


		string _OutputDirectory;

		/// <summary>Gets or sets the OutputDirectory property.</summary>
		[Category("hLg̍\")]
		[Description("쐬 *.html t@C̏o͐B")]
#if !MONO //System.Windows.Forms.Design.FolderNameEditor is not implemented in mono 0.25
		[Editor(typeof(FolderNameEditor), typeof(UITypeEditor))]
#endif
		public string OutputDirectory
		{
			get { return _OutputDirectory; }

			set
			{
				_OutputDirectory = value;

				if (!_OutputDirectory.EndsWith("\\"))
				{
					_OutputDirectory += "\\";
				}

				SetDirty();
			}
		}

		private bool _MethodParametersInTable;

		/// <summary>Gets or sets the MethodParametersInTable property.</summary>
		[Category("LinearHtml ̃X^Cݒ")]
		[Description("\bhƓe[u̒ɁA"
			+ "\bh̃p[^ڂ邩ǂݒ肵܂B")]
		public bool MethodParametersInTable
		{
			get { return _MethodParametersInTable; }

			set
			{
				_MethodParametersInTable = value;
				SetDirty();
			}
		}


		private string _TypeIncludeRegexp;

		/// <summary>Gets or sets the TypeIncludeRegexp property.</summary>
		[Category("hLg̍\")]
		[Description("^̂̐K\B"
			+ "w肷ƁAY^̂̂o͂悤ɂȂ܂B")]
		public string TypeIncludeRegexp
		{
			get { return _TypeIncludeRegexp; }

			set
			{
				_TypeIncludeRegexp = value;
				SetDirty();
			}
		}

		private string _NamespaceExcludeRegexp;

		/// <summary>Gets or sets the NamespaceExcludeRegexp property.</summary>
		[Category("hLg̍\")]
		[Description("OԂ̐K\B")]
		public string NamespaceExcludeRegexp
		{
			get { return _NamespaceExcludeRegexp; }

			set
			{
				_NamespaceExcludeRegexp = value;
				SetDirty();
			}
		}

		private string _Title;

		/// <summary>Gets or sets the Title property.</summary>
		[Category("hLg̍\")]
		[Description("ey[W̏iɕ\^CgB")]
		public string Title
		{
			get { return _Title; }

			set 
			{ 
				_Title = value; 
				SetDirty();
			}
		}

		private bool _IncludeHierarchy;

		/// <summary>Gets or sets the IncludeHierarchy property.</summary>
		[Category("hLg̍\")]
		[Description("OԂւ̃NXKwy[WǉIvVBNXKwɂ킽ĂƁANDoc ̏xxȂAłȂƂ܂B̂悤ȏ󋵂ꍇ False ɐݒ肵ĂB")]
		public bool IncludeHierarchy
		{
			get { return _IncludeHierarchy; }

			set 
			{ 
				_IncludeHierarchy = value; 
				SetDirty();
			}
		}

		bool _SortTOCByNamespace;

		/// <summary>Gets or sets the SortTOCByNamespace property.</summary>
		[Category("hLg̍\")]
		[Description("TOC ̕ёւ𖼑OԂ̖̂ōs܂B "
			+ "̃IvVݒ肳ƁASplitTOCs IvV͖ɂȂ܂B")]
		public bool SortTOCByNamespace
		{
			get { return _SortTOCByNamespace; }

			set
			{
				_SortTOCByNamespace = value;
				SetDirty();
			}
		}

		string _HeaderHtml;

		/// <summary>Gets or sets the HeaderHtml property.</summary>
		[Category("hLg̍\")]
		[Description("K̃u[oi[̑Ƀy[Wwb_ƂĎgp鐶HTMLB " +
			"\"%FILE_NAME%\" ݂HTMLt@CɓIɒu܂B " +
			"\"%TOPIC_TITLE%\" ݂̃y[W̃^CgɓIɒu܂B")]
		[Editor(typeof(TextEditor), typeof(UITypeEditor))]
		public string HeaderHtml
		{
			get { return _HeaderHtml; }

			set
			{
				_HeaderHtml = value;
				SetDirty();
			}
		}

		string _FooterHtml;

		/// <summary>Gets or sets the FooterHtml property.</summary>
		[Category("hLg̍\")]
		[Description("K̃tb^[̑Ƀy[Wtb^[ƂĎgp鐶HTMLB " +
			"\"%FILE_NAME%\" ݂HTMLt@CɓIɒu܂B " +
			"\"%ASSEMBLY_NAME%\" ݂̃y[W̃AZuɓIɒu܂B " +
			"\"%ASSEMBLY_VERSION%\" ݂̃y[W̃AZũo[WԍɓIɒu܂B " +
			"\"%TOPIC_TITLE%\" ݂̃y[W̃^CgɓIɒu܂B")]
		[Editor(typeof(TextEditor), typeof(UITypeEditor))]
		public string FooterHtml
		{
			get { return _FooterHtml; }

			set
			{
				_FooterHtml = value;
				SetDirty();
			}
		}

		string _FilesToInclude;

		/// <summary>Gets or sets the FilesToInclude property.</summary>
		[Category("hLg̍\")]
		[Description("RpCꂽ *.chm t@CɊ܂߂Ot@CB t@C̎w̓pCv (\"|\") ŋ؂Ďw肵ĂB")]
		public string FilesToInclude
		{
			get { return _FilesToInclude; }

			set
			{
				_FilesToInclude = value;
				SetDirty();
			}
 		}

	}
}
