// AssemblySlashDoc.cs - represents an assembly and /doc pair
// Copyright (C) 2001  Kral Ferch, Jason Diamond
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

using System;

namespace NDoc.Core
{
	/// <summary>Represents an assembly and /doc pair.</summary>
	public class AssemblySlashDoc
	{
		string  assemblyFilename;
		string  slashDocFilename;

		/// <summary>Initializes a new instance of the AssemblySlashDoc class.</summary>
		public AssemblySlashDoc()
		{
		}

		/// <summary>Initializes a new instance of the AssemblySlashDoc class
		/// to the values indicated.</summary>
		/// <param name="assemblyFilename">An assembly filename.</param>
		/// <param name="slashDocFilename">A /doc filename.</param>
		public AssemblySlashDoc(string assemblyFilename, string slashDocFilename)
		{
			this.assemblyFilename = assemblyFilename;
			this.slashDocFilename = slashDocFilename;
		}

		/// <summary>Gets or sets the assembly filename in this pair.</summary>
		public string AssemblyFilename
		{
			get { return assemblyFilename; }
			set { assemblyFilename = value; }
		}

		/// <summary>Gets or sets the /doc filename in this pair.</summary>
		public string SlashDocFilename
		{
			get { return slashDocFilename; }
			set { slashDocFilename = value; }
		}
	}
}
