#ifndef __DIR_INFO_H__
#define __DIR_INFO_H__

#include <nds.h>

#include <vector>
#include <string>

#include "gba_nds_fat.h"

using namespace std;


class CFile_Info{
public:
	CFile_Info(const int idx, const int type, const u32 size, const char *name, const char *name_long)
		: idx(idx), type(type), size(size), name(name), name_long(name_long)
	{
		//iprintf( "> i:%d t:%d n:%s ln%d\n", idx, type, name, name_long );
	}

	CFile_Info(const CFile_Info& obj)
		: idx(obj.idx), type(obj.type), size(obj.size), name(obj.name), name_long(obj.name_long)
	{
		//iprintf( "[%d]", idx );
	}

	virtual ~CFile_Info(void)
	{
		//iprintf( "{%d}", idx );

		name.clear();
		name_long.clear();
	}

//private:
	int	idx;
	int	type;
	u32 size;
	std::string name;
	std::string name_long;
};



class CDir_Info
{
public:
	CDir_Info(void)
	{
		current_path = "";
	}

	virtual ~CDir_Info(void)
	{
		vec_files.clear();
	}

	bool chdir(const char* path)
	{
		if( !FAT_chdir( path ) )
		{
			return false;
		}

		vec_files.clear();
		current_path = path;

		int idx, type;
		char fname[512], fname_long[512];
		idx = 0;
		type = FAT_FindFirstFile(fname);
		while( type != 0 )
		{
			FAT_GetLongFilename(fname_long);

			u32 size = 0;
			if( type == 1 )
			{
				size = FAT_GetFileSize();
			}

			CFile_Info file( idx, type, size, fname, fname_long );
			vec_files.push_back( file );

			type = FAT_FindNextFile(fname);
			idx++;
		}
		return true;
	}

//private:
	std::string current_path;
	std::vector< CFile_Info > vec_files;

};


#endif
