#include "fileselect.h"

#include "enum.h"

using namespace std;

bool CFileSelect::drawSelect( unsigned short *dest, int current_idx, CDir_Info& dir )
{
	//CNDSFont_Draw::PrintLandscape( font_16, dest, 0, 0, "hopgehohge" );

	int start_idx = 0;
	int end_idx = dir.vec_files.size();

	int display_max_count = 10;

	if( display_max_count <= current_idx )
	{
		start_idx = current_idx - (display_max_count - 1);

		CNDSFont_Draw::PrintLandscape( font_16, dest, SCREEN_WIDTH - FONT_SIZE * 2, FONT_SIZE, "<<<", RGB15( 0, 0, 0), RGB15(31,31,31) );
	}

	if( (start_idx + display_max_count) < end_idx )
	{
		end_idx = start_idx + display_max_count;

		CNDSFont_Draw::PrintLandscape( font_16, dest, SCREEN_WIDTH - FONT_SIZE * (2+display_max_count+1), FONT_SIZE, ">>>", RGB15( 0, 0, 0), RGB15(31,31,31) );
	}
		

	int idx;
	char buff[512];
	for( idx = start_idx ; idx < end_idx ; idx++ )
	{
		u16 fore_color, back_color;

		fore_color = (idx == current_idx ? RGB15(31, 0, 0) : RGB15( 0, 0, 0));
		back_color = (idx == current_idx ? RGB15(29,29,29) : RGB15(31,31,31));

		if( dir.vec_files[idx].type == 1 )
		{
			strcpy( buff, dir.vec_files[idx].name_long.c_str() );
		}
		else if( dir.vec_files[idx].type == 2 )
		{
			strcpy( buff, "[" );
			strcat( buff, dir.vec_files[idx].name_long.c_str() );
			strcat( buff, "]" );
		}
		else
		{
			strcpy( buff, "(Unknown)" );
			strcat( buff, dir.vec_files[idx].name_long.c_str() );
		}

		CNDSFont_Draw::PrintLandscape( font_16, dest, SCREEN_WIDTH - FONT_SIZE * ((idx-start_idx)+3), FONT_SIZE, buff, fore_color, back_color );
	}

	return true;
}
