#ifndef __FONT_H__
#define __FONT_H__

#include <nds.h>
#include <map>

#include "enum.h"


//	tHg`]
class CRect {
	
public:
	typedef enum{
		ROT_NORMAL = 0,
		ROT_90	= 1,
		ROT_180	= 2,
		ROT_MIRROR	= 3,
	} ENUM_ROT;

	CRect( const u8 *array, const int line_width ) : rect( array ), line_width(line_width) {}

	void Blt( u16 *dest
		, int x1 , int y1 , int x2 , int y2, int w , int h
		, ENUM_ROT rotate, u16 fore_color, u16 back_color )
	{
		if( rect == NULL || line_width <= 0 )
			return;

		const int src_start = x1 + y1 * SCREEN_WIDTH; 
		const int dst_start = x2 + y2 * line_width;

		const int screen_max = SCREEN_WIDTH*SCREEN_HEIGHT;
		for( int i = 0 ; i < h ; i++ ) {
			for( int j = 0 ; j < w ; j++) {
				
				int check  = src_start+j+i*SCREEN_WIDTH;

				if( rotate == ROT_90 )
				{
					check  = src_start+(h-i-2)+j*SCREEN_WIDTH;
				}
				else if( rotate == ROT_180 )
				{
					check  = src_start+(w-j-2)+(h-i-1)*SCREEN_WIDTH;
				}
				else if( rotate == ROT_MIRROR )
				{
					check  = src_start+(w-j-2)+i*SCREEN_WIDTH;
				}

				if( check  > screen_max || check < 0 ) return;

				//dest[ check ] = rect[ dst_start+j+i*rect_width ] * 0xFFFF;
				//dest[ check ] = (u16)(rect[ dst_start+j+i*rect_width ]) * ((u16)(RGB15(31,0,0)) | (u16)(0x8000));

				dest[ check ] = (u16)(rect[ dst_start+j+i*line_width ] == 0 ? back_color : fore_color ) | (u16)(0x8000);
			}
		}
	}
	
private:
	const u8 *rect;
	const int line_width;
};


class CNDSFont_Draw;

class CNDSFont_Info{
	//EUCx[XB

public:
	friend class CNDSFont_Draw;

	CNDSFont_Info(const u8 *font_half, const u8 *font_full
		, int half_size, int full_size
		, int half_char_par_line, int full_char_par_line, int full_offset )
			:  half_size(half_size), full_size(full_size)
			 , half_char_par_line(half_char_par_line), full_char_par_line(full_char_par_line)
			 , full_offset(full_offset)
	{
		font_rect_half = new CRect( font_half, half_size * half_char_par_line );
		font_rect_full = new CRect( font_full, full_size * full_char_par_line );

		map_special_char.clear();
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1a2 , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1a3 , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1a4 , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1a5 , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1bc , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1bd , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1be , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1c1 , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1c2 , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1c3 , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1c4 , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1c5 , CRect::ROT_MIRROR ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1ca , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1cb , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1cc , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1cd , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1ce , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1cf , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d0 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d1 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d2 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d3 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d4 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d5 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d6 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d7 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d8 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1d9 , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1da , CRect::ROT_180 ) );
		map_special_char.insert( std::pair<int,CRect::ENUM_ROT>( 0xa1db , CRect::ROT_180 ) );
	}

	virtual ~CNDSFont_Info()
	{
		delete font_rect_half;
		delete font_rect_full;

		map_special_char.clear();
	}

	CRect::ENUM_ROT is_special_char( u16 char_code )
	{
		std::map< int, CRect::ENUM_ROT >::iterator p;
		p = map_special_char.find( (int)char_code );

		if( p != map_special_char.end() )
		{
			return p->second;
		}
		else
		{
			return CRect::ROT_NORMAL;
		}
	}


private:
	CRect *font_rect_half;
	CRect *font_rect_full;

	int half_size, full_size;
	int half_char_par_line, full_char_par_line;
	int full_offset;
	
	std::map< int, CRect::ENUM_ROT > map_special_char;
};


class CNDSFont_Draw{

public:

	CNDSFont_Draw()
	{
	}

	virtual ~CNDSFont_Draw()
	{
	}

	static void Print( CNDSFont_Info *font_info, u16 *&dest , int x , int y , const char *str )
	{
		PrintCommon( font_info, dest , x , y , str, SCREEN_WIDTH, SCREEN_HEIGHT, 1, 0, CRect::ROT_NORMAL, RGB15(0,0,0), RGB15(31,31,31), false );
	}

	static void PrintVertical( CNDSFont_Info *font_info, u16 *&dest , int x , int y , const char *str )
	{
		PrintCommon( font_info, dest , x , y , str, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 1, CRect::ROT_NORMAL, RGB15(0,0,0), RGB15(31,31,31), true );
	}


	static void PrintLandscape( CNDSFont_Info *font_info, u16 *&dest , int x , int y , const char *str )
	{
		PrintCommon( font_info, dest , x , y , str, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 1, CRect::ROT_90, RGB15(0,0,0), RGB15(31,31,31), false );
	}

	static void PrintLandscape( CNDSFont_Info *font_info, u16 *&dest , int x , int y , const char *str, u16 fore_color, u16 back_color )
	{
		PrintCommon( font_info, dest , x , y , str, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 1, CRect::ROT_90, fore_color, back_color, false );
	}

	static void PrintLandscapeVirtical( CNDSFont_Info *font_info, u16 *&dest , int x , int y , const char *str )
	{
		PrintCommon( font_info, dest , x , y , str, SCREEN_WIDTH, SCREEN_HEIGHT, -1, 0, CRect::ROT_90, RGB15(0,0,0), RGB15(31,31,31), true );
	}


	static void PrintCommon(
		CNDSFont_Info *font_info, u16 *&dest
		, int x , int y , const char *str, int clip_x, int clip_y, int delta_x, int delta_y
		, CRect::ENUM_ROT rotate, u16 fore_color, u16 back_color, bool is_proc_spchar )
	{
		int length = strlen( str );	
		
		int xd = 0, yd = 0;		
		for( int i = 0 ; i < length ; )
		{
			if( y + font_info->half_size * yd >= clip_y ) break;	
			if( x + font_info->half_size * xd >= clip_x ) break;	
			
			//	p	
			if( is_half_char( str[i] ) ){
				//	ӂ̌vZ͗]TrbgZɒu
				font_info->font_rect_half->Blt( dest , x  + font_info->half_size * xd , y + font_info->half_size * yd,
					//	] x W
					 (str[i] % font_info->half_char_par_line) * font_info->half_size ,
					//	] y W
					 (str[i] / font_info->half_char_par_line) * font_info->full_size,
					//	]TCY
					 font_info->half_size , font_info->full_size,
					 rotate, fore_color, back_color );

				i++;

				if( rotate == CRect::ROT_NORMAL )
				{
					xd += (delta_x != 0 ? 1 : font_info->full_size / font_info->half_size * delta_x );
					yd += (delta_y != 0 ? font_info->full_size / font_info->half_size * delta_y : 0 );
				}
				else if( rotate == CRect::ROT_90 )
				{
					xd += (delta_x != 0 ? font_info->full_size / font_info->half_size * delta_x : 0);
					yd += (delta_y != 0 ? 1 : font_info->full_size / font_info->half_size * delta_y );
				}

			}
			//	Sp
			else if( is_full_char( str[i] ) ){
				
				unsigned int pos = font_info->full_offset;
				unsigned int kukaku_char_count = 0xff - 0xA0 + 1 - 2;
				//	section 1
				if( str[i] < 0xB0 ) {
					pos += (str[i] - 0xA1) * kukaku_char_count + str[i+1] - 0xA1;
				}
				//	section 2
				else {
				    pos += (str[i] - 0xB0) * kukaku_char_count + str[i+1] - 0xA1 + (kukaku_char_count * 15);	//15敪ItZbg
				}

				CRect::ENUM_ROT proc_rotate = rotate;
				u16 char_code = (((u16)(str[i])) << 8) + ((u16)(str[i+1]));
				if( is_proc_spchar == true && font_info->is_special_char( char_code ) != CRect::ROT_NORMAL )
				{
					proc_rotate = font_info->is_special_char( char_code );
				}

				if( char_code <= stop_code_euc )
				{
					//	ӂ̌vZ͗]TrbgZɒu
					font_info->font_rect_full->Blt( dest , x + font_info->half_size * xd , y + font_info->half_size * yd,
						( pos % font_info->full_char_par_line ) * font_info->full_size,
						( pos / font_info->full_char_par_line ) * font_info->full_size,
				 		font_info->full_size , font_info->full_size,
						proc_rotate, fore_color, back_color );
				}
				
				i += 2;
				xd += font_info->full_size / font_info->half_size * delta_x;
				yd += font_info->full_size / font_info->half_size * delta_y;
			}
		}
	}

private:
	
	static const int stop_code_euc = 0xf4a6;

	inline static bool is_half_char( unsigned char c ) { return c < 0xA1; }
	inline static bool is_full_char( unsigned char c ) { return (c - 0xA1) <= 94; }
};


#endif
