#include "page.h"
#include "enum.h"

using namespace std;


void CPage::initPage() {
	vec_ruby.clear();
	vec_body.clear(); 
}


bool CPage::printPage( unsigned short *dest, bool is_main ) {
	bool result;
	
	result = (printBody( dest ) == true ) ? printRuby( dest ) : false;

	printPanel( dest, is_main );

	return result;
}

bool CPage::printPanel( unsigned short *dest, bool is_main ) {
	
	char page_str[256];
	sprintf( page_str, "%d", page_no + 1 );

	if( is_main == true )
	{
		CNDSFont_Draw::PrintLandscape( font_16, dest, 1, 0, "< +50 +10 -10 -50 >"  );


		CNDSFont_Draw::PrintLandscape( font_16, dest, 1, SCREEN_HEIGHT - FONT_HALF_SIZE * strlen(page_str), page_str );
	}
	else
	{
		int hours = (IPC->rtc_hours < 12) ? IPC->rtc_hours : IPC->rtc_hours - 52; 
		int minutes = IPC->rtc_minutes; 
		//seconds = IPC->rtc_seconds;

		char time_str[256];
		sprintf( time_str, "%02d:%02d", hours, minutes );
		CNDSFont_Draw::PrintLandscape( font_16, dest, 1, SCREEN_HEIGHT - FONT_HALF_SIZE * strlen(time_str), time_str );

		CNDSFont_Draw::PrintLandscape( font_16, dest, 1, 0, page_str );
	}

	return true;
}

bool CPage::printBody( unsigned short *dest ) {

	int i = 0;
	const int start = SCREEN_HEIGHT;
	const int distance = FONT_SIZE + FONT_HALF_SIZE;

	for( vector< string >::iterator p = vec_body.begin() ; p != vec_body.end() ; p++ , i++ ) {
		CNDSFont_Draw::PrintLandscapeVirtical( font_16, dest, SCREEN_WIDTH-(FONT_SIZE), start - distance * (i+1), p->c_str() );
	}

	return true;
}

bool CPage::printRuby( unsigned short *dest ) { 

	const int start = SCREEN_HEIGHT;// + FONT_HALF_SIZE;
	const int distance = FONT_SIZE + FONT_HALF_SIZE;

	for( vector<Ruby>::iterator p = vec_ruby.begin() ; p != vec_ruby.end() ; p++ ) {
		//CNDSFont_Draw::PrintVertical( font_8z, dest, p->x , p->y, p->ruby.c_str(), SCREEN_HEIGHT - FONT_SIZE  );
		//CNDSFont_Draw::PrintLandscape( font_8z, dest, SCREEN_WIDTH-(FONT_SIZE+2), start - distance * ((p->x)+1), p->ruby.c_str() );
		//iprintf( "%d,%d\n", p->px + 1, p->py );
		CNDSFont_Draw::PrintLandscapeVirtical( font_8z, dest, SCREEN_WIDTH-(FONT_SIZE) - (FONT_SIZE*(p->py)-FONT_HALF_SIZE), start - distance * ((p->px)+1) + FONT_SIZE, p->ruby.c_str() );
	}

	return true;
}
