#ifndef __PAGE_H__
#define __PAGE_H__

#include <vector>
#include <string>
#include "ndsfont.h"

#include "font8k_bin.h"
#include "font16h_bin.h"
#include "font16k_bin.h"

typedef struct Ruby{
	std::string ruby;	//	r
	int	space;			//	
	int x,y;			//	n_x,y
	int px,py;			//@y[WAPʂx,y
}Ruby;

class CNobelParser;

class CPage{

public:
	friend class CNobelParser;
	CPage() :
		 font_16(new CNDSFont_Info( font16h_bin, font16k_bin, FONT_HALF_SIZE, FONT_SIZE, NUM_OF_LINE_HALF_FONT, NUM_OF_LINE_FONT, FONT_FULL_OFFSET ))
		,font_8z(new CNDSFont_Info(        NULL,  font8k_bin, FONT2_HALF_SIZE, FONT2_SIZE, FONT2_NUM_OF_LINE_HALF_FONT, FONT2_NUM_OF_LINE_FONT, FONT2_FULL_OFFSET ))
	{}

	bool printPanel( unsigned short *dest, bool is_main );
	bool printPage( unsigned short *dest, bool is_main );
private:
	bool printBody( unsigned short *dest );
	bool printRuby( unsigned short *dest );
	void initPage();

	std::vector< Ruby > vec_ruby;			//	r
	std::vector< std::string > vec_body;	//	{

	int page_no;

	CNDSFont_Info *font_16;
	CNDSFont_Info *font_8z;

//	CNDSFont  font;
//	CNDSFont2 font2;

};

#endif
