/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QGroupBox;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QSpinBox;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;

public class ConfigIndexPage
extends QWidget {
    private final QSpinBox weightSpinner;
    private final QSpinBox sleepSpinner;
    private final QCheckBox indexAttachmentsLocally;
    private final QCheckBox indexImageRecognition;
    private final QCheckBox indexTitle;
    private final QCheckBox automaticWildcard;
    private final QLineEdit specialStrip;
    private final QCheckBox indexBody;
    private final QLineEdit regexEdit;

    public ConfigIndexPage(QWidget parent) {
        QGroupBox weightGroup = new QGroupBox(this.tr("Recognition"));
        QLabel weightLabel = new QLabel(this.tr("Minimum Recognition Weight"));
        this.weightSpinner = new QSpinBox();
        this.weightSpinner.setRange(1, 100);
        this.weightSpinner.setSingleStep(1);
        this.weightSpinner.setValue(Global.getRecognitionWeight());
        QHBoxLayout weightLayout = new QHBoxLayout();
        weightLayout.addWidget((QWidget)weightLabel);
        weightLayout.addWidget((QWidget)this.weightSpinner);
        weightGroup.setLayout((QLayout)weightLayout);
        QGroupBox attachmentGroup = new QGroupBox(this.tr("Content"));
        this.indexBody = new QCheckBox(this.tr("Index Note Body"));
        this.indexBody.setChecked(Global.indexNoteBody());
        this.indexTitle = new QCheckBox(this.tr("Index Note Title"));
        this.indexTitle.setChecked(Global.indexNoteTitle());
        this.indexAttachmentsLocally = new QCheckBox(this.tr("Index Attachments Locally"));
        this.indexAttachmentsLocally.setChecked(Global.indexAttachmentsLocally());
        this.indexImageRecognition = new QCheckBox(this.tr("Index Image Recognition"));
        this.indexImageRecognition.setChecked(Global.indexImageRecognition());
        this.automaticWildcard = new QCheckBox(this.tr("Automatically Wildcard All Searches"));
        this.automaticWildcard.setChecked(Global.automaticWildcardSearches());
        this.specialStrip = new QLineEdit();
        this.specialStrip.setText(Global.getSpecialIndexCharacters());
        QVBoxLayout attachmentLayout = new QVBoxLayout();
        attachmentLayout.addWidget((QWidget)this.indexBody);
        attachmentLayout.addWidget((QWidget)this.indexTitle);
        attachmentLayout.addWidget((QWidget)this.indexAttachmentsLocally);
        attachmentLayout.addWidget((QWidget)this.indexImageRecognition);
        attachmentLayout.addWidget((QWidget)this.automaticWildcard);
        QHBoxLayout specialCharLayout = new QHBoxLayout();
        specialCharLayout.addWidget((QWidget)new QLabel(this.tr("Special Word Characters")));
        specialCharLayout.addWidget((QWidget)this.specialStrip);
        attachmentLayout.addLayout((QLayout)specialCharLayout);
        attachmentGroup.setLayout((QLayout)attachmentLayout);
        QGroupBox sleepGroup = new QGroupBox(this.tr("Index Interval"));
        QLabel sleepLabel = new QLabel(this.tr("Seconds between looking for unindexed notes"));
        this.sleepSpinner = new QSpinBox();
        this.sleepSpinner.setRange(30, 600);
        this.sleepSpinner.setSingleStep(1);
        this.sleepSpinner.setValue(Global.getIndexThreadSleepInterval());
        QHBoxLayout sleepLayout = new QHBoxLayout();
        sleepLayout.addWidget((QWidget)sleepLabel);
        sleepLayout.addWidget((QWidget)this.sleepSpinner);
        sleepGroup.setLayout((QLayout)sleepLayout);
        QGroupBox regexGroup = new QGroupBox(this.tr("Word Parse"));
        QLabel regexLabel = new QLabel(this.tr("Regular Expression"));
        this.regexEdit = new QLineEdit();
        this.regexEdit.setText(Global.getWordRegex());
        QHBoxLayout regexLayout = new QHBoxLayout();
        regexLayout.addWidget((QWidget)regexLabel);
        regexLayout.addWidget((QWidget)this.regexEdit);
        regexGroup.setLayout((QLayout)regexLayout);
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addWidget((QWidget)sleepGroup);
        mainLayout.addWidget((QWidget)weightGroup);
        mainLayout.addWidget((QWidget)attachmentGroup);
        mainLayout.addWidget((QWidget)regexGroup);
        mainLayout.addStretch(1);
        this.setLayout((QLayout)mainLayout);
    }

    public boolean getIndexAttachmentsLocally() {
        return this.indexAttachmentsLocally.isChecked();
    }

    public boolean getIndexNoteBody() {
        return this.indexBody.isChecked();
    }

    public boolean getIndexNoteTitle() {
        return this.indexTitle.isChecked();
    }

    public String getSpecialCharacters() {
        return this.specialStrip.text();
    }

    public boolean getIndexImageRecognition() {
        return this.indexImageRecognition.isChecked();
    }

    public boolean getAutomaticWildcardSearches() {
        return this.automaticWildcard.isChecked();
    }

    public void setSleepInterval(int len) {
        this.sleepSpinner.setValue(len);
    }

    public int getSleepInterval() {
        return this.sleepSpinner.value();
    }

    public void setRecognitionWeight(int len) {
        this.weightSpinner.setValue(len);
    }

    public int getRecognitionWeight() {
        return this.weightSpinner.value();
    }

    public void setRegex(String s) {
        this.regexEdit.setText(s);
    }

    public String getRegex() {
        return this.regexEdit.text();
    }
}

