# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Profile.pm 75 2008-05-17 06:08:58Z nekotama $

package Nekorum::App::Profile;

use strict;

use MT;
use Nekorum::Util;

sub _edit_profile {
  my $app = shift;

  my %params = $app->param_hash;
  my $static = $app->param('static') or return $app->errtrans('Undefined return path.');
  my $author_id = $app->param('author_id') or return $app->errtrans('Permission denied.');
  my $name = $app->param('name') or return $app->errtrans('Undefined user name.');
  delete $params{'name'};
  my $email = $app->param('email') or return $app->errtrans('Undefined E-mail.');
  delete $params{'email'};
  my $nickname = $app->param('nickname');
  my $url = $app->param('url');

  # author session
  my $author = Nekorum::Util->_get_author($app);
  return $app->errtrans("Session timeout.") unless($author);
  $app->{author} = $author;

  return $app->errtrans('Permission denied.') if($author_id!=$author->id);

	$author->name($name);
	$author->email($email);
	$author->nickname($nickname);
	$author->url($url);

  $author->save or die $author->errstr;

	$app->redirect($static);
}

1;