# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Topic.pm 84 2008-05-19 05:59:07Z nekotama $

package Nekorum::App::Topic;

use strict;

use MT;
use Nekorum::Util;

use MT::Util qw( encode_html format_ts offset_time_list offset_time epoch2ts
  remove_html get_entry mark_odd_rows first_n_words
  perl_sha1_digest_hex is_valid_email relative_date ts2epoch
  perl_sha1_digest encode_url dirify encode_js is_valid_date
  archive_file_for is_url );

sub _post_topic {
	my $app = shift;

	return $app->errtrans("This system not use forum plugin.") if(!Nekorum::Util->is_forum_use);
	
	my $blog_id = $app->param('blog_id');
	my $category_id = $app->param('category_id') or return $app->errtrans("Invalid parameter");
	my $text = $app->param('topic_text') or return $app->errtrans("Invalid parameter");
	my $title = $app->param('topic_title') or return $app->errtrans("Invalid parameter");
	my $tags = $app->param('topic_tags') or undef;
	my $keywords = $app->param('topic_keywords') or undef;

	my $type = $app->param('_type') || 'entry';
	my $class = $app->model($type) or return $app->errtrans("Invalid parameter");

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# basename setting
	my $time = time();
	my ($time_s, $time_m, $time_h, $day_d, $day_m, $day_y, $week_w, $year_d, $isdat) = localtime($time);
	my $basename = sprintf("%04d%02d%02d%02d%02d%02d", $day_y+1900, $day_m+1, $day_d, $time_h, $time_m, $time_s);

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);

	# load permission
	require MT::Permission;
	my $permission = MT::Permission->load({ blog_id => $blog_id, author_id => $author_id }) or $app->errtrans("Load permission error.");
	if(!$permission->can_comment){
		return $app->errtrans("Permission denied.");
	}

	$text = Nekorum::Util->_ignore_html($blog, $text);
	
	# save entry
	require MT::Entry;
	my $entry = $class->new;
	$entry->blog_id($blog_id);
	$entry->author_id($author_id);
	$entry->status(MT::Entry::RELEASE());
	$entry->text($text);
	$entry->title($title);
	$entry->category_id($category_id);
	$entry->allow_comments(1);
	$entry->basename($basename);
	$entry->keywords($keywords);

	# save tags
	require MT::Tag;
	my $tag_delim = chr($author->entry_prefs->{tag_delim});
	my @tags = MT::Tag->split($tag_delim, $tags);
	if(@tags){
		$entry->set_tags(@tags);
	} else {
		$entry->remove_tags();
	}

	my $orig_obj;
  $app->run_callbacks('cms_pre_save.' . $type, $app, $entry, $orig_obj) || return $app->error($app->translate("Saving [_1] failed: [_2]", $class->class_label, $app->errstr));
	$entry->save or die $entry->errstr;
  $app->run_callbacks('cms_post_save.' . $type, $app, $entry, $orig_obj);
	
	# save placement
	require MT::Placement;
	my $placement = MT::Placement->new;
	$placement->blog_id($blog_id);
	$placement->entry_id($entry->id);
	$placement->category_id($category_id);
	$placement->is_primary(1);
	$placement->save or die $placement->errstr;

	# rebuild entry
	$app->rebuild_entry(Entry => $entry, BuildDependencies => 1) or return $app->publish_error();
	$app->redirect($entry->permalink);
  $app->_finish_rebuild_ping($entry, 1);
}

sub _edit_topic {
	my $app = shift;

	return $app->errtrans("This system not use forum plugin.") if(!Nekorum::Util->is_forum_use);

	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or return $app->errtrans("Invalid parameter");
	my $text = $app->param('topic_text') or return $app->errtrans("Invalid parameter");
	my $title = $app->param('topic_title') or return $app->errtrans("Invalid parameter");
	my $tags = $app->param('topic_tags');
	my $keywords = $app->param('topic_keywords');

	my $type = $app->param('_type') || 'entry';
	my $class = $app->model($type) or return $app->errtrans("Invalid parameter");

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# basename setting
	my $time = time();
	my ($time_s, $time_m, $time_h, $day_d, $day_m, $day_y, $week_w, $year_d, $isdat) = localtime($time);
	my $modified_on = sprintf("%04d-%02-d%02d %02d:%02d:%02d", $day_y+1900, $day_m+1, $day_d, $time_h, $time_m, $time_s);

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);
	
	# load permission
	require MT::Permission;
	my $permission = MT::Permission->load({ blog_id => $blog_id, author_id => $author_id }) or $app->errtrans("Load permission error.");
	if(!$permission->can_comment){
		return $app->errtrans("Permission denied.");
	}
	
	$text = Nekorum::Util->_ignore_html($blog, $text);
	
	# save entry
	require MT::Entry;
	my $entry = MT::Entry->load({ blog_id => $blog_id, id => $entry_id });
	return $app->errtrans("Permission denied.") if($entry->author_id != $author_id);

	$entry->title($title);
	$entry->text($text);
	$entry->keywords($keywords) if $keywords;
	$entry->modified_by($author_id);

	# save tags
	require MT::Tag;
	my $tag_delim = chr($author->entry_prefs->{tag_delim});
	my @tags = MT::Tag->split($tag_delim, $tags);
	if(@tags){
		$entry->set_tags(@tags);
	} else {
		$entry->remove_tags();
	}

	my $orig_obj;
  $app->run_callbacks('cms_pre_save.' . $type, $app, $entry, $orig_obj) || return $app->error($app->translate("Saving [_1] failed: [_2]", $class->class_label, $app->errstr));
	$entry->save or die $entry->errstr;
  $app->run_callbacks('cms_post_save.' . $type, $app, $entry, $orig_obj);
	
	# rebuild entry
	$app->rebuild_entry(Entry => $entry, BuildDependencies => 1) or return $app->publish_error();
	$app->redirect($entry->permalink);
  $app->_finish_rebuild_ping($entry, 1);
}

sub _remove_topic {
	my $app = shift;

	return $app->errtrans("This system not use forum plugin.") if(!Nekorum::Util->is_forum_use);

	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or return $app->errtrans("Invalid parameter");

	my $type = $app->param('_type') || 'entry';
	my $class = $app->model($type) or return $app->errtrans("Invalid parameter");

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;
	
	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);
	
	# load permission
	require MT::Permission;
	my $permission = MT::Permission->load({ blog_id => $blog_id, author_id => $author_id }) or $app->errtrans("Load permission error.");
	if(!$permission->can_comment){
		return $app->errtrans("Permission denied.");
	}
	
	# delete entry
	require MT::Entry;
	my $entry = MT::Entry->load({ blog_id => $blog_id, id => $entry_id });
	return $app->errtrans("Permission denied.") if($entry->author_id != $author_id && !$author->is_superuser);
	$entry->status(MT::Entry::HOLD);
	$entry->save or die $entry->errstr;
	$app->rebuild_entry(Entry => $entry, BuildDependencies => 1) or return $app->publish_error();
	$entry->remove if(!Nekorum::Util->is_remove_hold);
	if($app->config('DeleteFilesAtRebuild')){
		my $file = archive_file_for($entry, $blog, 'Individual');
		$app->publisher->remove_entry_archive_file(Entry => $entry, ArchiveType => 'Individual');
	}
	$app->redirect($entry->archive_url('Category'));
}

sub _freeze_topic {
	my $app = shift;

	return $app->errtrans("This system not use forum plugin.") if(!Nekorum::Util->is_forum_use);

	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or return $app->errtrans("Invalid parameter");

	my $type = $app->param('_type') || 'entry';
	my $class = $app->model($type) or return $app->errtrans("Invalid parameter");

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);
	
	# load permission
	require MT::Permission;
	my $permission = MT::Permission->load({ blog_id => $blog_id, author_id => $author_id }) or $app->errtrans("Load permission error.");
	return $app->errtrans("Permission denied.") if(!$permission->can_comment);
	
	# save entry
	require MT::Entry;
	my $entry = MT::Entry->load({ blog_id => $blog_id, id => $entry_id });
	return $app->errtrans("Permission denied.") if($entry->author_id != $author_id && !$author->is_superuser);
	$entry->allow_comments(0);
	$entry->save or die $entry->errstr;
	
	# rebuild entry
	$app->rebuild_entry(Entry => $entry, BuildDependencies => 1) or return $app->publish_error();
	$app->redirect($entry->permalink);
}

1;