# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Comment.pm 84 2008-05-19 05:59:07Z nekotama $

package Nekorum::CMS::Comment;

use strict;

use MT;
use Nekorum::Util;

sub _get_commenter_js {
	local $SIG{__WARN__} = sub { };
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my $comment_id = $app->param('comment_id') or undef;
	my $commenter_id = $app->param('commenter_id') or undef;

	# author session
	my $author = Nekorum::Util->_get_author($app);
	my $display = ($author && ($author->id == $commenter_id)) ? 'inline' : 'none';

	$app->{no_print_body} = 1;
	$app->send_http_header("text/javascript");

	my $output = <<JAVA;
function hide_commenter_$comment_id(element){
	element.style.display = '$display';
}
JAVA
	$app->print("$output");

return undef;
}

sub _view_post_comment {
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or return $app->errtrans("Invalid parameter");
	my $comment_id = $app->param('comment_id') or undef;
	my $is_quote = $app->param('quote') or undef;

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id) or die;

	# load template
	require MT::Template;
	my $tmpl = MT::Template->load({ blog_id => $blog_id, type => 'custom', name => 'Nekorum Comment'}) or return $app->errtrans("Load template error.");

	# load entry
	require MT::Entry;
	my $entry = MT::Entry->load({id => $entry_id, blog_id => $blog_id}) or die;

	# quit setting
	my $text;
	if($is_quote){
		if($comment_id){
			require MT::Comment;
			my $comment = MT::Comment->load({id => $comment_id}) or die;
			$text = '<blockquote>' . $comment->text . '</blockquote>';
		} else {
			$text = '<blockquote>' . $entry->text . '</blockquote>';
		}
	}
	
	require MT::Template::Context;
	my $ctx = MT::Template::Context->new;
	my %cond;
	$ctx->stash('blog', $blog);
	$ctx->stash('author', $author);
	$ctx->stash('entry', $entry);
	$ctx->var('blog_id', $blog_id);
	$ctx->var('author_id', $author_id);
	$ctx->var('entry_id', $entry_id);
	$ctx->var('topic_text', $text);
	$ctx->var('parent_id', $comment_id);
	$ctx->var('mode', '_post_comment');

	my $output = $tmpl->build($ctx, \%cond) or return $tmpl->errstr;
	return $output;
}

sub _view_edit_comment {
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or return $app->errtrans("Invalid parameter");
	my $comment_id = $app->param('comment_id') or return $app->errtrans("Invalid parameter");

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load(id => $blog_id);

	# load author
	require MT::Author;
	my $author = MT::Author->load({ id => $author_id }) or die;

	# load comment
	require MT::Comment;
	my $comment = MT::Comment->load({id => $comment_id, blog_id => $blog_id, entry_id => $entry_id});
	my $text = $comment->text;
	return $app->errtrans("Permission denied.") if($comment->commenter_id!=$author_id);

	# load template
	require MT::Template;
	my $tmpl = MT::Template->load({ blog_id => $blog_id, type => 'custom', name => 'Nekorum Comment'}) or return $app->errtrans("Load template error.");

	require MT::Template::Context;
	my $ctx = MT::Template::Context->new;
	my %cond;
	$ctx->stash('blog', $blog);
	$ctx->stash('author', $author);
	$ctx->stash('comment', $comment);
	$ctx->var('blog_id', $blog_id);
	$ctx->var('author_id', $author_id);
	$ctx->var('entry_id', $entry_id);
	$ctx->var('comment_id', $comment_id);
	$ctx->var('mode', '_edit_comment');
	$ctx->var('topic_text', $text);

	my $output = $tmpl->build($ctx, \%cond) or return $tmpl->errstr;
	return $output;
}

1;