<?php
	ob_start ("ob_gzhandler");
	header("Content-type: text/css");
	header("Cache-Control: must-revalidate");
	$offset = 60 * 60;// 60(min) * 60(sec)
	$ExpStr = "Expires: " . 
	gmdate("D, d M Y H:i:s", time() + $offset) . " GMT";
	header($ExpStr);
?>

/*
 *******************************************************************************
 * File : theme.php
 * Copyright (C) 2005-2008 http://bizcaz.com/ All rights reserved.
 *******************************************************************************
 name: forum
 designer: bzbell
 designer_url: http://bizcaz.com/
 developer: bzbell
 developer_url: http://bizcaz.com/
 *******************************************************************************
 */

/*******************************************************************************/
/* デフォルトタグ関連
/*******************************************************************************/
html {
	width: 100%;
	background-color: #fff;
}
body {
	width: 100%;
	min-height: 100%;
	color: #303;
	background-color: #393f4c;
	background: #fff url(images/bg_body.gif) repeat-x left top;
	background-attachment: fixed;
}
a,
a:link,
a:visited {
	color: #455995;
}
a:active,
a:focus {
	color: #303f6b;
	outline: none;
}
a:hover {
	color: #ff1010;
}
pre {
	width: 95%;
	background-color: #fbfaf5;
	border-top: 1px solid #9d8e87;
	border-left: 5px solid #6b395f;
	border-right: 1px solid #dad8d1;
	border-bottom: 1px solid #dad8d1;
}
blockquote {
	margin: 1em 0;
	width: 95%;
	background: transparent url(images/quotes.png) no-repeat left top;
}
blockquote p {
	background: transparent url(images/quotee.png) no-repeat right bottom;
}
cite {
	margin-top: 1em;
	display: block;
}
button,
input,
textarea {
	color: #303;
	background-color: #fff;
	border-top: 1px solid #9d8e87;
	border-left: 1px solid #9d8e87;
	border-right: 1px solid #dad8d1;
	border-bottom: 1px solid #dad8d1;
}
/*******************************************************************************/
/* レイアウト関連
/*******************************************************************************/
#content {
	padding-bottom: 1px;
	width: 960px;
	height: 100%;
	max-height: 100%;
	min-height: 100%;
}
#wrapper {
	padding-top: 120px;
	width: 100%;
	float: left;
}
#alpha {
	margin: 0 180px 0 20px;
	width: 760px;
}
#sidebar {
	margin-left: -160px;
	padding-top: 120px;
	width: 160px;
	height: 100%;
	float: left;
}
/*******************************************************************************/
/* ヘッダー/フッター
/*******************************************************************************/
#bloglogo {
	margin: 0;
	padding: 0;
	width: 100%;
	height: 68px;
	position: fixed !important;
	position: absolute;
	z-index: 6;
	left: 0;
	top: 0;
	line-height: 68px;
	background: #f7f7f7 url(images/bg_logo.gif) repeat-x left top;
}

#pagename {
	margin: 0;
	padding: 0;
	color: #fffffc;
}

#footer {
	width: 100%;
	max-height: 100%;
	min-height: 100%;
	color: #7593a0;
	background-color: #343b40;
	border-top: 2px solid #282b2e;
	border-bottom: 2px solid #ff1010;
}
#footer ul {
	margin: 1em 20px 0 auto;
	width: 100%;
	display: block;
	list-style: none;
	text-align: right;
}
#footer a {
	color: #a0d8ef;
}
#footer a:hover {
	color: #ff1010;
}
* html #footer ul {/*for IE6.x*/
	width: 100%;
}
#footer ul#license {
	margin-right: auto;
	padding-top: 1em;
	height: 48px;
	text-align: center;
	background-color: #000;
	border-top: 1px solid #444850;
}
/*******************************************************************************/
/* ナビバー/パンくずリスト
/*******************************************************************************/
#navibar {
	margin: 0;
	width: 100%;
	height: 20px;
	z-index: 5;
	position: fixed !important;
	position: absolute;
	top: 68px;
	overflow: hidden;
	list-style: none;
	text-align: center;
	background: transparent url(images/bg_topnav.gif) repeat-x top left;
	border-top: solid 1px #2b438f;
	border-bottom: solid 1px #2b438f;
}
#navibar li {
	margin: 0;
	float: left;
}
#navibar li a {
	width: 100px;
	height: 20px;
	line-height: 20px;
	display: block;
}
#breadcrumbs {
	margin: 0;
	height: 20px;
	position: absolute;
	top: 88px;
	left: 0;
	z-index: 4;
	list-style: none;
}
#breadcrumbs li {
	margin: 0;
	float: left;
}
#breadcrumbs li a,
#breadcrumbs li em {
	padding: 0 16px 0 8px;
	height: 20px;
	line-height: 20px;
	float: left;
	font-style: normal;
}
#breadcrumbs li a {
	background: url(images/bg-breadcrumb.png) no-repeat right center;
}
#breadcrumbs li em {
	font-weight: 700;
	color: #ff1010;
}
/*******************************************************************************/
/* サイト検索/フィード
/*******************************************************************************/
#search_results {
	height: 0;
}
#search_form {
	margin: 0;
	height: 68px;
	position: fixed !important;
	position: absolute;
	top: 0;
	right: 0;
	display: block; /*for IE5*/
	z-index: 6;
}
#search_form p {
	margin: 0;
	width: 240px;
	height: 68px;
	position: absolute;
	top: 0;
	right: 0;
	background: transparent url(images/search_text.png) no-repeat right top;
}
#search_form label {
	display: block;
	position: absolute;
	top: 20px;
	left: 0;
	font-size: 90%;
}
#search {
	padding: 0 2px;
	width: 196px;
	height: 19px;
	position: absolute;
	bottom: 8px;
	left: 3px;
	font-family: sans-serif;
	background-color: #fff;
	border: solid 1px #2b438f;
}
#syndicate {
	margin: 0;
	width: 240px;	/*240px＝アイテム幅(80px)×アイテム数(3)*/
	height: 20px;
	z-index: 6;
	position: fixed !important;
	position: absolute;
	top: 68px;
	right: 1em;
	list-style: none;
}
#syndicate li {
	margin: 0;
	padding: 0;
	float: left;
}
#syndicate li a {
	width: 80px;
	height: 20px;
	line-height: 20px;
	display: block;
}
* html #syndicate li a {/*for IE6.x*/
	width: 80px;
}
/*******************************************************************************/
/* フォーラム一覧／トピック一覧共通
/*******************************************************************************/
.separate {
	border-collapse: separate;
}
.gen a,
.gen {
	font-size: 12px;
}
.genmed a,
.genmed {
	font-size: 11px;
}
.gensmall a,
.gensmall {
	font-size: 10px;
}
.forumline {
	margin: 5px 0;
	width: 100%;
	background-color: #f8f8f8;
	border: solid 1px #2b438f;
}
.forumline th {
	background: #fff url(images/bg_th.gif) top left repeat-x;
	color: #455995;
	font-weight: 700;
	font-size: 11px;
	height: 24px;
	padding: 0 5px;
	border: solid 1px #fff;
	border-right-color: #d6d6d6;
	border-bottom-color: #d6d6d6;
	white-space: nowrap;
}
.forumline td {
	padding: 2px;
	line-height: 1em;
}
.forumline td * {
	line-height: 1em;
}
.forumline .row-header {
	padding: 0;
	width: 100%;
	text-align: left;
	background: #354883 url(images/bg_hdr1.gif);
	border: solid 1px #dce1ee;
	border-right-color: #cfdade;
	border-bottom-color: #cfdade;
}
.forumline .new-header {
	background: #354883 url(images/bg_hdr4.gif);
}
.forumline .mod-header {
	background: #354883 url(images/bg_hdr3.gif);
}
.forumline .row-header h2 {
	padding-left: 17px;
	height: 27px;
	font-weight: 700;
	font-size: 12px;
	line-height: 27px;
	color: #edeff4;
	background: transparent url(images/bg_hdr2.gif) no-repeat left center;
}
.forumline .row-header a,
.forumline .row-header a:visited {
	color: #edeff4;
	text-decoration: underline;
}
.forumline .row-header a:hover,
.forumline .row-header a:active {
	color: #c8d0eb;
	text-decoration: underline;
}
.forumline .col1,
.forumline .col2,
.forumline .col3,
.forumline .col4,
.forumline .col5 {
	text-align: center;
	background-color: #f8f8f8;
	border: solid 1px #fff;
	border-right-color: #d6d6d6;
	border-bottom-color: #d6d6d6;
}
.forumline .col2 {
	width: 68%;
	text-align: left;
	font-weight: 700;
}
.topic .col2 {
	width: 70%;
}
.forumline .col2:hover {
	background: #f0f0f0 url(images/bg_row_hover.gif) no-repeat right bottom;
	border-top-color: #f8f8f8;
	border-left-color: #f8f8f8;
	border-bottom-color: #d0d0d0;
	border-right-color: #d0d0d0;
}
.forumline .col2-new:hover {
	background: #f0f0f0 url(images/bg_row_hover_new.gif) no-repeat right bottom;
	border-top-color: #f8f8f8;
	border-left-color: #f8f8f8;
	border-bottom-color: #d0d0d0;
	border-right-color: #d0d0d0;
}
.forumline .col3 {
	width: 60px;
}
.forumline .col4 {
	width: 40px;
}
.forumline .col5 {
	width: 120px;
}
.forumline .forumlink {
	font-size: 12px;
	font-weight: 700;
}
.forumline .topiclink {
	padding-right: 20px;
	font-size: 10px;
	background: url(images/icon_reply.gif) no-repeat right center;
}
/*******************************************************************************/
/* フォーラム一覧関連
/*******************************************************************************/
.forum .col1 {
	width: 30px;
	background: transparent url(images/folder.gif) no-repeat center center;
}
/*******************************************************************************/
/* トピック一覧関連
/*******************************************************************************/
.topic td {
	padding: 0 2px;
}
.topic .col1 {
	width: 15px;
	background: transparent url(images/post.gif) no-repeat center center;
}
/*******************************************************************************/
/* トピック関連
/*******************************************************************************/
.forumline .row-post-author,
.forumline .row-post {
	vertical-align: top;
	background: #fff url(images/bg_post.gif) repeat-x left top;
	border: solid 1px #fff;
	border-right-color: #d6d6d6;
	border-bottom-color: #d6d6d6;
}

.forumline .row-post-author {
	width: 150px;
	text-align: center;
}

.forumline .row-post {
	width: 80%;
	text-align: left;
}
.forumline .post-name {
	line-height: 1.6em;
	font-size: 12px;
	font-weight: 700;
	color: #455995;
}
.forumline .post-name a {
	font-size: 12px;
	font-weight: 700;
}
.forumline .post-avator img {
	margin: 1px auto;
	display: block;
}
.forumline .post-subject {
	margin-bottom: 5px;
	padding-left: 20px;
	height: 20px;
	font-weight: 700;
	font-size: 13px;
	color: #455995;
	background: transparent url(images/page.gif) no-repeat left top;
}
.forumline .post-text,
.forumline .post-text * {
	font-size: 8.7pt;
	line-height: 1.6;
}
.forumline .post-text {
	margin: 1em 0 5px;
}
.forumline .post-text h3,
.forumline .post-text h4 {
	margin: 1em 0;
	font-size: 130%;
	font-weight: 700;
}

.forumline .row-post-date,
.forumline .row-post-edit {
	border: solid 1px #fff;
	border-right-color: #d6d6d6;
	border-bottom-color: #d6d6d6;
	vertical-align: middle;
	font-size: 10px;
	line-height: 12px;
	color: #666;
	background: url(images/bg_postbottom.gif);
	white-space: nowrap;
	padding: 1px;
}
.forumline .row-post-date {
	text-align: center;
}
.forumline .row-post-edit a {
	background: none;
}
.forumline .row-space {
	width: 100%;
	height: .3px;
	background-color: #2b438f;
}
/*******************************************************************************/
/* サイドバー関連
/*******************************************************************************/
#sidebar a:hover {
	text-decoration: none;
}
#sidebar ul,
#sidebar dl,
#sidebar dt,
#sidebar dd {
	margin: 0;
	padding: 0;
}
#sidebar ul {
	list-style: none;
}
#sidebar ul li {
	margin: 0;
	padding: 0;
}
#sidebar dl {
	margin: 0 5px 0 0;
	width: 150px;
}
#sidebar dt.widget_header {
	margin-bottom: 1em;
	font-weight: 700;
	text-align: right;
	overflow: hidden;
	border-bottom: 1px solid #e8ecef;
}
#sidebar dt.widget_header em {
	font-size: 100%;
	font-weight: 700;
	font-style: normal;
	color: #14417a;
}
#sidebar dd.widget_content {
	margin-bottom: 3em;
	width: 100%;
}
/*
 * ウィジェット／タグクラウド
 */
ul.tag_list * {
	font-size: 1.5em;
}
ul.tags_summary,
ul.tag_list {
	margin: 0;
	padding-bottom: 1px;
	list-style: none;
}
ul.tag_list li {
	display: inline;
}
ul.tags_summary li {
	width: 100%;
	height: 2em;
	line-height: 2em;
}
ul.tag_list li a {
	padding: 0 .1em;
	height: auto;
	display: inline;
	font-weight: 700;
	position: relative;
	text-decoration: none;
	line-height: 1.3;
	z-index: 3;
	color: #f3f5ef;
}
ul.tag_list li.rank_1 a {
	text-decoration: none;/*for IE6.x*/
	color: #192f60;
}
ul.tag_list li.rank_2 a {
	text-decoration: none;/*for IE6.x*/
	color: #003f8e;
}
ul.tag_list li.rank_3 a {
	text-decoration: none;/*for IE6.x*/
	color: #4753a2;
}
ul.tag_list li.rank_4 a {
	text-decoration: none;/*for IE6.x*/
	color: #7a99cf;
}
ul.tag_list li.rank_5 a {
	text-decoration: none;/*for IE6.x*/
	color: #bcc7d7;
}
ul.tag_list li.rank_6 a {
	text-decoration: none;/*for IE6.x*/
	color: #c9c9c4;
}
ul.tag_list li a:hover {
	z-index: 4;
	background-color: #f8f4e6;
	text-decoration: none;
}
ul.tags_summary li {
	width: 99%;
	text-align: center;
	border: 1px solid #eae5e3;
}
ul.tags_summary li.rank_1 {
	color: #fffffc;
	background-color: #192f60;
}
ul.tags_summary li.rank_2 {
	color: #fffffc;
	background-color: #003f8e;
}
ul.tags_summary li.rank_3 {
	color: #fffffc;
	background-color: #4753a2;
}
ul.tags_summary li.rank_4 {
	background-color: #7a99cf;
}
ul.tags_summary li.rank_5 {
	background-color: #bcc7d7;
}
ul.tags_summary li.rank_6 {
	background-color: #c9c9c4;
}
/*
 * ウィジェット／月別アーカイブリスト
 */
#sidebar #monthly_list * {
	height: 1.3;
	line-height: 1.3;
	font-size: 96%;
}
#sidebar #monthly_list {
	margin: 0;
	width: 95px;
}
#sidebar #monthly_list dt.header {
	margin: 0 70px 0 0;
	width: 25px;
	display: block;
	float: left;
	font-weight: 700;
}
#sidebar #monthly_list dt.header a {
	font-weight: 700;
	text-decoration: underline;
}
#sidebar #monthly_list dt.header a:hover {
	text-decoration: none;
}
#sidebar #monthly_list dd.body {
	margin: 0 0 0 -70px;
	width: 70px;
	height: 100%;
	display: block;
	float: left;
}
#sidebar #monthly_list dd.clear {
	height: 0;
}
* html #sidebar #monthly_list dd.clear {/*for IE6.x*/
	display: none;
}
/*
 * ウィジェット／カレンダー
 */
#calendar * {
	font-size: 97%;
}
#calendar {
	width: px;
}
#calendar caption a:link,   /*for IE*/
#calendar caption a:active, /*for IE*/
#calendar caption a:visited,/*for IE*/
#calendar caption a {
	font-weight: 700;
}
#calendar,
#calendar th,
#calendar td {
	border: 1px solid #eae5e3;
}
#calendar {
	margin: 0 auto;
	vertical-align: middle;
	font-size: 10px;
}
#calendar caption {
	margin: 0 auto;
	height: 2em;
	line-height: 2em;
	font-size: 100%;
}
#calendar th,
#calendar td {
	width: 16px;
	height: 2;
	line-height: 2;
	text-align: center;
	background-color: #fffffc;
}
#calendar th,
#calendar td a {
	color: #fffffc;
	background-color: #14417a;
}
#calendar th {
	border-top: 1px solid #00a381;
}
#calendar td a {
	display: block;
	height: 2;
	line-height: 2;
}
#calendar td a:hover {
	background-color: #ff005a;
}
/*
 * ウィジェット／各種ツリー関連
 */
.dtree * {
	line-height: 1.3;
}
.dtree {
	white-space: nowrap;
}
.dtree img {
	border: 0;
	vertical-align: middle;
}
.dtree a {
	font-size: 90%;
/*	height: 18px;
	line-height: 18px;
	overflow: hidden;
*/
}
.dtree span {
	font-size: 100%;
}
.dtree a.node,
.dtree a.nodeSel {/*ノードのスタイル*/
	white-space: nowrap;
	padding: 1px 2px 1px 2px;
}
.dtree a.nodeSel {/*アクティブ・ノードのスタイル*/
}
.dtree a.node:hover,
.dtree a.nodeSel:hover,
.dtree a.node:hover span,
.dtree a.nodeSel:hover span {/*ホバー時のスタイル*/
	text-decoration: none;
}
.dtree span {
}
.dtree span.glayout {/*エントリがないカテゴリの前景色*/
	color: #303;
}
.dtree span.bold {/*強調表示*/
	font-weight: 700;
}
.dtree span.right {/*日付の右マージン*/
	margin-right: .5em;
}
.dtree .clip {
	overflow: hidden;
}
/*******************************************************************************/
/* エントリ一覧関連
/*******************************************************************************/
ul li.list_entry a {
	padding-left: 20px;
	background: transparent url(images/page.gif) no-repeat .3em .2em;
}
ul.widget_list {
	margin: 0;
	padding: 0;
}
ul.widget_list li a,
ul.widget_list li a span {
	font-size: 10px;
}
ul.widget_list li a {
	margin: 0;
	display: block;
	text-decoration: none;
	word-wrap: break-word;/*for IE*/
	border-bottom: 1px solid #e8ecef;
}
ul.widget_list li a:hover {
	text-decoration: none;
	background-color: #f0f0f0;
}
ul.widget_list li a span.right {
	padding: 0 .5em;
	float: right;
}
ul.widget_list li a span {
	color: #303;
}
/*******************************************************************************/
/* コメント関連
/*******************************************************************************/
#comment-form-external-auth {
	height: 108px;
	padding-left: 110px;
	font-size: 250%;
	background: url(images/bg_login.gif) no-repeat left top;
}
#comment-form-external-auth a {
	font-size: 100%;
}
#comments-open-text label,
#comments-open-data label {
	display: block;
}
#comments-open-data p {
	margin: 0;
}
#comment-author,
#comment-email,
#comment-url {
	width: 50%;
}
#comment-preview,
#comment-submit {

	margin: 1em 0 1.5em;
	padding: .2em;
	width: 8em;
	height: auto;
	background-color: #fffffc;
	border-top: 3px double #eaeaea;
	border-left: 3px double #eaeaea;
	border-right: 3px double #9a9a9a;
	border-bottom: 3px double #9a9a9a;

}
#comment-form-reply {
	display: none;
}
#comment-preview:hover,
#comment-submit:hover {

	cursor: pointer;
	color: #303;
	background-color: #fbfaf5;

}
#comment-reply,
#comment-bake-cookie {
	padding: 0;
	width: auto;
	height: auto;
}
#comment-form-text {
	margin: 0;
}
#comment-text {
	width: 99%;
	height: 228px;
}
* html #comment-text {/*for IE6.x*/
	height: 230px;
}
/*******************************************************************************/
/* 月別アーカイブページ
/*******************************************************************************/
body.mt-datebased-archive table.caledar,
body.mt-datebased-archive table.caledar th,
body.mt-datebased-archive table.caledar td {
	border: 1px solid #eae5e3;
}
body.mt-datebased-archive .archive_header {
	margin: 1em 0;
	padding: 0 1em;

	font-size: 150%;
	font-weight: 700;
	line-height: 1.5;
	text-align: left;
}
body.mt-datebased-archive table.caledar {
	margin-bottom: 1em;
	width: 100%;
}
body.mt-datebased-archive table.caledar th {
	text-align: center;
	padding: 0 2px;
	line-height: 1.6;
	font-weight: 700;
}
body.mt-datebased-archive table.caledar tr.Sat {
	background-color: #eaf4fc;
}
body.mt-datebased-archive table.caledar tr.Sun {
	background-color: #fdeff2;
}
body.mt-datebased-archive td.day,
body.mt-datebased-archive td.week {
	padding: 0 2px;
	width: 30px;

	text-align: center;
	line-height: 1.6;

	font-weight: 400;/*normal*/
}
body.mt-datebased-archive td.summary {
	padding: 0;
	text-align: left;
	line-height: 1.6;

	font-weight: 400;
	font-size: small;
}
body.mt-datebased-archive td.summary ul li a,
body.mt-datebased-archive td.summary ul li a:hover {
	border: none;
}

