# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Signin.pm 47 2008-05-15 06:22:04Z nekotama $

package Nekorum::CMS::Signin;

use strict;

use MT;
use Nekorum::Util;

sub _view_signin {
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my %param = $app->param_hash;

	my $author = Nekorum::Util->_get_author($app);
	$app->redirect($app->param('static')) if($author);

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);

	# load template
	require MT::Template;
	my $tmpl = MT::Template->load({ blog_id => $blog_id, type => 'custom', name => 'Nekorum Signin'}) or return $app->errtrans("Load template error.");

	require MT::Template::Context;
	my $ctx = MT::Template::Context->new;
	my %cond;
	$ctx->stash('blog', $blog);

	my ($name, $value);
	while (($name, $value) = each(%param)){
		$ctx->var($name,$value);
	}

	my $output = $tmpl->build($ctx, \%cond) or return $tmpl->errstr;
	return $output;
}

1;