# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Block.pm 84 2008-05-19 05:59:07Z nekotama $

package Nekorum::Tags::Block;
use strict;

use MT;

sub NekorumAuthorEntryBlock {
	my ($ctx, $args, $cond) = @_;
	
	my $app = MT->instance;
	my $blog = $ctx->stash('blog');
	my $blog_id = $ctx->stash('blog_id');
	my $entry = $ctx->stash('entry');
	my $entry_id = $entry->id;
	my $author_id = $entry->author_id;
	my $builder = $ctx->stash('builder');
	my $tokens = $ctx->stash('tokens');
	my $type = $args->{type} ? $args->{type} : $blog->file_extension;
	my $output = $builder->build($ctx,$tokens,$cond);
	my $script_url = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi';
	my $before;
	my $after;
	
	$before = <<HTML_BEFORE;
<span id="nekorum_author_entry_$entry_id">
HTML_BEFORE

	$after = <<HTML_AFTER;
</span>
<script type="text/javascript" src="${script_url}?__mode=_get_author_js&amp;blog_id=$blog_id&amp;author_id=$author_id&amp;entry_id=$entry_id" charset="utf-8"></script>
<script type="text/javascript">
/* <![CDATA[ */
hide_author_$entry_id(document.getElementById("nekorum_author_entry_$entry_id"));
/* ]]> */
</script>
HTML_AFTER

	return $before . $output . $after;
}

sub NekorumAuthorCommentBlock {
	my ($ctx, $args, $cond) = @_;
	
	my $app = MT->instance;
	my $blog = $ctx->stash('blog');
	my $blog_id = $ctx->stash('blog_id');
	my $comment = $ctx->stash('comment');
	my $comment_id = $comment->id;
	my $commenter_id = $comment->commenter_id;
	my $builder = $ctx->stash('builder');
	my $tokens = $ctx->stash('tokens');
	my $type = $args->{type} ? $args->{type} : $blog->file_extension;
	my $output = $builder->build($ctx,$tokens,$cond);
	my $script_url = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi';
	my $before;
	my $after;

	$before = <<HTML_BEFORE;
<span id="nekorum_author_comment_$comment_id">
HTML_BEFORE

	$after = <<HTML_AFTER;
</span>
<script type="text/javascript" src="${script_url}?__mode=_get_commenter_js&amp;blog_id=$blog_id&amp;commenter_id=$commenter_id&amp;comment_id=$comment_id" charset="utf-8"></script>
<script type="text/javascript">
/* <![CDATA[ */
hide_commenter_$comment_id(document.getElementById("nekorum_author_comment_$comment_id"));
/* ]]> */
</script>
HTML_AFTER

	return $before . $output . $after;
}

1;
