﻿# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Util.pm 91 2008-05-21 14:24:29Z nekotama $

package Nekorum::Util;

use strict;
use MT;
use MT::Blog;
use MT::App::Comments qw( _get_commenter_session );
use HTML::Parser;

sub is_forum_use {
	my $app = MT->instance;
	my $plugin = $app->plugin;

	my $blog_id = $app->param('blog_id');
	my $is_blog_forum = $plugin->get_config_value( 'blog_plugin_use', "blog:$blog_id" ) or 0;
	my $is_system_forum = $plugin->get_config_value( 'default_plugin_use', "system" ) or 1;

	if($is_blog_forum==0){
		if($is_system_forum==1){
			return 0;
		}
	} elsif($is_blog_forum==2){
		return 0;
	}
	return 1;
}

sub is_remove_hold {
	my $app = MT->instance;
	my $plugin = $app->plugin;

	my $blog_id = $app->param('blog_id');
	return $plugin->get_config_value( 'blog_remove_hold', "blog:$blog_id" ) or 1;
}

sub _get_commenter_session {
	my $app = MT->instance;
	return MT::App::Comments::_get_commenter_session($app);
}

sub _get_author {
	my $app = MT->instance;
	my $blog_id = $app->param('blog_id');

	# author session
	my ($session, $author) = MT::App::Comments::_get_commenter_session($app);
	if($author){
		return undef if($author->commenter_status($blog_id)!=MT::Author::APPROVED);
	}
	return $author;
}

sub _ignore_html {
	my ($app, $blog, $text) = @_;

	my $sanitize_spec = $blog->sanitize_spec || MT->config->GlobalSanitizeSpec;
	
	my $p = HTML::Parser->new(
		api_version => 3,
		default_h => [\&default, "text"],
		start_h => [\&start, "tagname, text"],
		end_h => [\&end, "tagname, text"],
		text_h => [\&text, "text"],
		marked_sections => 1,
	);
	$p->unbroken_text(1);

	our $pre_text = 0;
	our $out_text = "";
	our $tmp_text = "<z>$text</z>";
	our @ignore_tag = split(/,/,$sanitize_spec);
	push(@ignore_tag, 'z');
	push(@ignore_tag, 'br');
	
	$p->parse($tmp_text);

	$text = substr($out_text, 3, length($out_text)-7);
	return $text;
}

sub default(){
	our $out_text .= shift;
}

sub start(){
	my ($tagname, $str) = @_;
	our ($pre_text, $out_text, @ignore_tag);
	my $ignore = 0;
	foreach my $_tag (@ignore_tag){
		my @tag = split(/ /,$_tag);
		$ignore=1 if($tagname eq $tag[0]);
	}
	$str =~ s/</&lt;/g if(!$ignore||$pre_text);
	$pre_text = 1 if($ignore && $tagname eq 'pre');
	$str =~ s/\r\n/\n/g if($pre_text);
	$out_text .= $str;
}

sub end(){
	my ($tagname, $str) = @_;
	our ($pre_text, $out_text, @ignore_tag);
	my $ignore = 0;
	foreach my $_tag (@ignore_tag){
		my @tag = split(/ /,$_tag);
		$ignore=1 if($tagname eq $tag[0]);
	}
	$pre_text = 0 if($ignore && $tagname eq 'pre');
	$str =~ s/</&lt;/g if(!$ignore||$pre_text);
	$out_text .= $str;
}

sub text(){
	my $str = shift;
	our ($pre_text, $out_text);
	if($pre_text){
		$str =~ s/\r\n/\n/g;
	}
	$out_text .= $str;
}

1;
