# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Profile.pm 75 2008-05-17 06:08:58Z nekotama $

package Nekorum::CMS::Profile;

use strict;

use MT;
use Nekorum::Util;

sub _view_edit_profile {
  my $app = shift;

  my $blog_id = $app->param('blog_id');
	my %param = $app->param_hash;

  # author session
  my $author = Nekorum::Util->_get_author($app);
  return $app->errtrans("Session timeout.") unless($author);
  $app->{author} = $author;
  my $author_id = $author->id;

  # load blog
  require MT::Blog;
  my $blog = MT::Blog->load($blog_id);

  # load template
  require MT::Template;
  my $tmpl = MT::Template->load({ blog_id => $blog_id, type => 'custom', name => 'Nekorum Profile'}) or return $app->errtrans("Load template error.");

  require MT::Template::Context;
  my $ctx = MT::Template::Context->new;
  my %cond;
  $ctx->stash('blog', $blog);
  $ctx->stash('author', $author);
  $ctx->var('author_id', $author_id);
  $ctx->var('mode', '_edit_profile');
  $ctx->var('name', $author->name);
  $ctx->var('nickname', $author->nickname);
  $ctx->var('email', $author->email);
  $ctx->var('url', $author->url);

	my ($name, $value);
	while (($name, $value) = each(%param)){
		$ctx->var($name,$value);
	}

  my $output = $tmpl->build($ctx, \%cond) or return $tmpl->errstr;
  return $output;
}

sub _view_profile {
  my $app = shift;

  my $blog_id = $app->param('blog_id');

  # author session
  my $author = Nekorum::Util->_get_author($app);
  return $app->errtrans("Session timeout.") unless($author);
  $app->{author} = $author;
  my $author_id = $author->id;

  # load blog
  require MT::Blog;
  my $blog = MT::Blog->load($blog_id);

  # load template
  require MT::Template;
  my $tmpl = MT::Template->load({ blog_id => $blog_id, type => 'custom', name => 'Nekorum Profile'}) or return $app->errtrans("Load template error.");

  require MT::Template::Context;
  my $ctx = MT::Template::Context->new;
  my %cond;
  $ctx->stash('blog', $blog);
  $ctx->stash('author', $author);
  $ctx->var('author_id', $author_id);
  $ctx->var('mode', '_edit_profile');
  $ctx->var('name', $author->name);
  $ctx->var('nickname', $author->nickname);
  $ctx->var('email', $author->email);
  $ctx->var('url', $author->url);

  my $output = $tmpl->build($ctx, \%cond) or return $tmpl->errstr;
  return $output;
}

1;