/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.DetailsPanel;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.SearchEngine;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchTask;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class ResultViewTopComponent
extends TopComponent
implements ChangeListener,
ExplorerManager.Provider {
    public static final String MODE_NAME = "Search Results";
    private ResultModel resultModel = null;
    private ExplorerPanel explorerPanel;
    private DetailsPanel detailsPanel;
    private PropertyChangeListener propertyListener;
    private JRadioButton sortButton;
    private JPanel buttonPanel;
    private JButton stopButton;
    private JButton closeButton;
    private JButton customizeButton;
    private SplittedPanel splittedPanel;
    private JButton outputButton;
    private JRadioButton unsortButton;
    private JButton helpButton;
    private JLabel resultLabel;
    static /* synthetic */ Class class$org$netbeans$modules$search$ResultViewTopComponent;
    static /* synthetic */ Class class$org$openide$actions$HelpAction;

    public ResultViewTopComponent(ResultModel resultModel) {
        this.initComponents();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sortButton);
        buttonGroup.add(this.unsortButton);
        this.explorerPanel = new ResultExplorerPanel();
        this.explorerPanel.setLayout(new BorderLayout());
        this.detailsPanel = new DetailsPanel(this);
        this.propertyListener = new PropertyChangeListener(){
            static /* synthetic */ Class class$org$netbeans$modules$search$ResultViewTopComponent;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    Node[] nodeArray = ResultViewTopComponent.this.explorerPanel.getExplorerManager().getSelectedNodes();
                    ResultViewTopComponent.this.setActivatedNodes(nodeArray);
                    if (nodeArray != null && nodeArray.length == 1) {
                        ResultViewTopComponent.this.detailsPanel.showInfo(nodeArray[0]);
                        ResultViewTopComponent.this.detailsPanel.setBorder(new TitledBorder(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = 1.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_LABEL_DETAILS") + " " + nodeArray[0].getName()));
                        ResultViewTopComponent.this.showDetails(nodeArray[0]);
                    } else {
                        ResultViewTopComponent.this.detailsPanel.showInfo(null);
                        ResultViewTopComponent.this.showDetails(null);
                    }
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        this.explorerPanel.getExplorerManager().addPropertyChangeListener(this.propertyListener);
        BeanTreeView beanTreeView = new BeanTreeView();
        beanTreeView.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("ACS_TREEVIEW"));
        beanTreeView.setBorder(new EtchedBorder());
        this.explorerPanel.add((Component)beanTreeView, "Center");
        this.resultLabel.setLabelFor((Component)beanTreeView);
        this.splittedPanel.setSwapPanesEnabled(false);
        this.splittedPanel.setSplitTypeChangeEnabled(false);
        this.splittedPanel.add((Component)this.explorerPanel, SplittedPanel.ADD_FIRST);
        this.splittedPanel.add((Component)this.detailsPanel, SplittedPanel.ADD_SECOND);
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_TITLE_SEARCH_RESULTS"));
        this.setModel(resultModel);
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.sortButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("ACS_TEXT_BUTTON_SORT"));
        this.stopButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("ACS_TEXT_BUTTON_STOP"));
        this.closeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("ACS_TEXT_BUTTON_CANCEL"));
        this.customizeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("ACS_TEXT_BUTTON_CUSTOMIZE"));
        this.outputButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("ACS_TEXT_BUTTON_FILL"));
        this.unsortButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("ACS_TEXT_BUTTON_UNSORT"));
        this.helpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_HELP"));
    }

    private void initComponents() {
        this.resultLabel = new JLabel();
        this.sortButton = new JRadioButton();
        this.unsortButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.stopButton = new JButton();
        this.outputButton = new JButton();
        this.customizeButton = new JButton();
        this.closeButton = new JButton();
        this.helpButton = new JButton();
        this.splittedPanel = new SplittedPanel();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.resultLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_LABEL_SEARCH_RESULTS"));
        this.resultLabel.setHorizontalTextPosition(2);
        this.resultLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_LABEL_SEARCH_RESULTS_MNEM").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        ((Container)((Object)this)).add(this.resultLabel, gridBagConstraints);
        this.sortButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_SORT_MNEM").charAt(0));
        this.sortButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_SORT"));
        this.sortButton.setEnabled(false);
        this.sortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewTopComponent.this.sortButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        ((Container)((Object)this)).add(this.sortButton, gridBagConstraints);
        this.unsortButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_UNSORT_MNEM").charAt(0));
        this.unsortButton.setSelected(true);
        this.unsortButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_UNSORT"));
        this.unsortButton.setEnabled(false);
        this.unsortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewTopComponent.this.sortButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        ((Container)((Object)this)).add(this.unsortButton, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 4, 5, 0));
        this.stopButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_STOP_MNEM").charAt(0));
        this.stopButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_STOP"));
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewTopComponent.this.stopButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.stopButton);
        this.outputButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_FILL_MNEM").charAt(0));
        this.outputButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_FILL"));
        this.outputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewTopComponent.this.outputButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.outputButton);
        this.customizeButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_CUSTOMIZE_MNEM").charAt(0));
        this.customizeButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_CUSTOMIZE"));
        this.customizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewTopComponent.this.customizeButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.customizeButton);
        this.closeButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_CANCEL").charAt(0));
        this.closeButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_CANCEL"));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewTopComponent.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.helpButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_HELP_MNEM").charAt(0));
        this.helpButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent)).getString("TEXT_BUTTON_HELP"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewTopComponent.this.helpButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.helpButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        ((Container)((Object)this)).add(this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        ((Container)((Object)this)).add((Component)this.splittedPanel, gridBagConstraints);
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        SystemAction.get((Class)(class$org$openide$actions$HelpAction == null ? (class$org$openide$actions$HelpAction = ResultViewTopComponent.class$("org.openide.actions.HelpAction")) : class$org$openide$actions$HelpAction)).actionPerformed(new ActionEvent(this, 0, null));
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    private void outputButtonActionPerformed(ActionEvent actionEvent) {
        this.resultModel.fillOutput();
    }

    private void sortButtonActionPerformed(ActionEvent actionEvent) {
        block4: {
            ExplorerManager explorerManager = null;
            Node[] nodeArray = null;
            explorerManager = this.explorerPanel.getExplorerManager();
            if (explorerManager != null) {
                nodeArray = explorerManager.getSelectedNodes();
            }
            boolean bl = this.sortButton.isSelected();
            this.sortNodes(bl);
            if (nodeArray != null) {
                try {
                    explorerManager.setSelectedNodes(nodeArray);
                }
                catch (PropertyVetoException propertyVetoException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block4;
                    propertyVetoException.printStackTrace();
                }
            }
        }
    }

    private void customizeButtonActionPerformed(ActionEvent actionEvent) {
        this.customizeCriteria();
    }

    private void stopButtonActionPerformed(ActionEvent actionEvent) {
        this.resultModel.stop();
    }

    public void setModel(ResultModel resultModel) {
        if (this.resultModel != null) {
            this.resultModel.removeChangeListener(this);
        }
        this.resultModel = resultModel;
        Node node = resultModel.getRoot();
        if (resultModel.isSorted()) {
            this.sortButton.setSelected(true);
        } else {
            this.unsortButton.setSelected(true);
        }
        this.explorerPanel.getExplorerManager().setRootContext(node);
        resultModel.addChangeListener(this);
        this.initButtons();
    }

    protected void componentActivated() {
        ((ResultExplorerPanel)this.explorerPanel).componentActivated();
    }

    protected void componentDeactivated() {
        ((ResultExplorerPanel)this.explorerPanel).componentDeactivated();
    }

    private void initButtons() {
        this.stopButton.setEnabled(!this.resultModel.isDone());
        this.sortButton.setEnabled(this.resultModel.isDone());
        this.unsortButton.setEnabled(this.resultModel.isDone());
        this.detailsPanel.showInfo(null);
    }

    public void sortNodes(boolean bl) {
        Node node = this.resultModel.sortNodes(bl);
        this.explorerPanel.getExplorerManager().setRootContext(node);
        this.initButtons();
    }

    public Image getIcon() {
        return Utilities.loadImage((String)"/org/netbeans/modules/search/res/find.gif");
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerPanel.getExplorerManager();
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        if (this.resultModel != null) {
            this.resultModel.stop();
            this.resultModel.removeChangeListener(this);
        }
        return true;
    }

    private void customizeCriteria() {
        SearchPanel searchPanel = new SearchPanel(this.resultModel.getEnabledSearchTypes(), true);
        Node[] nodeArray = this.resultModel.getSearchGroup().getSearchRoots();
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() == 1) {
            this.resultModel.stop();
            SearchEngine searchEngine = new SearchEngine();
            SearchGroup[] searchGroupArray = SearchGroup.createSearchGroups((SearchType[])searchPanel.getCustomizedSearchTypes());
            SearchGroup searchGroup = null;
            if (searchGroupArray.length > 0) {
                searchGroup = searchGroupArray[0];
            }
            ResultModel resultModel = new ResultModel(this.resultModel.getEnabledSearchTypes(), searchGroup);
            SearchTask searchTask = searchEngine.search(nodeArray, searchGroup, resultModel);
            resultModel.setTask(searchTask);
            this.setModel(resultModel);
            this.initButtons();
        }
    }

    public void showDetails(Node node) {
        Children children;
        if (node == null) {
            children = Children.LEAF;
        } else {
            children = new Children.Array();
            ArrayList arrayList = new ArrayList(20);
            SearchType[] searchTypeArray = this.resultModel.getSearchGroup().getSearchTypes();
            int n = 0;
            while (n < searchTypeArray.length) {
                Node[] nodeArray = searchTypeArray[n].getDetails(node);
                if (nodeArray != null) {
                    children.add(nodeArray);
                }
                ++n;
            }
        }
        this.detailsPanel.setDetailsRoot((Node)new AbstractNode(children));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.resultModel && this.resultModel.isDone()) {
            this.initButtons();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$search$ResultViewTopComponent == null ? (class$org$netbeans$modules$search$ResultViewTopComponent = ResultViewTopComponent.class$("org.netbeans.modules.search.ResultViewTopComponent")) : class$org$netbeans$modules$search$ResultViewTopComponent);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public Object writeReplace() throws ObjectStreamException {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ResultExplorerPanel
    extends ExplorerPanel {
        private ResultExplorerPanel() {
        }

        public void componentActivated() {
            super.componentActivated();
        }

        public void componentDeactivated() {
            super.componentDeactivated();
        }
    }
}

