/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.DefinitionRegistry;
import org.openide.util.RequestProcessor;

public final class IntrospectedInfo
implements Serializable {
    private static IntrospectedInfo defaults = null;
    private static boolean loadedDefaults = false;
    private static final long serialVersionUID = -2290064038236292995L;
    private Map clazzes = Collections.synchronizedMap(new HashMap());
    private Map namedefs = new HashMap();
    private transient Set listeners = new HashSet(5);
    private transient Set tonotify = new HashSet(5);
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$IntrospectedInfo;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;

    static synchronized boolean isDefaultsPrepared() {
        return loadedDefaults;
    }

    public static synchronized IntrospectedInfo getDefaults() {
        if (defaults != null) {
            return defaults;
        }
        AntModule.err.log("IntrospectedInfo.getDefaults: loading...");
        defaults = new IntrospectedInfo();
        ClassLoader classLoader = (class$org$apache$tools$ant$module$api$IntrospectedInfo == null ? (class$org$apache$tools$ant$module$api$IntrospectedInfo = IntrospectedInfo.class$("org.apache.tools.ant.module.api.IntrospectedInfo")) : class$org$apache$tools$ant$module$api$IntrospectedInfo).getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/apache/tools/ant/taskdefs/defaults.properties");
        if (inputStream != null) {
            try {
                defaults.load(inputStream, true, classLoader);
            }
            catch (IOException iOException) {
                AntModule.err.log("Could not load default taskdefs");
                AntModule.err.notify((Throwable)iOException);
            }
        } else {
            AntModule.err.log("Could not open default taskdefs");
        }
        InputStream inputStream2 = classLoader.getResourceAsStream("org/apache/tools/ant/types/defaults.properties");
        if (inputStream2 != null) {
            try {
                defaults.load(inputStream2, false, classLoader);
            }
            catch (IOException iOException) {
                AntModule.err.log("Could not load default typedefs");
                AntModule.err.notify((Throwable)iOException);
            }
        } else {
            AntModule.err.log("Could not open default typedefs");
        }
        Iterator iterator = DefinitionRegistry.getKinds().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = DefinitionRegistry.getDefs(string);
            if (map.size() <= 0) continue;
            AntModule.err.log("Introspecting " + map.size() + " ad-hoc defs (kind=" + string + ")...");
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String string2 = (String)entry.getKey();
                Class clazz = (Class)entry.getValue();
                defaults.register(string2, clazz, string);
            }
        }
        if (AntModule.err.isLoggable(0)) {
            AntModule.err.log("IntrospectedInfo.defaults=" + defaults);
        }
        loadedDefaults = true;
        return defaults;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.listeners = new HashSet(5);
        this.tonotify = new HashSet(5);
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.clazzes = (Map)getField.get("clazzes", null);
        this.namedefs = (Map)getField.get("namedefs", null);
        if (this.namedefs == null) {
            AntModule.err.log("#15739: reading old version of IntrospectedInfo");
            this.namedefs = new HashMap();
            object5 = getField.get("tasks", null);
            if (object5 == null) {
                throw new NullPointerException();
            }
            if (!(object5 instanceof Map)) {
                throw new ClassCastException(object5.toString());
            }
            this.namedefs.put("task", object5);
            object4 = (Map)getField.get("types", null);
            if (object4 == null) {
                throw new NullPointerException();
            }
            this.namedefs.put("type", object4);
        }
        object5 = this.namedefs.entrySet().iterator();
        while (object5.hasNext()) {
            object4 = object5.next();
            object3 = (String)object4.getKey();
            object2 = (Map)object4.getValue();
            object = object2.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
            }
        }
        object4 = this.clazzes.entrySet().iterator();
        while (object4.hasNext()) {
            object3 = (Map.Entry)object4.next();
            object2 = (String)object3.getKey();
            object = (IntrospectedClass)object3.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged() {
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
            if (this.tonotify.isEmpty()) {
                RequestProcessor.postRequest((Runnable)new ChangeTask());
            }
            this.tonotify.addAll(this.listeners);
        }
    }

    public Map getTaskdefs() {
        return this.getDefs("task");
    }

    public Map getTypedefs() {
        return this.getDefs("type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDefs(String string) {
        Map map = this.namedefs;
        synchronized (map) {
            block4: {
                Map map2 = (Map)this.namedefs.get(string);
                if (map2 == null) break block4;
                Map map3 = Collections.unmodifiableMap(map2);
                return map3;
            }
            Map map4 = Collections.EMPTY_MAP;
            return map4;
        }
    }

    private IntrospectedClass getData(String string) throws IllegalArgumentException {
        IntrospectedClass introspectedClass = (IntrospectedClass)this.clazzes.get(string);
        if (introspectedClass == null) {
            throw new IllegalArgumentException();
        }
        return introspectedClass;
    }

    public boolean isKnown(String string) {
        return this.clazzes.get(string) != null;
    }

    public boolean supportsText(String string) throws IllegalArgumentException {
        return this.getData((String)string).supportsText;
    }

    public Map getAttributes(String string) throws IllegalArgumentException {
        Map map = this.getData((String)string).attrs;
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public Map getElements(String string) throws IllegalArgumentException {
        Map map = this.getData((String)string).subs;
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream inputStream, boolean bl, ClassLoader classLoader) throws IOException {
        Map.Entry<Object, Object> entry;
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            entry = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            try {
                Class<?> clazz = classLoader.loadClass(string2);
                this.register(string, clazz, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                AntModule.err.log("IntrospectedInfo: skipping " + string2 + ": " + classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                AntModule.err.log("IntrospectedInfo: skipping " + string2 + ": " + noClassDefFoundError);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                IOException iOException = new IOException("Could not load class " + string2);
                AntModule.err.annotate((Throwable)iOException, throwable);
                throw iOException;
            }
        }
    }

    public synchronized void register(String string, Class clazz, boolean bl) {
        this.register(string, clazz, bl ? "task" : "type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void register(String string, Class clazz, String string2) {
        Map map = this.namedefs;
        synchronized (map) {
            HashMap<String, String> hashMap = (HashMap<String, String>)this.namedefs.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                this.namedefs.put(string2, hashMap);
            }
            hashMap.put(string, clazz.getName());
        }
        this.fireStateChanged();
        this.analyze(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(String string, String string2) {
        Map map = this.namedefs;
        synchronized (map) {
            Map map2 = (Map)this.namedefs.get(string2);
            if (map2 != null) {
                map2.remove(string);
            }
        }
        this.fireStateChanged();
    }

    private void analyze(Class clazz) {
        Object object;
        Object object2;
        if (this.isKnown(clazz.getName()) || IntrospectedInfo.getDefaults().isKnown(clazz.getName())) {
            return;
        }
        IntrospectedClass introspectedClass = new IntrospectedClass();
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(clazz);
        introspectedClass.supportsText = introspectionHelper.supportsCharacters();
        Enumeration enumeration = introspectionHelper.getAttributes();
        if (enumeration.hasMoreElements()) {
            introspectedClass.attrs = new HashMap();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                try {
                    object = introspectionHelper.getAttributeType((String)object2).getName();
                    if ((class$org$apache$tools$ant$Task == null ? IntrospectedInfo.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(clazz) && (((String)object2).equals("location") && ((String)object).equals("org.apache.tools.ant.Location") || ((String)object2).equals("taskname") && ((String)object).equals("java.lang.String") || ((String)object2).equals("description") && ((String)object).equals("java.lang.String"))) continue;
                    introspectedClass.attrs.put(object2, object);
                }
                catch (RuntimeException runtimeException) {
                    AntModule.err.notify(1, (Throwable)runtimeException);
                }
            }
        } else {
            introspectedClass.attrs = null;
        }
        object2 = new HashSet();
        enumeration = introspectionHelper.getNestedElements();
        if (enumeration.hasMoreElements()) {
            introspectedClass.subs = new HashMap();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                try {
                    Class clazz2 = introspectionHelper.getElementType((String)object);
                    introspectedClass.subs.put(object, clazz2.getName());
                    object2.add(clazz2);
                }
                catch (RuntimeException runtimeException) {
                    AntModule.err.notify(1, (Throwable)runtimeException);
                }
            }
        } else {
            introspectedClass.subs = null;
        }
        this.clazzes.put(clazz.getName(), introspectedClass);
        object = object2.iterator();
        while (object.hasNext()) {
            this.analyze((Class)object.next());
        }
        this.fireStateChanged();
    }

    public void scanProject(Project project) {
        this.scanMap(project.getTaskDefinitions(), "task");
        this.scanMap(project.getDataTypeDefinitions(), "type");
        AntModule.err.log("IntrospectedInfo.scanProject: p=" + project.getName() + "; this=" + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanMap(Map map, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            Class clazz = (Class)entry.getValue();
            HashMap<String, String> hashMap = (HashMap<String, String>)this.namedefs.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                this.namedefs.put(string, hashMap);
            }
            IntrospectedInfo introspectedInfo = this;
            synchronized (introspectedInfo) {
                Map map2 = IntrospectedInfo.getDefaults().getDefs(string);
                if (hashMap.get(string2) == null && map2.get(string2) == null) {
                    hashMap.put(string2, clazz.getName());
                }
                if (!IntrospectedInfo.getDefaults().isKnown(clazz.getName())) {
                    try {
                        this.analyze(clazz);
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        AntModule.err.log("Skipping " + clazz.getName() + ": " + noClassDefFoundError);
                    }
                    catch (Throwable throwable) {
                        AntModule.err.annotate(throwable, 1, "Cannot scan class " + clazz.getName(), null, null, null);
                        AntModule.err.notify(1, throwable);
                    }
                }
            }
        }
        this.fireStateChanged();
    }

    public String toString() {
        return "IntrospectedInfo[namedefs=" + this.namedefs + ",clazzes=" + this.clazzes + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class IntrospectedClass
    implements Serializable {
        private static final long serialVersionUID = 4039297397834774403L;
        public boolean supportsText;
        public Map attrs;
        public Map subs;

        private IntrospectedClass() {
        }

        public String toString() {
            return "IntrospectedClass[text=" + this.supportsText + ",attrs=" + this.attrs + ",subs=" + this.subs + "]";
        }
    }

    private class ChangeTask
    implements Runnable {
        private ChangeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ChangeListener[] changeListenerArray;
            Set set = IntrospectedInfo.this.listeners;
            synchronized (set) {
                if (IntrospectedInfo.this.tonotify.isEmpty()) {
                    return;
                }
                changeListenerArray = IntrospectedInfo.this.tonotify.toArray(new ChangeListener[IntrospectedInfo.this.tonotify.size()]);
                IntrospectedInfo.this.tonotify.clear();
            }
            ChangeEvent changeEvent = new ChangeEvent(this);
            int n = 0;
            while (n < changeListenerArray.length) {
                changeListenerArray[n].stateChanged(changeEvent);
                ++n;
            }
        }
    }
}

