/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.properties;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Properties;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.nodes.AntProjectNode;
import org.apache.tools.ant.module.wizards.properties.PropertiesIterator;
import org.openide.DialogDescriptor;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class PropertiesFileProperty
extends PropertySupport {
    public static final String ANT_FILE_EXT = "ant.properties";
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator;
    static /* synthetic */ Class class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty;
    static /* synthetic */ Class class$org$apache$tools$ant$module$wizards$properties$AddPropertiesPanel;

    public PropertiesFileProperty(String string, String string2) {
        super("propertiesFileProperty", class$java$util$Properties == null ? (class$java$util$Properties = PropertiesFileProperty.class$("java.util.Properties")) : class$java$util$Properties, string, string2, true, true);
    }

    public abstract Element getElement();

    public abstract AntProjectCookie getAntProjectCookie();

    public boolean canWrite() {
        if (this.getElement() == null) {
            return false;
        }
        if (AntProjectNode.isScriptReadOnly(this.getAntProjectCookie())) {
            return false;
        }
        if (PropertiesFileProperty.findPropertyElement(this.getElement()) == null) {
            return true;
        }
        return PropertiesFileProperty.findPropertiesFile(this.getElement(), this.getAntProjectCookie()) != null;
    }

    public Object getValue() {
        return PropertiesFileProperty.loadProperties(this.getElement(), this.getAntProjectCookie());
    }

    public void setValue(Object object) {
        if (object instanceof Properties) {
            PropertiesFileProperty.storeProperties(this.getElement(), this.getAntProjectCookie(), (Properties)object);
        }
    }

    public PropertyEditor getPropertyEditor() {
        Element element = PropertiesFileProperty.findPropertyElement(this.getElement());
        if (element != null) {
            return super.getPropertyEditor();
        }
        this.setValue("canEditAsText", Boolean.FALSE);
        return new PropertiesFileWizard();
    }

    protected abstract void firePropertiesFilePropertyChange();

    protected static Element findPropertyElement(Element element) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            String string;
            Node node = nodeList.item(n);
            if (node.getNodeName().equals("property") && (string = (element2 = (Element)node).getAttribute("file")).length() > 0 && string.indexOf("${") < 0) {
                return element2;
            }
            ++n;
        }
        return null;
    }

    protected static Object findPropertiesFile(Element element, AntProjectCookie antProjectCookie) {
        if (element == null || antProjectCookie == null) {
            return null;
        }
        Element element2 = PropertiesFileProperty.findPropertyElement(element);
        if (element2 != null) {
            String string = element2.getAttribute("file");
            if (antProjectCookie.getFileObject() != null) {
                FileObject fileObject = antProjectCookie.getFileObject().getParent();
                return fileObject.getFileObject(string);
            }
            if (antProjectCookie.getFile() != null) {
                File file = antProjectCookie.getFile().getParentFile();
                return new File(file, string);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void storeProperties(Element element, AntProjectCookie antProjectCookie, Properties properties) {
        if (element == null) return;
        if (antProjectCookie == null) {
            return;
        }
        Object object = PropertiesFileProperty.findPropertiesFile(element, antProjectCookie);
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            FileLock fileLock = null;
            try {
                fileLock = fileObject.lock();
            }
            catch (IOException iOException) {
                AntModule.err.log("Could not lock File " + fileObject);
            }
            if (fileLock == null) return;
            try {
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileObject.getOutputStream(fileLock));
                    properties.store(bufferedOutputStream, NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.PropertiesFileProperty")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty), (String)"ant_properties_file_header"));
                    bufferedOutputStream.close();
                }
                catch (IOException iOException) {
                    AntModule.err.log("could not save to FileObject " + fileObject);
                    Object var8_13 = null;
                    fileLock.releaseLock();
                    return;
                }
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            return;
        }
        if (!(object instanceof File)) return;
        File file = (File)object;
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            properties.store(bufferedOutputStream, NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.PropertiesFileProperty")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesFileProperty), (String)"ant_properties_file_header"));
            bufferedOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            AntModule.err.log("Could not save to File " + file);
        }
    }

    static Properties loadProperties(Element element, AntProjectCookie antProjectCookie) {
        if (element == null || antProjectCookie == null) {
            return null;
        }
        Object object = PropertiesFileProperty.findPropertiesFile(element, antProjectCookie);
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Properties properties = new Properties();
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
                return properties;
            }
            catch (IOException iOException) {
                AntModule.err.log("Could not read FileObject " + fileObject);
            }
        } else if (object instanceof File) {
            File file = (File)object;
            Properties properties = new Properties();
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
                return properties;
            }
            catch (IOException iOException) {
                AntModule.err.log("Could not read File " + file);
            }
        }
        return null;
    }

    static String createPropertiesHeaderString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#");
        stringBuffer.append(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$AddPropertiesPanel == null ? (class$org$apache$tools$ant$module$wizards$properties$AddPropertiesPanel = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.AddPropertiesPanel")) : class$org$apache$tools$ant$module$wizards$properties$AddPropertiesPanel), (String)"ant_properties_file_header"));
        stringBuffer.append("\n#");
        stringBuffer.append(new Date().toString());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PropertiesFileWizard
    extends PropertyEditorSupport
    implements PropertyChangeListener {
        WizardDescriptor wd;
        private final int INDENT_STEP = 4;

        PropertiesFileWizard() {
        }

        public Component getCustomEditor() {
            this.wd = new WizardDescriptor((WizardDescriptor.Iterator)new PropertiesIterator(PropertiesFileProperty.this.getElement(), PropertiesFileProperty.this.getAntProjectCookie()));
            this.wd.setTitle(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.PropertiesIterator")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator), (String)"TITLE_wizard_window"));
            this.wd.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
            this.wd.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
            this.wd.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
            this.wd.addPropertyChangeListener((PropertyChangeListener)this);
            Dialog dialog = TopManager.getDefault().createDialog((DialogDescriptor)this.wd);
            return dialog;
        }

        public String getAsText() {
            if (PropertiesFileProperty.this.getElement() == null) {
                return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.PropertiesIterator")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator), (String)"LBL_property_invalid_no_element");
            }
            if (PropertiesFileProperty.this.canWrite()) {
                return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.PropertiesIterator")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator), (String)"MSG_open_wizard");
            }
            return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator == null ? (class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator = PropertiesFileProperty.class$("org.apache.tools.ant.module.wizards.properties.PropertiesIterator")) : class$org$apache$tools$ant$module$wizards$properties$PropertiesIterator), (String)"MSG_any_properties_defined");
        }

        public boolean supportsCustomEditor() {
            return PropertiesFileProperty.this.canWrite();
        }

        private void insertFirstWithIndent(Element element, Node node) throws DOMException {
            Node node2 = element;
            int n = -1;
            while (!(node2 instanceof Document)) {
                node2 = node2.getParentNode();
                ++n;
            }
            Text text = ((Document)node2).createTextNode("\n" + this.spaces((n + 1) * 4));
            Node node3 = element.getFirstChild();
            if (node3 != null) {
                element.insertBefore(text, node3);
                element.insertBefore(node, node3);
            } else {
                element.appendChild(text);
                element.appendChild(node);
            }
        }

        private String spaces(int n) {
            char[] cArray = new char[n];
            int n2 = 0;
            while (n2 < n) {
                cArray[n2] = 32;
                ++n2;
            }
            return new String(cArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block14: {
                Object object;
                Object object2;
                String string;
                block13: {
                    AntProjectCookie antProjectCookie;
                    block15: {
                        if (propertyChangeEvent.getNewValue() != WizardDescriptor.OK_OPTION) break block14;
                        string = (String)this.wd.getProperty("wizdata.fileName");
                        antProjectCookie = PropertiesFileProperty.this.getAntProjectCookie();
                        if (antProjectCookie.getFileObject() == null) break block15;
                        object2 = antProjectCookie.getFileObject().getParent();
                        object = object2.getFileObject(string, PropertiesFileProperty.ANT_FILE_EXT);
                        if (object != null) break block13;
                        try {
                            object = object2.createData(string, PropertiesFileProperty.ANT_FILE_EXT);
                        }
                        catch (IOException iOException) {
                            return;
                        }
                        FileLock fileLock = null;
                        try {
                            fileLock = object.lock();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (fileLock != null) {
                            try {
                                try {
                                    String string2 = (String)this.wd.getProperty("wizdata.contents");
                                    if (string2 == null) {
                                        string2 = PropertiesFileProperty.createPropertiesHeaderString();
                                    }
                                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(object.getOutputStream(fileLock)));
                                    bufferedWriter.write(string2);
                                    bufferedWriter.close();
                                }
                                catch (IOException iOException) {
                                    AntModule.err.log("IOException while writing properties file");
                                    Object var10_14 = null;
                                    fileLock.releaseLock();
                                    break block13;
                                }
                                Object var10_13 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_15 = null;
                                fileLock.releaseLock();
                                throw throwable;
                            }
                            fileLock.releaseLock();
                        }
                        break block13;
                    }
                    if (antProjectCookie.getFile() == null) {
                        AntModule.err.log("Could not create Properties file, script FileObject missing");
                        return;
                    }
                }
                object2 = PropertiesFileProperty.this.getElement();
                try {
                    object = object2.getOwnerDocument().createElement("property");
                    object.setAttribute("file", string + "." + PropertiesFileProperty.ANT_FILE_EXT);
                    this.insertFirstWithIndent((Element)object2, (Node)object);
                }
                catch (DOMException dOMException) {
                    AntModule.err.log("Error while creating property Element.");
                }
                PropertiesFileProperty.this.firePropertiesFilePropertyChange();
            }
        }
    }
}

