/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.awt.JInlineMenu;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListener;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openide.util.enum.RemoveDuplicatesEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.windows.TopComponent;

public class FileSystemAction
extends SystemAction
implements Presenter.Menu,
Presenter.Popup {
    static final long serialVersionUID = -7572252564167491022L;
    static JMenuItem[] NONE = new JMenuItem[0];
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;

    static JMenuItem[] createMenu(boolean bl) {
        Node[] nodeArray = TopManager.getDefault().getWindowManager().getRegistry().getActivatedNodes();
        HashMap<Object, OrderedSet> hashMap = new HashMap<Object, OrderedSet>();
        if (nodeArray != null) {
            Object object;
            Object object2;
            Object object3;
            int n = 0;
            while (n < nodeArray.length) {
                object3 = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? FileSystemAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                while (object3 instanceof DataShadow) {
                    object3 = ((DataShadow)object3).getOriginal();
                }
                if (object3 != null) {
                    try {
                        object2 = ((DataObject)object3).getPrimaryFile().getFileSystem();
                        object = (Set)hashMap.get(object2);
                        if (object == null) {
                            object = new OrderedSet();
                            hashMap.put(object2, (OrderedSet)object);
                            object.addAll(((DataObject)object3).files());
                        } else {
                            object.addAll(((DataObject)object3).files());
                        }
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            if (hashMap.size() == 0 || hashMap.size() > 1) {
                return FileSystemAction.createMenu(EmptyEnumeration.EMPTY, bl);
            }
            object3 = hashMap.entrySet().iterator();
            object2 = new QueueEnumeration();
            while (object3.hasNext()) {
                Object object4;
                object = (Map.Entry)object3.next();
                FileSystem fileSystem = (FileSystem)object.getKey();
                Set set = (Set)object.getValue();
                LinkedList linkedList = new LinkedList();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(iterator.next());
                }
                if (set == null) continue;
                Iterator iterator2 = linkedList.iterator();
                while (iterator2.hasNext()) {
                    object4 = (FileObject)iterator2.next();
                    try {
                        if (((FileObject)object4).getFileSystem() == fileSystem) continue;
                        iterator2.remove();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        iterator2.remove();
                    }
                }
                object4 = new OrderedSet();
                object4.addAll(linkedList);
                ((QueueEnumeration)object2).put(fileSystem.getActions((Set)object4));
            }
            return FileSystemAction.createMenu((Enumeration)object2, bl);
        }
        return NONE;
    }

    static JMenuItem[] createMenu(Enumeration enumeration, boolean bl) {
        Object object;
        enumeration = new RemoveDuplicatesEnumeration(enumeration);
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        while (enumeration.hasMoreElements()) {
            object = (SystemAction)enumeration.nextElement();
            boolean bl2 = false;
            try {
                bl2 = ((SystemAction)object).isEnabled();
            }
            catch (RuntimeException runtimeException) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.annotate(runtimeException, 0, "Guilty action: " + object.getClass().getName(), null, null, null);
                errorManager.notify(runtimeException);
            }
            if (!bl2) continue;
            JMenuItem jMenuItem = null;
            if (bl) {
                if (object instanceof Presenter.Popup) {
                    jMenuItem = ((Presenter.Popup)object).getPopupPresenter();
                }
            } else if (object instanceof Presenter.Menu) {
                jMenuItem = ((Presenter.Menu)object).getMenuPresenter();
            }
            if (jMenuItem == null) continue;
            arrayList.add(jMenuItem);
        }
        object = new JMenuItem[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public JMenuItem getMenuPresenter() {
        return new Menu(false);
    }

    public JMenuItem getPopupPresenter() {
        return new Menu(true);
    }

    public String getName() {
        return ActionConstants.BUNDLE.getString("ACT_FileSystemAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = FileSystemAction.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class OrderedSet
    extends AbstractSet {
        private QueueEnumeration queue = new QueueEnumeration();
        Object[] objects = null;

        public boolean addAll(Collection collection) {
            this.queue.put(collection);
            return true;
        }

        private Object[] getObjects() {
            if (this.objects == null) {
                AlterEnumeration alterEnumeration = new AlterEnumeration(this, this.queue){
                    private final /* synthetic */ OrderedSet this$0;
                    {
                        this.this$0 = orderedSet;
                    }

                    public Object alter(Object object) {
                        return Collections.enumeration((Collection)object);
                    }
                };
                SequenceEnumeration sequenceEnumeration = new SequenceEnumeration(alterEnumeration);
                RemoveDuplicatesEnumeration removeDuplicatesEnumeration = new RemoveDuplicatesEnumeration(sequenceEnumeration);
                ArrayList arrayList = new ArrayList();
                int n = 0;
                while (removeDuplicatesEnumeration.hasMoreElements()) {
                    arrayList.add(removeDuplicatesEnumeration.nextElement());
                    ++n;
                }
                this.objects = arrayList.toArray();
            }
            return this.objects;
        }

        public Iterator iterator() {
            int n = this.getObjects().length;
            return new Iterator(this, n){
                int i;
                private final /* synthetic */ int val$size;
                private final /* synthetic */ OrderedSet this$0;
                {
                    this.this$0 = orderedSet;
                    this.val$size = n;
                    this.i = 0;
                }

                public boolean hasNext() {
                    return this.i < this.val$size;
                }

                public Object next() {
                    return this.this$0.objects[this.i++];
                }

                public void remove() {
                    throw new UnsupportedOperationException("Remove is not supported.");
                }
            };
        }

        public int size() {
            return this.getObjects().length;
        }
    }

    private class Menu
    extends JInlineMenu {
        private boolean popup;
        private JMenuItem[] last = NONE;
        private PropL propL = new PropL();
        static final long serialVersionUID = 2650151487189209766L;
        boolean needsChange = false;

        Menu(boolean bl) {
            this.popup = bl;
            this.changeMenuItems(FileSystemAction.createMenu(bl));
            TopComponent.Registry registry = TopManager.getDefault().getWindowManager().getRegistry();
            registry.addPropertyChangeListener(WeakListener.propertyChange(this.propL, registry));
        }

        synchronized void changeMenuItems(JMenuItem[] jMenuItemArray) {
            this.removeListeners(this.last);
            this.addListeners(jMenuItemArray);
            this.last = jMenuItemArray;
            this.setMenuItems(jMenuItemArray);
        }

        private void addListeners(JMenuItem[] jMenuItemArray) {
            int n = jMenuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                jMenuItemArray[n2].addPropertyChangeListener(this.propL);
                ++n2;
            }
        }

        private void removeListeners(JMenuItem[] jMenuItemArray) {
            int n = jMenuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                jMenuItemArray[n2].removePropertyChangeListener(this.propL);
                ++n2;
            }
        }

        public void addNotify() {
            if (this.needsChange) {
                this.changeMenuItems(FileSystemAction.createMenu(this.popup));
                this.needsChange = false;
            }
            super.addNotify();
        }

        public void removeNotify() {
            this.removeListeners(this.last);
            this.last = NONE;
        }

        private class PropL
        implements PropertyChangeListener {
            private PropL() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string == null || string.equals("enabled") || string.equals("activatedNodes")) {
                    Menu.this.needsChange = true;
                }
            }
        }
    }
}

