/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.NodeAction;
import org.openide.util.datatransfer.NewType;

public final class NewAction
extends NodeAction {
    static final long serialVersionUID = 5569219524388004456L;
    private static ActSubMenuModel model = new ActSubMenuModel();
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    protected void performAction(Node[] nodeArray) {
        this.performAction(nodeArray, 0);
    }

    private void performAction(int n) {
        this.performAction(TopManager.getDefault().getWindowManager().getRegistry().getCurrentNodes(), n);
    }

    private void performAction(Node[] nodeArray, int n) {
        NewType[] newTypeArray = NewAction.getNewTypes(nodeArray);
        if (newTypeArray.length <= n) {
            return;
        }
        try {
            newTypeArray[n].create();
        }
        catch (IOException iOException) {
            TopManager.getDefault().notify(new NotifyDescriptor.Message(iOException.getMessage(), 0));
        }
    }

    private static NewType[] getNewTypes() {
        return NewAction.getNewTypes(TopManager.getDefault().getWindowManager().getRegistry().getCurrentNodes());
    }

    private static NewType[] getNewTypes(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return new NewType[0];
        }
        return nodeArray[0].getNewTypes();
    }

    protected boolean enable(Node[] nodeArray) {
        NewType[] newTypeArray = NewAction.getNewTypes();
        Object[] objectArray = model.getListenerList();
        if (objectArray.length > 0) {
            ChangeEvent changeEvent = new ChangeEvent(model);
            int n = objectArray.length - 1;
            while (n >= 0) {
                ((ChangeListener)objectArray[n]).stateChanged(changeEvent);
                n -= 2;
            }
        }
        return newTypeArray.length > 0;
    }

    public String getName() {
        NewType[] newTypeArray = NewAction.getNewTypes();
        if (newTypeArray != null && newTypeArray.length == 1) {
            return ActionConstants.getString("NewArg", newTypeArray[0].getName());
        }
        return ActionConstants.BUNDLE.getString("New");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = NewAction.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction);
    }

    protected String iconResource() {
        return "/org/openide/resources/actions/new.gif";
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.SubMenu(this, model, false);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu(this, model, true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ActSubMenuModel
    extends EventListenerList
    implements Actions.SubMenuModel {
        static final long serialVersionUID = -4273674308662494596L;

        ActSubMenuModel() {
        }

        public int getCount() {
            return NewAction.getNewTypes().length;
        }

        public String getLabel(int n) {
            NewType[] newTypeArray = NewAction.getNewTypes();
            if (newTypeArray.length <= n) {
                return null;
            }
            return newTypeArray[n].getName();
        }

        public HelpCtx getHelpCtx(int n) {
            NewType[] newTypeArray = NewAction.getNewTypes();
            if (newTypeArray.length <= n) {
                return null;
            }
            return newTypeArray[n].getHelpCtx();
        }

        public void performActionAt(int n) {
            NewAction newAction = (NewAction)SharedClassObject.findObject(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = NewAction.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction);
            if (newAction == null) {
                return;
            }
            newAction.performAction(n);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = NewAction.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = NewAction.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }
    }
}

