/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openide.awt.JPopupMenuUtils;

public class JInlineMenu
extends JMenuItem {
    static final long serialVersionUID = -2310488127953523571L;
    private JSeparator north = new JSeparator();
    private JSeparator south = new JSeparator();
    private JComponent[] items = new JComponent[0];
    boolean upToDate;

    public JInlineMenu() {
        this.setEnabled(false);
        this.upToDate = true;
    }

    public void addNotify() {
        super.addNotify();
        if (this.upToDate) {
            return;
        }
        this.addItems();
    }

    private List getAllInlineItems() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(this.items.length);
        int n = 0;
        while (n < this.items.length) {
            JComponent jComponent = this.items[n];
            if (jComponent instanceof JInlineMenu) {
                arrayList.addAll(((JInlineMenu)jComponent).getAllInlineItems());
            } else {
                arrayList.add(jComponent);
            }
            ++n;
        }
        return arrayList;
    }

    private void updateItems() {
        Container container = this.getParent();
        if (container instanceof JInlineMenu) {
            ((JInlineMenu)container).updateItems();
        } else {
            this.addItems();
        }
    }

    private void updateContents(JComponent[] jComponentArray) {
        this.upToDate = false;
        this.removeItems();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(jComponentArray.length);
        int n = 0;
        while (n < jComponentArray.length) {
            JComponent jComponent = jComponentArray[n];
            if (jComponent == null) {
                arrayList.add(new JSeparator());
            } else {
                arrayList.add(jComponent);
            }
            ++n;
        }
        this.items = arrayList.toArray(new JComponent[0]);
        this.updateItems();
    }

    public void setMenuItems(final JMenuItem[] jMenuItemArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JInlineMenu.this.updateContents(jMenuItemArray);
            }
        });
    }

    private static int findIndex(Object object, Object[] objectArray) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (object == objectArray[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void removeItems() {
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent == null) {
            return;
        }
        if (jComponent instanceof JInlineMenu) {
            ((JInlineMenu)jComponent).removeItems();
            return;
        }
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                if (this.items[n] instanceof JInlineMenu) {
                    Component[] componentArray = ((JInlineMenu)this.items[n]).getAllInlineItems().toArray(new Component[0]);
                    int n2 = 0;
                    while (n2 < componentArray.length) {
                        jComponent.remove(componentArray[n2]);
                        ++n2;
                    }
                }
                jComponent.remove(this.items[n]);
                ++n;
            }
        }
        jComponent.remove(this.north);
        jComponent.remove(this.south);
    }

    void addItems() {
        int n;
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent == null) {
            return;
        }
        boolean bl = false;
        if (jComponent instanceof JPopupMenu) {
            bl = JPopupMenuUtils.isPopupContained((JPopupMenu)jComponent);
        }
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(this.items.length);
        int n2 = 0;
        while (n2 < this.items.length) {
            if (this.items[n2] instanceof JInlineMenu) {
                arrayList.addAll(((JInlineMenu)this.items[n2]).getAllInlineItems());
            } else {
                arrayList.add(this.items[n2]);
            }
            ++n2;
        }
        JComponent[] jComponentArray = arrayList.toArray(new JComponent[0]);
        Object[] objectArray = jComponent.getComponents();
        int n3 = JInlineMenu.findIndex(this, objectArray);
        if (n3 == -1) {
            return;
        }
        if (!(n3 <= 0 || objectArray.length <= 0 || objectArray[n3 - 1] instanceof JPopupMenu.Separator || objectArray[n3 - 1] instanceof JSeparator || objectArray[n3 - 1] instanceof JInlineMenu)) {
            jComponent.add((Component)this.north, n3++);
            objectArray = jComponent.getComponents();
        }
        if (n3 < objectArray.length - 1) {
            if (jComponentArray.length > 0 && !(objectArray[n3 + 1] instanceof JPopupMenu.Separator) && !(objectArray[n3 + 1] instanceof JSeparator)) {
                jComponent.add((Component)this.south, n3 + 1);
            } else if (jComponentArray.length == 0 && (objectArray[n3 + 1] instanceof JPopupMenu.Separator || objectArray[n3 + 1] instanceof JSeparator)) {
                jComponent.remove(n3 + 1);
                objectArray = jComponent.getComponents();
            }
        }
        if (n3 > objectArray.length) {
            n = jComponentArray.length;
            int n4 = 0;
            while (n4 < n) {
                jComponent.add(jComponentArray[n4]);
                ++n4;
            }
        } else {
            n = jComponentArray.length;
            int n5 = 0;
            while (n5 < n) {
                jComponent.add((Component)jComponentArray[n5], ++n3);
                if (jComponentArray[n5] instanceof JInlineMenu) {
                    JInlineMenu jInlineMenu = (JInlineMenu)jComponentArray[n5];
                    n3 += jInlineMenu.items.length;
                }
                ++n5;
            }
        }
        this.upToDate = true;
        if (jComponent instanceof JPopupMenu) {
            JPopupMenu jPopupMenu = (JPopupMenu)jComponent;
            JPopupMenuUtils.dynamicChange(jPopupMenu, bl);
        }
    }

    public Dimension getPreferredSize() {
        if (this.isVisible()) {
            return new Dimension(0, 0);
        }
        return Toolkit.getDefaultToolkit().getScreenSize();
    }
}

