/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class MouseUtils {
    private static int DOUBLE_CLICK_DELTA = 300;
    private static int tempx = 0;
    private static int tempy = 0;
    private static long temph = 0L;
    private static int tempm = 0;

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return (n & 0x10) == 0 && (n & 0xC) != 0;
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent);
    }

    public static boolean isDoubleClick(MouseEvent mouseEvent) {
        return mouseEvent.getClickCount() % 2 == 0 || MouseUtils.isDoubleClickImpl(mouseEvent);
    }

    private static boolean isDoubleClickImpl(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        long l = mouseEvent.getWhen();
        int n3 = mouseEvent.getModifiers();
        if (tempx == n && tempy == n2 && l - temph < (long)DOUBLE_CLICK_DELTA && n3 == tempm) {
            tempx = 0;
            tempy = 0;
            temph = 0L;
            tempm = 0;
            return true;
        }
        tempx = n;
        tempy = n2;
        temph = l;
        tempm = n3;
        return false;
    }

    public static abstract class PopupMouseAdapter
    extends MouseAdapter {
        public static final int DEFAULT_THRESHOLD = 5;
        int threshold;
        Point pressedPos;

        public PopupMouseAdapter() {
            this(5);
        }

        public PopupMouseAdapter(int n) {
            this.threshold = n;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.pressedPos != null) {
                this.pressedPos = null;
                return;
            }
            int n = mouseEvent.getModifiers();
            if ((n & 8) != 0 || (n & 4) != 0) {
                this.pressedPos = mouseEvent.getPoint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if (((n & 8) != 0 || (n & 4) != 0) && this.pressedPos != null) {
                Point point = mouseEvent.getPoint();
                if (Math.abs(this.pressedPos.x - point.x) < this.threshold && Math.abs(this.pressedPos.y - point.y) < this.threshold) {
                    this.showPopup(mouseEvent);
                }
                this.pressedPos = null;
            }
        }

        protected abstract void showPopup(MouseEvent var1);
    }
}

