/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.openide.awt.EnabledButtonModel;
import org.openide.awt.ToolbarButtonUI;

public class ToolbarButton
extends JButton {
    static final long serialVersionUID = 6564434578524381134L;
    boolean disabled;

    public ToolbarButton(Icon icon) {
        super(null, icon);
        this.setModel(new EnabledButtonModel());
        this.setMargin(new Insets(2, 1, 0, 1));
    }

    public void updateUI() {
        this.setUI(UIManager.getLookAndFeel().getName().equals("Windows") ? ToolbarButtonUI.createUI(this) : UIManager.getUI(this));
    }

    public Icon getDisabledIcon() {
        if (!this.disabled) {
            this.setDisabledIcon(ToolbarButton.createDisabledIcon(this.getIcon()));
            this.disabled = true;
        }
        return super.getDisabledIcon();
    }

    public boolean isFocusTraversable() {
        return super.isFocusTraversable();
    }

    static Icon createDisabledIcon(Icon icon) {
        if (!(icon instanceof ImageIcon)) {
            return null;
        }
        ImageIcon imageIcon = (ImageIcon)icon;
        Image image = imageIcon.getImage();
        if (!(image instanceof BufferedImage)) {
            return null;
        }
        BufferedImage bufferedImage = (BufferedImage)image;
        int[] nArray = bufferedImage.getRGB(0, 0, 16, 16, new int[256], 0, 16);
        GrayFilter grayFilter = new GrayFilter(true, 50);
        int n = 0;
        while (n < 256) {
            nArray[n] = grayFilter.filterRGB(0, 0, nArray[n]);
            ++n;
        }
        BufferedImage bufferedImage2 = new BufferedImage(16, 16, 2);
        bufferedImage2.setRGB(0, 0, 16, 16, nArray, 0, 16);
        return new ImageIcon(bufferedImage2);
    }
}

