/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

public class ExplorerActions {
    private ActionPerformer copyActionPerformer;
    private ActionPerformer cutActionPerformer;
    private ActionPerformer deleteActionPerformer;
    private Listener listener;
    ExplorerManager manager;
    private boolean confirmDelete = true;
    static CopyAction copy = null;
    static CutAction cut = null;
    static DeleteAction delete = null;
    static PasteAction paste = null;
    private static boolean isConfirmed;
    private static String title;
    private static String message;
    static ThreadLocal destroyRunnable;
    static ThreadLocal selectedNodes;
    private static final int DELAY = 150;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$openide$filesystems$FileSystem$AtomicAction;
    static /* synthetic */ Class class$org$openide$loaders$DataShadow;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerActions;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public synchronized void attach(ExplorerManager explorerManager) {
        if (this.manager != null) {
            this.detach();
        }
        this.manager = explorerManager;
        if (this.listener == null) {
            this.listener = new Listener();
        }
        this.manager.addPropertyChangeListener(this.listener);
        Clipboard clipboard = ExplorerActions.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            exClipboard.addClipboardListener(this.listener);
        }
        this.updateActions();
    }

    public synchronized void detach() {
        if (this.manager == null) {
            return;
        }
        this.manager.removePropertyChangeListener(this.listener);
        Clipboard clipboard = ExplorerActions.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            exClipboard.removeClipboardListener(this.listener);
        }
        this.stopActions();
        this.manager = null;
    }

    ExplorerManager getAttachedManager() {
        return this.manager;
    }

    public final void setConfirmDelete(boolean bl) {
        this.confirmDelete = bl;
    }

    public final boolean isConfirmDelete() {
        return this.confirmDelete;
    }

    void stopActions() {
        if (this.copyActionPerformer != null) {
            if (copy.getActionPerformer() instanceof CopyCutActionPerformer) {
                copy.setActionPerformer(null);
            }
            if (cut.getActionPerformer() instanceof CopyCutActionPerformer) {
                cut.setActionPerformer(null);
            }
            paste.setPasteTypes(null);
            if (delete.getActionPerformer() instanceof DeleteActionPerformer) {
                delete.setActionPerformer(null);
            }
        }
    }

    void updateActions() {
        int n;
        if (this.manager == null) {
            return;
        }
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (this.copyActionPerformer == null) {
            this.copyActionPerformer = new CopyCutActionPerformer(true);
            this.cutActionPerformer = new CopyCutActionPerformer(false);
            this.deleteActionPerformer = new DeleteActionPerformer();
            copy = (CopyAction)CopyAction.findObject(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ExplorerActions.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction, true);
            cut = (CutAction)CutAction.findObject(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ExplorerActions.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction, true);
            paste = (PasteAction)PasteAction.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ExplorerActions.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction, true);
            delete = (DeleteAction)DeleteAction.findObject(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ExplorerActions.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction, true);
        }
        int n2 = n = nodeArray != null ? nodeArray.length : 0;
        if (n > 0) {
            int n3;
            boolean bl = false;
            if (n > 1) {
                HashMap hashMap = new HashMap(101);
                n3 = 0;
                while (n3 < n) {
                    if (!this.checkParents(nodeArray[n3], hashMap)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < n) {
                if (bl || !nodeArray[n3].canCopy()) {
                    copy.setActionPerformer(null);
                    break;
                }
                ++n3;
            }
            if (n3 == n) {
                copy.setActionPerformer(this.copyActionPerformer);
            }
            n3 = 0;
            while (n3 < n) {
                if (bl || !nodeArray[n3].canCut()) {
                    cut.setActionPerformer(null);
                    break;
                }
                ++n3;
            }
            if (n3 == n) {
                cut.setActionPerformer(this.cutActionPerformer);
            }
            n3 = 0;
            while (n3 < n) {
                if (bl || !nodeArray[n3].canDestroy()) {
                    delete.setActionPerformer(null);
                    break;
                }
                ++n3;
            }
            if (n3 == n) {
                delete.setActionPerformer(this.deleteActionPerformer);
            }
        } else {
            copy.setActionPerformer(null);
            cut.setActionPerformer(null);
            delete.setActionPerformer(null);
        }
        this.updatePasteAction(nodeArray);
    }

    private boolean checkParents(Node node, HashMap hashMap) {
        if (hashMap.get(node) != null) {
            return false;
        }
        hashMap.put(node, this);
        do {
            if ((node = node.getParentNode()) != null) continue;
            return true;
        } while (hashMap.put(node, node) != this);
        return false;
    }

    private void updatePasteAction(Node[] nodeArray) {
        Clipboard clipboard;
        Transferable transferable;
        ExplorerManager explorerManager = this.manager;
        if (explorerManager == null) {
            paste.setPasteTypes(null);
            return;
        }
        if (nodeArray != null && nodeArray.length > 1) {
            paste.setPasteTypes(null);
            return;
        }
        Node node = explorerManager.getExploredContext();
        Node[] nodeArray2 = explorerManager.getSelectedNodes();
        if (nodeArray2 != null && nodeArray2.length == 1) {
            node = nodeArray2[0];
        }
        if ((transferable = (clipboard = ExplorerActions.getClipboard()).getContents(this)) != null) {
            PasteType[] pasteTypeArray;
            PasteType[] pasteTypeArray2 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferable);
            if (pasteTypeArray.length != 0) {
                paste.setPasteTypes(pasteTypeArray);
                return;
            }
            boolean bl = false;
            try {
                bl = transferable.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                try {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    int n = multiTransferObject.getCount();
                    boolean bl2 = true;
                    Transferable[] transferableArray = new Transferable[n];
                    PasteType[] pasteTypeArray3 = new PasteType[n];
                    int n2 = 0;
                    while (n2 < n) {
                        transferableArray[n2] = multiTransferObject.getTransferableAt(n2);
                        PasteType[] pasteTypeArray4 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferableArray[n2]);
                        if (pasteTypeArray.length == 0) {
                            bl2 = false;
                            break;
                        }
                        pasteTypeArray3[n2] = pasteTypeArray[0];
                        ++n2;
                    }
                    if (bl2) {
                        paste.setPasteTypes(new PasteType[]{new MultiPasteType(transferableArray, pasteTypeArray3)});
                        return;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (paste != null) {
            paste.setPasteTypes(null);
        }
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = ExplorerActions.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        destroyRunnable = new ThreadLocal();
        selectedNodes = new ThreadLocal();
    }

    private class Listener
    implements PropertyChangeListener,
    ClipboardListener,
    Runnable {
        private RequestProcessor.Task task = RequestProcessor.createRequest(this);

        Listener() {
            this.task.setPriority(9);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.task.getDelay() == 0) {
                ExplorerActions.this.updateActions();
            }
            this.task.schedule(150);
        }

        public void clipboardChanged(ClipboardEvent clipboardEvent) {
            if (!clipboardEvent.isConsumed()) {
                ExplorerActions.this.updatePasteAction(ExplorerActions.this.manager.getSelectedNodes());
            }
        }

        public void run() {
            ExplorerActions.this.updateActions();
        }
    }

    static class ConfirmationInvoker
    implements Runnable {
        ConfirmationInvoker() {
        }

        public void run() {
            Object object;
            Node[] nodeArray = (Node[])selectedNodes.get();
            selectedNodes.set(null);
            if (nodeArray == null) {
                throw new IllegalStateException("ConfirmationInvoker didn't get parameter sel.");
            }
            if (nodeArray.length == 1) {
                if (nodeArray[0].getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ExplorerActions.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow) != null) {
                    title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteShadowTitle");
                    object = (DataShadow)nodeArray[0].getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ExplorerActions.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
                    message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteShadow", new Object[]{((DataObject)object).getName(), nodeArray[0].getDisplayName(), this.fullName((DataObject)object), this.fullName(((DataShadow)object).getOriginal())});
                } else if (nodeArray[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ExplorerActions.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != null) {
                    message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteFolder", nodeArray[0].getDisplayName());
                    title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteFolderTitle");
                } else {
                    message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObject", nodeArray[0].getDisplayName());
                    title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjectTitle");
                }
            } else {
                message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjects", new Integer(nodeArray.length));
                title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = ExplorerActions.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjectsTitle");
            }
            object = new NotifyDescriptor.Confirmation((Object)message, title, 0);
            isConfirmed = NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)object));
        }

        private String fullName(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject.isRoot()) {
                try {
                    return fileObject.getFileSystem().getDisplayName();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return "";
                }
            }
            return fileObject.toString();
        }
    }

    static class DestroyInvoker
    implements Runnable {
        DestroyInvoker() {
        }

        public void run() {
            Object t = destroyRunnable.get();
            destroyRunnable.set(null);
            if (t == null) {
                throw new IllegalStateException("DestroyInvoker didn't get parameter dr.");
            }
            try {
                FileSystem.AtomicAction atomicAction = (FileSystem.AtomicAction)Proxy.newProxyInstance((class$org$openide$filesystems$FileSystem$AtomicAction == null ? (class$org$openide$filesystems$FileSystem$AtomicAction = ExplorerActions.class$("org.openide.filesystems.FileSystem$AtomicAction")) : class$org$openide$filesystems$FileSystem$AtomicAction).getClassLoader(), new Class[]{class$org$openide$filesystems$FileSystem$AtomicAction == null ? (class$org$openide$filesystems$FileSystem$AtomicAction = ExplorerActions.class$("org.openide.filesystems.FileSystem$AtomicAction")) : class$org$openide$filesystems$FileSystem$AtomicAction}, (InvocationHandler)t);
                TopManager.getDefault().getRepository().getDefaultFileSystem().runAtomicAction(atomicAction);
                return;
            }
            catch (IOException iOException) {
                IllegalStateException illegalStateException = new IllegalStateException();
                ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ExplorerActions.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                if (errorManager != null) {
                    errorManager.annotate((Throwable)illegalStateException, iOException);
                }
                throw illegalStateException;
            }
        }
    }

    class DeleteActionPerformer
    implements ActionPerformer {
        DeleteActionPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            Node[] nodeArray = ExplorerActions.this.manager.getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            isConfirmed = !ExplorerActions.this.confirmDelete;
            if (!isConfirmed) {
                selectedNodes.set(nodeArray);
                this.doConfirm();
            }
            if (isConfirmed) {
                try {
                    if (ExplorerActions.this.manager != null) {
                        ExplorerActions.this.manager.setSelectedNodes(new Node[0]);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(nodeArray);
                delete.setActionPerformer(null);
            }
        }

        void doConfirm() {
            try {
                Class<?> clazz = Class.forName("org.openide.explorer.ExplorerActions$ConfirmationInvoker");
                Runnable runnable = (Runnable)clazz.newInstance();
                runnable.run();
                return;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                int n = JOptionPane.showConfirmDialog(null, message, title, 0);
                isConfirmed = n == 0;
                return;
            }
        }

        void doDestroy(Node[] nodeArray) {
            DestroyAtomic destroyAtomic = new DestroyAtomic();
            destroyAtomic.sel = nodeArray;
            destroyRunnable.set(destroyAtomic);
            try {
                Class<?> clazz = Class.forName("org.openide.explorer.ExplorerActions$DestroyInvoker");
                Runnable runnable = (Runnable)clazz.newInstance();
                runnable.run();
                return;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (Throwable throwable) {
                block7: {
                    try {
                        destroyAtomic.invoke(null, null, null);
                    }
                    catch (Throwable throwable2) {
                        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ExplorerActions.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                        if (errorManager != null) {
                            errorManager.notify(throwable2);
                            break block7;
                        }
                        throwable2.printStackTrace();
                    }
                }
                return;
            }
        }

        class DestroyAtomic
        implements InvocationHandler {
            Node[] sel;

            DestroyAtomic() {
            }

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                int n = 0;
                while (n < this.sel.length) {
                    try {
                        this.sel[n].destroy();
                    }
                    catch (IOException iOException) {
                        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? ExplorerActions.class$("org.openide.ErrorManager") : class$org$openide$ErrorManager);
                        if (errorManager != null) {
                            errorManager.notify(iOException);
                        }
                        iOException.printStackTrace();
                    }
                    ++n;
                }
                return null;
            }
        }
    }

    class CopyCutActionPerformer
    implements ActionPerformer {
        boolean copyCut;

        public CopyCutActionPerformer(boolean bl) {
            this.copyCut = bl;
        }

        public void performAction(SystemAction systemAction) {
            Transferable[] transferableArray;
            Transferable transferable = null;
            Node[] nodeArray = ExplorerActions.this.manager.getSelectedNodes();
            if (nodeArray.length != 1) {
                transferableArray = new Transferable[nodeArray.length];
                int n = 0;
                while (n < nodeArray.length) {
                    transferableArray[n] = this.getTransferableOwner(nodeArray[n]);
                    if (transferableArray[n] == null) {
                        return;
                    }
                    ++n;
                }
                transferable = new ExTransferable.Multi(transferableArray);
            } else {
                transferable = this.getTransferableOwner(nodeArray[0]);
            }
            if (transferable != null) {
                transferableArray = ExplorerActions.getClipboard();
                transferableArray.setContents(transferable, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copyCut ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException iOException) {
                ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ExplorerActions.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                if (errorManager != null) {
                    errorManager.notify(1, iOException);
                } else {
                    iOException.printStackTrace();
                }
                return null;
            }
        }
    }

    private static class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] transferableArray, PasteType[] pasteTypeArray) {
            this.t = transferableArray;
            this.p = pasteTypeArray;
        }

        public Transferable paste() throws IOException {
            int n = this.p.length;
            Transferable[] transferableArray = new Transferable[n];
            int n2 = 0;
            while (n2 < n) {
                Transferable transferable = this.p[n2].paste();
                transferableArray[n2] = transferable != null ? transferable : this.t[n2];
                ++n2;
            }
            return new ExTransferable.Multi(transferableArray);
        }
    }
}

