/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.EmptyPanel;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.explorer.propertysheet.PropertySheetTab;
import org.openide.explorer.propertysheet.PropertySheetToolbar;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public class PropertySheet
extends JPanel {
    static final long serialVersionUID = -7698351033045864945L;
    public static final String PROPERTY_SORTING_MODE = "sortingMode";
    public static final String PROPERTY_VALUE_COLOR = "valueColor";
    public static final String PROPERTY_DISABLED_PROPERTY_COLOR = "disabledPropertyColor";
    public static final String PROPERTY_CURRENT_PAGE = "currentPage";
    public static final String PROPERTY_PLASTIC = "plastic";
    public static final String PROPERTY_PROPERTY_PAINTING_STYLE = "propertyPaintingStyle";
    public static final String PROPERTY_DISPLAY_WRITABLE_ONLY = "displayWritableOnly";
    public static final int ALWAYS_AS_STRING = 1;
    public static final int STRING_PREFERRED = 2;
    public static final int PAINTING_PREFERRED = 3;
    public static final int UNSORTED = 0;
    public static final int SORTED_BY_NAMES = 1;
    public static final int SORTED_BY_TYPES = 2;
    protected static Icon iNoSort;
    protected static Icon iAlphaSort;
    protected static Icon iTypeSort;
    protected static Icon iDisplayWritableOnly;
    protected static Icon iCustomize;
    static final String PROP_HAS_CUSTOMIZER = "hasCustomizer";
    static final String PROP_PAGE_HELP_ID = "pageHelpID";
    private transient JTabbedPane pages;
    private transient EmptyPanel emptyPanel;
    private transient int pageIndex = 0;
    private transient PropertyChangeListener settingsListener;
    private transient ChangeListener tabListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            int n = PropertySheet.this.pages.getSelectedIndex();
            PropertySheet.this.setCurrentPage(n);
        }
    };
    private Node activeNode;
    private NodeListener activeNodeListener;
    private boolean displayWritableOnly;
    private int propertyPaintingStyle;
    private int sortingMode;
    private boolean plastic;
    private Color disabledPropertyColor;
    private Color valueColor;
    static ThreadLocal current;
    private transient RunNodes runNodes;
    private static Method helpMethod;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheet;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheet$HelpAwareJTabbedPane;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet).getString(string);
    }

    public PropertySheet() {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        try {
            serializable = Class.forName("org.openide.explorer.propertysheet.PropertySheet$PropertySheetSettingsInvoker");
            Runnable runnable = (Runnable)serializable.newInstance();
            current.set(this);
            runnable.run();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.displayWritableOnly = false;
            this.propertyPaintingStyle = 3;
            this.sortingMode = 1;
            this.plastic = false;
            this.disabledPropertyColor = SystemColor.textInactiveText;
            this.valueColor = new Color(0, 0, 128);
        }
        this.pages = new HelpAwareJTabbedPane();
        this.pages.getAccessibleContext().setAccessibleName(PropertySheet.getString("ACS_PropertySheetTabs"));
        this.pages.getAccessibleContext().setAccessibleDescription(PropertySheet.getString("ACSD_PropertySheetTabs"));
        this.pages.addChangeListener(this.tabListener);
        this.emptyPanel = new EmptyPanel(PropertySheet.getString("CTL_NoProperties"));
        this.pages.setTabPlacement(3);
        this.add((Component)this.emptyPanel, "Center");
        serializable = new PropertySheetToolbar(this);
        this.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.add((Component)serializable, "North");
        this.setNodes(new Node[0]);
        this.setPreferredSize(new Dimension(200, 300));
    }

    public void setNodes(Node[] nodeArray) {
        this.postSetNodes(nodeArray);
    }

    public void setPropertyPaintingStyle(int n) {
        if (n == this.propertyPaintingStyle) {
            return;
        }
        int n2 = this.propertyPaintingStyle;
        this.propertyPaintingStyle = n;
        this.firePropertyChange(PROPERTY_PROPERTY_PAINTING_STYLE, new Integer(n2), new Integer(n));
    }

    public int getPropertyPaintingStyle() {
        return this.propertyPaintingStyle;
    }

    public void setSortingMode(int n) throws PropertyVetoException {
        if (this.sortingMode == n) {
            return;
        }
        int n2 = this.sortingMode;
        this.sortingMode = n;
        this.firePropertyChange(PROPERTY_SORTING_MODE, new Integer(n2), new Integer(n));
    }

    public int getSortingMode() {
        return this.sortingMode;
    }

    public void setCurrentPage(int n) {
        if (this.pageIndex == n) {
            return;
        }
        this.pageIndex = n;
        if (n < 0) {
            return;
        }
        if (n != this.pages.getSelectedIndex()) {
            this.pages.setSelectedIndex(n);
        }
        this.firePropertyChange(PROP_PAGE_HELP_ID, null, null);
    }

    public boolean setCurrentPage(String string) {
        int n = this.pages.indexOfTab(string);
        if (n < 0) {
            return false;
        }
        this.setCurrentPage(n);
        return true;
    }

    public int getCurrentPage() {
        return this.pages.getSelectedIndex();
    }

    String getPageHelpID() {
        String string;
        Component component;
        if (this.isAncestorOf(this.pages) && (component = this.pages.getSelectedComponent()) instanceof PropertySheetTab && (string = ((PropertySheetTab)component).getHelpID()) != null) {
            return string;
        }
        return null;
    }

    public void setPlastic(boolean bl) {
        if (this.plastic == bl) {
            return;
        }
        this.plastic = bl;
        this.firePropertyChange(PROPERTY_PLASTIC, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getPlastic() {
        return this.plastic;
    }

    public void setValueColor(Color color) {
        if (this.valueColor.equals(color)) {
            return;
        }
        Color color2 = this.valueColor;
        this.valueColor = color;
        this.firePropertyChange(PROPERTY_VALUE_COLOR, color2, color);
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setDisabledPropertyColor(Color color) {
        if (this.disabledPropertyColor.equals(color)) {
            return;
        }
        Color color2 = this.disabledPropertyColor;
        this.disabledPropertyColor = color;
        this.firePropertyChange(PROPERTY_DISABLED_PROPERTY_COLOR, color2, color);
    }

    public Color getDisabledPropertyColor() {
        return this.disabledPropertyColor;
    }

    public void setDisplayWritableOnly(boolean bl) {
        if (this.displayWritableOnly == bl) {
            return;
        }
        this.displayWritableOnly = bl;
        this.firePropertyChange(PROPERTY_DISPLAY_WRITABLE_ONLY, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getDisplayWritableOnly() {
        return this.displayWritableOnly;
    }

    private void refreshPropertySheet(Node node) {
        Node.PropertySet[] propertySetArray;
        String string = null;
        if (this.activeNode != null) {
            this.activeNode.removeNodeListener(this.activeNodeListener);
            propertySetArray = this.activeNode.getPropertySets();
            if (this.pageIndex >= 0 && this.pageIndex < propertySetArray.length) {
                string = propertySetArray[this.pageIndex].getDisplayName();
            }
        }
        this.activeNode = node;
        if (this.activeNode != null) {
            this.activeNodeListener = new ActiveNodeListener();
            this.activeNode.addNodeListener(WeakListener.node(this.activeNodeListener, this.activeNode));
        }
        propertySetArray = null;
        if (node != null) {
            propertySetArray = node.getPropertySets();
        }
        int n = this.pages.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            ((PropertySheetTab)this.pages.getComponentAt(0)).detachPropertyChangeListener();
            this.pages.removeTabAt(0);
            ++n2;
        }
        if (propertySetArray != null && propertySetArray.length > 0) {
            int n3 = 0;
            while (n3 < propertySetArray.length) {
                if (!propertySetArray[n3].isHidden()) {
                    this.pages.addTab(propertySetArray[n3].getDisplayName(), null, new PropertySheetTab(propertySetArray[n3], node, this), propertySetArray[n3].getShortDescription());
                }
                ++n3;
            }
            if (this.isAncestorOf(this.emptyPanel)) {
                this.remove(this.emptyPanel);
                this.add((Component)this.pages, "Center");
            }
        } else if (this.isAncestorOf(this.pages)) {
            this.remove(this.pages);
            this.add((Component)this.emptyPanel, "Center");
        }
        if (this.activeNode != null && this.activeNode.hasCustomizer()) {
            this.firePropertyChange(PROP_HAS_CUSTOMIZER, null, Boolean.TRUE);
        } else {
            this.firePropertyChange(PROP_HAS_CUSTOMIZER, null, Boolean.FALSE);
        }
        if (string != null) {
            this.setCurrentPage(string);
        }
        this.firePropertyChange(PROP_PAGE_HELP_ID, null, null);
    }

    void invokeCustomization() {
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.PropertySheet$CustomizationInvoker");
            Runnable runnable = (Runnable)clazz.newInstance();
            current.set(this);
            runnable.run();
            return;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (this.activeNode == null) {
                throw new IllegalStateException();
            }
            final JDialog jDialog = new JDialog();
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add(this.activeNode.getCustomizer(), "Center");
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(NbBundle.getBundle(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet).getString("CTL_Close"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.setVisible(false);
                    jDialog.dispose();
                }
            });
            jPanel.add(jButton);
            jDialog.getContentPane().add((Component)jPanel, "South");
            jDialog.pack();
            jDialog.show();
            return;
        }
    }

    void invokeHelp() {
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.PropertySheet$HelpInvoker");
            Runnable runnable = (Runnable)clazz.newInstance();
            current.set(this);
            runnable.run();
            return;
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    void postSetNodes(Node[] nodeArray) {
        if (this.runNodes == null) {
            this.runNodes = new RunNodes();
        }
        this.runNodes.postNodes(nodeArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$1100(PropertySheet propertySheet, Node node) {
        propertySheet.refreshPropertySheet(node);
    }

    static /* synthetic */ EmptyPanel access$1200(PropertySheet propertySheet) {
        return propertySheet.emptyPanel;
    }

    static {
        current = new ThreadLocal();
        try {
            helpMethod = (class$org$openide$explorer$propertysheet$PropertySheet$HelpAwareJTabbedPane == null ? (class$org$openide$explorer$propertysheet$PropertySheet$HelpAwareJTabbedPane = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet$HelpAwareJTabbedPane")) : class$org$openide$explorer$propertysheet$PropertySheet$HelpAwareJTabbedPane).getMethod("getHelpCtx", new Class[0]);
            helpMethod.setAccessible(true);
        }
        catch (Exception exception) {
            ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = PropertySheet.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            if (errorManager != null) {
                errorManager.notify(exception);
            }
            exception.printStackTrace();
        }
    }

    private static final class HelpAwareJTabbedPane
    extends JTabbedPane {
        public HelpAwareJTabbedPane() {
            this.putClientProperty("HelpIDMethod", helpMethod);
        }

        public HelpCtx getHelpCtx() {
            String string;
            Component component = this.getSelectedComponent();
            if (component instanceof PropertySheetTab && (string = ((PropertySheetTab)component).getHelpID()) != null) {
                return new HelpCtx(string);
            }
            return HelpCtx.findHelp(this.getParent());
        }
    }

    private class RunNodes
    implements Runnable {
        private RequestProcessor.Task runTask;
        private Node[] nodes;

        private RunNodes() {
        }

        public void postNodes(Node[] nodeArray) {
            this.nodes = nodeArray;
            if (this.runTask == null) {
                this.runTask = RequestProcessor.createRequest(this);
            }
            this.runTask.schedule(250);
        }

        public void run() {
            Node node = null;
            if (this.nodes != null && this.nodes.length != 0) {
                node = this.nodes.length == 1 ? this.nodes[0] : new ProxyNode(this.nodes);
            }
            Node node2 = node;
            SwingUtilities.invokeLater(new Runnable(this, node2){
                private final /* synthetic */ Node val$nn;
                private final /* synthetic */ RunNodes this$1;
                {
                    this.this$1 = runNodes;
                    this.val$nn = node;
                }

                public void run() {
                    PropertySheet.access$1100(RunNodes.access$1000(this.this$1), this.val$nn);
                    if (RunNodes.access$1000(this.this$1).isAncestorOf(PropertySheet.access$1200(RunNodes.access$1000(this.this$1)))) {
                        RunNodes.access$1000(this.this$1).remove(PropertySheet.access$1200(RunNodes.access$1000(this.this$1)));
                        RunNodes.access$1000(this.this$1).add((Component)PropertySheet.access$1200(RunNodes.access$1000(this.this$1)), "Center");
                    }
                    if (RunNodes.access$1000(this.this$1).isAncestorOf(PropertySheet.access$000(RunNodes.access$1000(this.this$1)))) {
                        PropertySheet.access$000(RunNodes.access$1000(this.this$1)).invalidate();
                    }
                    RunNodes.access$1000(this.this$1).invalidate();
                    Container container = RunNodes.access$1000(this.this$1).getParent();
                    if (container != null) {
                        ((Component)container).validate();
                    } else {
                        RunNodes.access$1000(this.this$1).validate();
                    }
                    RunNodes.access$1000(this.this$1).repaint();
                }
            });
        }

        static /* synthetic */ PropertySheet access$1000(RunNodes runNodes) {
            return runNodes.PropertySheet.this;
        }
    }

    private class ActiveNodeListener
    extends NodeAdapter {
        private ActiveNodeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() != PropertySheet.this.activeNode) {
                return;
            }
            if (propertyChangeEvent.getPropertyName() == null || "propertySets".equals(propertyChangeEvent.getPropertyName())) {
                PropertySheet.this.setNodes(new Node[]{PropertySheet.this.activeNode});
            }
        }
    }

    static class HelpInvoker
    implements Runnable {
        HelpInvoker() {
        }

        public void run() {
            PropertySheet propertySheet = (PropertySheet)current.get();
            current.set(null);
            if (propertySheet == null || propertySheet.getPageHelpID() == null) {
                throw new IllegalStateException();
            }
            TopManager.getDefault().showHelp(new HelpCtx(propertySheet.getPageHelpID()));
        }
    }

    static class CustomizationInvoker
    implements Runnable {
        CustomizationInvoker() {
        }

        public void run() {
            PropertySheet propertySheet = (PropertySheet)current.get();
            current.set(null);
            if (propertySheet == null || propertySheet.activeNode == null) {
                throw new IllegalStateException();
            }
            TopManager.getDefault().getNodeOperation().customize(propertySheet.activeNode);
        }
    }

    static class PropertySheetSettingsInvoker
    implements Runnable {
        PropertySheetSettingsInvoker() {
        }

        public void run() {
            PropertySheet propertySheet = (PropertySheet)current.get();
            current.set(null);
            if (propertySheet == null) {
                throw new IllegalStateException();
            }
            PropertySheetSettings propertySheetSettings = PropertySheetSettings.getDefault();
            propertySheet.displayWritableOnly = propertySheetSettings.getDisplayWritableOnly();
            propertySheet.propertyPaintingStyle = propertySheetSettings.getPropertyPaintingStyle();
            propertySheet.sortingMode = propertySheetSettings.getSortingMode();
            propertySheet.plastic = propertySheetSettings.getPlastic();
            propertySheet.disabledPropertyColor = propertySheetSettings.getDisabledPropertyColor();
            propertySheet.valueColor = propertySheetSettings.getValueColor();
        }
    }
}

