/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.ObjectArrayPanel;
import org.openide.src.Identifier;
import org.openide.src.Type;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class IdentifierArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    IdentifierArrayPanel panel;
    boolean ignoreEditor = false;
    boolean ignorePanel = false;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$IdentifierArrayEditor;

    public String getAsText() {
        Identifier[] identifierArray = (Identifier[])this.getValue();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < identifierArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(identifierArray[n].getSourceName());
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Identifier[] identifierArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
        ArrayList<Identifier> arrayList = new ArrayList<Identifier>();
        while (stringTokenizer.hasMoreTokens()) {
            identifierArray = stringTokenizer.nextToken();
            try {
                Type type = Type.parse((String)identifierArray);
                if (!type.isClass()) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = MessageFormat.format(IdentifierArrayEditor.getString("MSG_InvalidIdentifier"), new Object[]{identifierArray});
                ((ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = IdentifierArrayEditor.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager)).annotate(illegalArgumentException, 256, null, string2, null, null);
                throw illegalArgumentException;
            }
            arrayList.add(Identifier.create((String)identifierArray));
        }
        identifierArray = new Identifier[arrayList.size()];
        arrayList.toArray(identifierArray);
        this.setValue(identifierArray);
    }

    public void setValue(Object object) {
        this.ignoreEditor = true;
        boolean bl = this.ignorePanel;
        this.ignorePanel = false;
        super.setValue(object);
        if (this.panel != null & !bl) {
            this.panel.setIdentifiers((Identifier[])object);
        }
        this.ignoreEditor = false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.panel == null) {
            this.panel = new IdentifierArrayPanel();
            this.panel.setIdentifiers((Identifier[])this.getValue());
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!IdentifierArrayEditor.this.ignoreEditor && "identifiers".equals(propertyChangeEvent.getPropertyName())) {
                        IdentifierArrayEditor.this.ignorePanel = true;
                        IdentifierArrayEditor.this.setValue(propertyChangeEvent.getNewValue());
                        IdentifierArrayEditor.this.ignorePanel = false;
                    }
                }
            });
        }
        return this.panel;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$editors$IdentifierArrayEditor == null ? (class$org$openide$explorer$propertysheet$editors$IdentifierArrayEditor = IdentifierArrayEditor.class$("org.openide.explorer.propertysheet.editors.IdentifierArrayEditor")) : class$org$openide$explorer$propertysheet$editors$IdentifierArrayEditor).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class IdentifierArrayPanel
    extends ObjectArrayPanel {
        public static final String PROP_IDENTIFIERS = "identifiers";
        Identifier[] prevValue = new Identifier[0];
        static final long serialVersionUID = -8655189809250688928L;

        public IdentifierArrayPanel() {
            this.getListComponent().setCellRenderer(new DefaultListCellRenderer(this){
                private final /* synthetic */ IdentifierArrayPanel this$0;
                {
                    this.this$0 = identifierArrayPanel;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (component == this) {
                        this.setText(((Identifier)object).getFullName());
                    }
                    return component;
                }
            });
        }

        public Identifier[] getIdentifiers() {
            Object[] objectArray = new Identifier[this.model.size()];
            this.model.copyInto(objectArray);
            return objectArray;
        }

        public void setIdentifiers(Identifier[] identifierArray) {
            this.model = new DefaultListModel();
            if (identifierArray != null) {
                int n = 0;
                while (n < identifierArray.length) {
                    this.model.addElement(identifierArray[n]);
                    ++n;
                }
            }
            this.getListComponent().setModel(this.model);
            this.modelChanged();
        }

        protected void modelChanged() {
            Identifier[] identifierArray = this.getIdentifiers();
            this.firePropertyChange(PROP_IDENTIFIERS, this.prevValue, identifierArray);
            this.prevValue = identifierArray;
        }

        protected Object insertNewValue() {
            return this.openInputDialog(null);
        }

        protected Object editValue(Object object) {
            return this.openInputDialog((Identifier)object);
        }

        protected Identifier openInputDialog(Identifier identifier) {
            Object object;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(IdentifierArrayEditor.getString("LAB_NewName"), IdentifierArrayEditor.getString("LAB_NewIdentifier"));
            if (identifier != null) {
                inputLine.setInputText(identifier.getSourceName());
            }
            while ((object = TopManager.getDefault().notify(inputLine)) == NotifyDescriptor.OK_OPTION) {
                String string = inputLine.getInputText();
                if (!(string == null || "".equals(string) || string.startsWith(".") || string.endsWith(".") || string.indexOf("..") != -1)) {
                    boolean bl = true;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (Utilities.isJavaIdentifier(string2)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        return Identifier.create(string);
                    }
                }
                TopManager.getDefault().notify(new NotifyDescriptor.Message(IdentifierArrayEditor.getString("MSG_NotValidID")));
            }
            return null;
        }
    }
}

