/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.openide.explorer.propertysheet.editors.StringArrayCustomEditor;
import org.openide.explorer.propertysheet.editors.StringArrayCustomizable;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringArrayEditor
implements XMLPropertyEditor,
StringArrayCustomizable {
    private static final String XML_STRING_ARRAY = "StringArray";
    private static final String XML_STRING_ITEM = "StringItem";
    private static final String ATTR_COUNT = "count";
    private static final String ATTR_INDEX = "index";
    private static final String ATTR_VALUE = "value";
    private String[] strings;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Object getValue() {
        return this.strings;
    }

    public void setValue(Object object) {
        this.strings = (String[])object;
        this.support.firePropertyChange("", null, null);
    }

    public String[] getStringArray() {
        return (String[])this.getValue();
    }

    public void setStringArray(String[] stringArray) {
        this.setValue(stringArray);
    }

    protected final String getStrings(boolean bl) {
        if (this.strings == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.strings.length) {
            stringBuffer.append(bl ? "\"" + this.strings[n] + "\"" : this.strings[n]);
            if (n != this.strings.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getAsText() {
        if (this.strings == null || this.strings.length == 0) {
            return "null";
        }
        return this.getStrings(false);
    }

    public void setAsText(String string) {
        if (string.equals("null") || string.equals("")) {
            this.setValue(null);
            return;
        }
        try {
            String[] stringArray;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            LinkedList<String> linkedList = new LinkedList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                stringArray = stringTokenizer.nextToken();
                linkedList.add(stringArray.trim());
            }
            stringArray = linkedList.toArray(new String[linkedList.size()]);
            this.setValue(stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getJavaInitializationString() {
        StringBuffer stringBuffer = new StringBuffer("new String[] { ");
        stringBuffer.append(this.getStrings(true));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new StringArrayCustomEditor(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_STRING_ARRAY);
        int n = this.strings != null ? this.strings.length : 0;
        element.setAttribute(ATTR_COUNT, Integer.toString(n));
        int n2 = 0;
        while (n2 < n) {
            Element element2 = document.createElement(XML_STRING_ITEM);
            element2.setAttribute(ATTR_INDEX, Integer.toString(n2));
            element2.setAttribute(ATTR_VALUE, this.strings[n2]);
            element.appendChild(element2);
            ++n2;
        }
        return element;
    }

    public void readFromXML(Node node) throws IOException {
        String[] stringArray;
        if (!XML_STRING_ARRAY.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = null;
        int n = 0;
        node2 = namedNodeMap.getNamedItem(ATTR_COUNT);
        if (node2 != null && (n = Integer.parseInt(node2.getNodeValue())) > 0) {
            stringArray = new String[n];
            NodeList nodeList = node.getChildNodes();
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Element element;
                if (nodeList.item(n2).getNodeType() == 1 && (element = (Element)nodeList.item(n2)).getNodeName().equals(XML_STRING_ITEM)) {
                    int n3;
                    String string = element.getAttribute(ATTR_INDEX);
                    String string2 = element.getAttribute(ATTR_VALUE);
                    if (string != null && string2 != null && (n3 = Integer.parseInt(string)) >= 0 && n3 < n) {
                        stringArray[n3] = string2;
                    }
                }
                ++n2;
            }
        } else {
            stringArray = new String[]{};
        }
        this.setValue(stringArray);
    }
}

