/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.src.Type;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TypeEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor,
ExPropertyEditor {
    private static final String[] LVALUE_TYPES = new String[]{"boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String"};
    private static final String[] RVALUE_TYPES = new String[]{"void", "boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String"};
    static final long serialVersionUID = 1423443523462351952L;
    private boolean acceptsVoid;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$TypeEditor;

    public String getAsText() {
        Object object = this.getValue();
        return object == null ? "" : object.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Type type;
        try {
            type = Type.parse(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ((ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = TypeEditor.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager)).annotate(illegalArgumentException, 256, null, TypeEditor.getString("MSG_InvalidTypeDecl"), null, null);
            throw illegalArgumentException;
        }
        if (!this.acceptsVoid && type == Type.VOID) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Void not allowed");
            ((ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = TypeEditor.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager)).annotate(illegalArgumentException, 256, null, TypeEditor.getString("MSG_VoidTypeNotPermitted"), null, null);
            throw illegalArgumentException;
        }
        this.setValue(type);
    }

    public void setValue(Object object) {
        if (!(object instanceof Type)) {
            throw new IllegalArgumentException();
        }
        super.setValue(object);
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public String[] getTags() {
        return this.acceptsVoid ? RVALUE_TYPES : LVALUE_TYPES;
    }

    public Component getInPlaceCustomEditor() {
        return null;
    }

    public boolean hasInPlaceCustomEditor() {
        return false;
    }

    public boolean supportsEditingTaggedValues() {
        return true;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        Object object = featureDescriptor.getValue("acceptVoidType");
        this.acceptsVoid = object instanceof Boolean ? (Boolean)object : true;
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$editors$TypeEditor == null ? (class$org$openide$explorer$propertysheet$editors$TypeEditor = TypeEditor.class$("org.openide.explorer.propertysheet.editors.TypeEditor")) : class$org$openide$explorer$propertysheet$editors$TypeEditor).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

