/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Image;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class NodeRenderer
implements TreeCellRenderer,
ListCellRenderer {
    private static NodeRenderer sharedInstance;
    private boolean bigIcons;
    static Border emptyBorder;
    private static VisualizerNode draggedOver;
    private static final String DEFAULT_ICON = "org/openide/resources/defaultNode.gif";
    private static ImageIcon defaultIcon;
    private static final WeakHashMap map;
    private static Tree tree;
    private static Pane pane;
    private static List list;

    public NodeRenderer() {
    }

    public NodeRenderer(boolean bl) {
        this.bigIcons = bl;
    }

    public static NodeRenderer sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new NodeRenderer();
        }
        return sharedInstance;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        VisualizerNode visualizerNode = object instanceof Node ? VisualizerNode.getVisualizer(null, (Node)object) : (VisualizerNode)object;
        return NodeRenderer.getTree().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        VisualizerNode visualizerNode;
        VisualizerNode visualizerNode2 = visualizerNode = object instanceof Node ? VisualizerNode.getVisualizer(null, (Node)object) : (VisualizerNode)object;
        if (visualizerNode == null) {
            visualizerNode = VisualizerNode.EMPTY;
        }
        JLabel jLabel = this.bigIcons ? NodeRenderer.getPane() : NodeRenderer.getList();
        return jLabel.getListCellRendererComponent(jList, visualizerNode, n, bl, bl2);
    }

    static void dragEnter(Object object) {
        draggedOver = (VisualizerNode)object;
    }

    static void dragExit() {
        draggedOver = null;
    }

    static ImageIcon getDefaultIcon() {
        if (defaultIcon == null) {
            defaultIcon = new ImageIcon(Utilities.loadImage(DEFAULT_ICON));
        }
        return defaultIcon;
    }

    static ImageIcon getIcon(Image image) {
        ImageIcon imageIcon;
        Reference reference = (Reference)map.get(image);
        ImageIcon imageIcon2 = imageIcon = reference == null ? null : (ImageIcon)reference.get();
        if (imageIcon != null) {
            return imageIcon;
        }
        imageIcon = new ImageIcon(image);
        map.put(image, new WeakReference<ImageIcon>(imageIcon));
        return imageIcon;
    }

    static Tree getTree() {
        if (tree == null) {
            tree = new Tree();
        }
        return tree;
    }

    static Pane getPane() {
        if (pane == null) {
            pane = new Pane();
        }
        return pane;
    }

    static List getList() {
        if (list == null) {
            list = new List();
        }
        return list;
    }

    static {
        emptyBorder = new EmptyBorder(1, 1, 1, 1);
        map = new WeakHashMap();
        tree = null;
        pane = null;
        list = null;
    }

    static final class Pane
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -5100925551665387243L;
        static Border focusBorder = LineBorder.createBlackLineBorder();

        public Pane() {
            this.setOpaque(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            VisualizerNode visualizerNode = (VisualizerNode)object;
            this.setIcon(NodeRenderer.getIcon(visualizerNode.node.getIcon(2)));
            this.setText(visualizerNode.displayName);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? focusBorder : emptyBorder);
            return this;
        }
    }

    static final class List
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -8387317362588264203L;
        protected static Border focusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));

        public List() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Border border;
            VisualizerNode visualizerNode = (VisualizerNode)object;
            ImageIcon imageIcon = NodeRenderer.getIcon(visualizerNode.node.getIcon(1));
            this.setIcon(imageIcon);
            this.setText(visualizerNode.displayName);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setIconTextGap(4 - imageIcon.getIconWidth() + (imageIcon.getIconWidth() > 24 ? imageIcon.getIconWidth() : 24));
            int n2 = NodeListModel.findVisualizerDepth(jList.getModel(), visualizerNode);
            Border border2 = border = bl2 || object == draggedOver ? focusBorder : emptyBorder;
            if (n2 > 0) {
                border = new CompoundBorder(new EmptyBorder(0, imageIcon.getIconWidth() * n2, 0, 0), border);
            }
            this.setBorder(border);
            return this;
        }
    }

    static final class Tree
    extends DefaultTreeCellRenderer {
        static final long serialVersionUID = -183570483117501696L;
        static Border activeBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        static Border inactiveBorder;

        Tree() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setEnabled(jTree.isEnabled());
            VisualizerNode visualizerNode = (VisualizerNode)object;
            ImageIcon imageIcon = bl2 ? NodeRenderer.getIcon(visualizerNode.node.getOpenedIcon(1)) : NodeRenderer.getIcon(visualizerNode.node.getIcon(1));
            this.setIconTextGap(4 - imageIcon.getIconWidth() + (imageIcon.getIconWidth() > 24 ? imageIcon.getIconWidth() : 24));
            this.setIcon(imageIcon);
            this.setText(visualizerNode.displayName);
            if (visualizerNode == draggedOver) {
                this.setBorder(activeBorder);
            } else {
                this.setBorder(inactiveBorder);
            }
            this.hasFocus = bl4;
            this.selected = bl;
            if (bl) {
                this.setForeground(this.getTextSelectionColor());
            } else {
                this.setForeground(this.getTextNonSelectionColor());
            }
            return this;
        }

        static {
            int n = DragDropUtilities.dragAndDropEnabled ? 1 : 0;
            inactiveBorder = new EmptyBorder(n, n, n, n);
        }
    }
}

