/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

class TableSheet
extends JScrollPane {
    protected transient JTable table;
    private transient NodeTableModel tableModel;
    static /* synthetic */ Class class$org$openide$explorer$view$TableSheet;
    static /* synthetic */ Class class$org$openide$nodes$Node$Property;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    public TableSheet() {
        this.tableModel = new NodeTableModel();
        this.initializeView();
    }

    public TableSheet(NodeTableModel nodeTableModel) {
        this.tableModel = nodeTableModel;
        this.initializeView();
    }

    private void initializeView() {
        this.table = this.createTable();
        this.initializeTable();
        this.setViewportView(this.table);
        this.setRequestFocusEnabled(false);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getBundle(class$org$openide$explorer$view$TableSheet == null ? (class$org$openide$explorer$view$TableSheet = TableSheet.class$("org.openide.explorer.view.TableSheet")) : class$org$openide$explorer$view$TableSheet).getString("ACS_TableSheet"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(class$org$openide$explorer$view$TableSheet == null ? (class$org$openide$explorer$view$TableSheet = TableSheet.class$("org.openide.explorer.view.TableSheet")) : class$org$openide$explorer$view$TableSheet).getString("ACSD_TableSheet"));
    }

    public void setNodes(Node[] nodeArray) {
        this.tableModel.setNodes(nodeArray);
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.tableModel.setProperties(propertyArray);
    }

    public final void setAutoResizeMode(int n) {
        this.table.setAutoResizeMode(n);
    }

    public final int getAutoResizeMode() {
        return this.table.getAutoResizeMode();
    }

    public final void setColumnPreferredWidth(int n, int n2) {
        this.table.getColumnModel().getColumn(n).setPreferredWidth(n2);
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
    }

    public final int getColumnPreferredWidth(int n) {
        return this.table.getColumnModel().getColumn(n).getPreferredWidth();
    }

    JTable createTable() {
        return new JTable();
    }

    private void initializeTable() {
        this.table.setModel(this.tableModel);
        PropertyPanelTableCell propertyPanelTableCell = new PropertyPanelTableCell();
        this.table.setDefaultRenderer(class$org$openide$nodes$Node$Property == null ? (class$org$openide$nodes$Node$Property = TableSheet.class$("org.openide.nodes.Node$Property")) : class$org$openide$nodes$Node$Property, propertyPanelTableCell);
        this.table.setDefaultEditor(class$org$openide$nodes$Node$Property == null ? (class$org$openide$nodes$Node$Property = TableSheet.class$("org.openide.nodes.Node$Property")) : class$org$openide$nodes$Node$Property, propertyPanelTableCell);
        this.table.getTableHeader().setDefaultRenderer(propertyPanelTableCell);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    private static void notify(int n, Throwable throwable) {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = TableSheet.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        if (errorManager != null) {
            errorManager.notify(n, throwable);
        } else {
            throwable.printStackTrace();
        }
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$view$TableSheet == null ? (class$org$openide$explorer$view$TableSheet = TableSheet.class$("org.openide.explorer.view.TableSheet")) : class$org$openide$explorer$view$TableSheet).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class EnablingScrollPaneLayout
    extends ScrollPaneLayout {
        JScrollPane dependentScrollPane;

        public EnablingScrollPaneLayout(JScrollPane jScrollPane) {
            this.dependentScrollPane = jScrollPane;
        }

        public void layoutContainer(Container container) {
            JScrollPane jScrollPane;
            boolean bl;
            super.layoutContainer(container);
            Component component = this.viewport != null ? this.viewport.getView() : null;
            Dimension dimension = component != null ? component.getPreferredSize() : new Dimension(0, 0);
            Dimension dimension2 = this.viewport != null ? this.viewport.toViewCoordinates(this.viewport.getSize()) : new Dimension(0, 0);
            boolean bl2 = component instanceof Scrollable && ((Scrollable)((Object)component)).getScrollableTracksViewportWidth();
            boolean bl3 = bl = !bl2 && dimension.width > dimension2.width;
            if (this.hsb != null) {
                this.hsb.setEnabled(bl);
            }
            if ((jScrollPane = (JScrollPane)container).getHorizontalScrollBarPolicy() != 32) {
                int n;
                int n2 = n = bl ? 32 : 30;
                if (n != this.dependentScrollPane.getHorizontalScrollBarPolicy()) {
                    this.dependentScrollPane.setHorizontalScrollBarPolicy(n);
                    this.dependentScrollPane.getViewport().invalidate();
                }
            }
        }
    }

    private static class FocusHackedPropertyPanel
    extends PropertyPanel {
        public FocusHackedPropertyPanel(PropertyModel propertyModel, int n) {
            super(propertyModel, n);
        }

        public void requestFocus() {
            this.requestDefaultFocus();
        }

        public void addNotify() {
            super.addNotify();
            this.requestFocus();
        }
    }

    private static class FocusedPropertyPanel
    extends PropertyPanel {
        boolean focused;

        public FocusedPropertyPanel(PropertyModel propertyModel, int n) {
            super(propertyModel, n);
        }

        public void setFocused(boolean bl) {
            this.focused = bl;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.focused) {
                graphics.setColor(UIManager.getColor("Button.focus"));
                graphics.drawRect(2, 1, this.getWidth() - 5, this.getHeight() - 4);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleFocusedPropertyPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleFocusedPropertyPanel
        extends JComponent.AccessibleJComponent {
            private AccessibleFocusedPropertyPanel() {
                super(FocusedPropertyPanel.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }

            public String getAccessibleName() {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                PropertyEditor propertyEditor = FocusedPropertyPanel.this.getPropertyEditor();
                return MessageFormat.format(TableSheet.getString("ACS_PropertyPanelRenderer"), featureDescriptor.getDisplayName(), propertyEditor == null ? TableSheet.getString("CTL_No_value") : propertyEditor.getAsText());
            }

            public String getAccessibleDescription() {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                Node node = (Node)((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getBeans()[0];
                Class clazz = FocusedPropertyPanel.this.getModel().getPropertyType();
                return MessageFormat.format(TableSheet.getString("ACSD_PropertyPanelRenderer"), featureDescriptor.getShortDescription(), clazz == null ? TableSheet.getString("CTL_No_type") : clazz.getName(), node.getDisplayName());
            }
        }
    }

    private static class NullPanel
    extends JPanel {
        Node node;

        NullPanel(Node node) {
            this.node = node;
        }

        void setNode(Node node) {
            this.node = node;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleNullPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleNullPanel
        extends JPanel.AccessibleJPanel {
            private AccessibleNullPanel() {
                super(NullPanel.this);
            }

            public String getAccessibleName() {
                String string = super.getAccessibleName();
                if (string == null) {
                    string = TableSheet.getString("ACS_NullPanel");
                }
                return string;
            }

            public String getAccessibleDescription() {
                String string = super.getAccessibleDescription();
                if (string == null) {
                    string = MessageFormat.format(TableSheet.getString("ACSD_NullPanel"), NullPanel.this.node.getDisplayName());
                }
                return string;
            }
        }
    }

    private static class CompoundScrollPane
    extends JPanel
    implements Scrollable {
        private CompoundScrollPane() {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }
    }

    static class ControlledTableView
    extends TableSheet {
        JScrollPane controllingView;
        Component header;
        JPanel compoundScrollPane;

        ControlledTableView(JScrollPane jScrollPane) {
            this.controllingView = jScrollPane;
            this.initializeView();
        }

        ControlledTableView(JScrollPane jScrollPane, NodeTableModel nodeTableModel) {
            super(nodeTableModel);
            this.controllingView = jScrollPane;
            this.initializeView();
        }

        public boolean isValidateRoot() {
            return false;
        }

        private void initializeView() {
            Component component = this.controllingView.getViewport().getView();
            this.controllingView.setViewportView(component);
            this.getViewport().setBackground(UIManager.getColor("Table.background"));
            this.setVerticalScrollBar(this.controllingView.getVerticalScrollBar());
            EnablingScrollPaneLayout enablingScrollPaneLayout = new EnablingScrollPaneLayout(this.controllingView);
            this.setLayout(enablingScrollPaneLayout);
            enablingScrollPaneLayout.syncWithScrollPane(this);
            enablingScrollPaneLayout = new EnablingScrollPaneLayout(this);
            this.controllingView.setLayout(enablingScrollPaneLayout);
            enablingScrollPaneLayout.syncWithScrollPane(this.controllingView);
            this.table.setBorder(null);
            this.header = new JTable().getTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, " ", false, false, 0, 0);
            MouseDragHandler mouseDragHandler = new MouseDragHandler();
            this.header.addMouseListener(mouseDragHandler);
            this.header.addMouseMotionListener(mouseDragHandler);
        }

        JTable createTable() {
            return new ATable();
        }

        JTable getTable() {
            return this.table;
        }

        public void setBorder(Border border) {
            super.setBorder(null);
        }

        void setRowHeight(int n) {
            this.table.setRowHeight(n);
            this.getVerticalScrollBar().setUnitIncrement(n);
        }

        void setHeaderText(String string) {
            if (this.header instanceof JLabel) {
                ((JLabel)this.header).setText(string);
            }
        }

        void setControllingViewWidth(int n) {
            this.controllingView.setPreferredSize(new Dimension(n, 0));
        }

        int getControllingViewWidth() {
            return this.controllingView.getPreferredSize().width;
        }

        JComponent compoundScrollPane() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.header, "North");
            jPanel.add((Component)this.controllingView, "Center");
            this.compoundScrollPane = new CompoundScrollPane();
            this.compoundScrollPane.setLayout(new BorderLayout());
            this.compoundScrollPane.add((Component)jPanel, "Center");
            this.compoundScrollPane.add((Component)this, "East");
            return this.compoundScrollPane;
        }

        private class MouseDragHandler
        extends MouseInputAdapter {
            boolean dragging = false;
            int lastMouseX;

            private MouseDragHandler() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                this.dragging = this.canResize(point);
                this.lastMouseX = point.x;
            }

            private void setCursor(Cursor cursor) {
                if (ControlledTableView.this.header.getCursor() != cursor) {
                    ControlledTableView.this.header.setCursor(cursor);
                }
            }

            private boolean canResize(Point point) {
                return point.x >= ControlledTableView.this.header.getSize().width - 3;
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (this.canResize(mouseEvent.getPoint()) || this.dragging) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = this.lastMouseX - n;
                if (n2 == 0) {
                    return;
                }
                if (this.dragging) {
                    Dimension dimension = ControlledTableView.this.table.getPreferredScrollableViewportSize();
                    int n3 = ControlledTableView.this.compoundScrollPane.getWidth();
                    int n4 = ControlledTableView.this.table.getMinimumSize().width;
                    int n5 = dimension.width + n2 > n3 - 20 ? n3 - 20 : (dimension.width + n2 < n4 ? n4 : dimension.width + n2);
                    ControlledTableView.this.table.setPreferredScrollableViewportSize(new Dimension(n5, dimension.height));
                    this.lastMouseX -= n5 - dimension.width;
                    ControlledTableView.this.table.revalidate();
                    ControlledTableView.this.table.repaint();
                } else {
                    this.lastMouseX = n;
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.dragging = false;
            }
        }

        private class ATable
        extends JTable {
            private boolean trytorevalidate = true;

            public ATable() {
                this.getActionMap().put("cancel", new OurCancelEditingAction());
            }

            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                if (this.getAutoResizeMode() != 0 && this.getParent() != null) {
                    Insets insets = this.getParent().getInsets();
                    Dimension dimension2 = this.getParent().getSize();
                    dimension.height = dimension2.height - insets.top - insets.bottom;
                }
                return dimension;
            }

            public void setBounds(int n, int n2, int n3, int n4) {
                super.setBounds(n, n2, n3, n4);
                if (this.getAutoResizeMode() == 0) {
                    return;
                }
                if (this.trytorevalidate && n3 != this.getPreferredScrollableViewportSize().width) {
                    this.trytorevalidate = false;
                    ControlledTableView.this.compoundScrollPane.validate();
                    this.trytorevalidate = true;
                }
            }

            private class OurCancelEditingAction
            extends AbstractAction {
                private OurCancelEditingAction() {
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    jTable.removeEditor();
                }

                public boolean isEnabled() {
                    return ATable.this.isEditing();
                }
            }
        }
    }

    private static class WrapperPropertyModel
    implements ExPropertyModel {
        PropertyChangeSupport support = new PropertyChangeSupport(this);
        Node.Property prop;
        Node node;

        public WrapperPropertyModel(Node node, Node.Property property) {
            this.prop = property;
            this.node = node;
        }

        public Object getValue() throws InvocationTargetException {
            try {
                return this.prop.getValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                TableSheet.notify(1, illegalAccessException);
                throw new InvocationTargetException(illegalAccessException);
            }
        }

        public void setValue(Object object) throws InvocationTargetException {
            if (!this.prop.canWrite()) {
                return;
            }
            try {
                this.prop.setValue(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                TableSheet.notify(1, illegalAccessException);
                throw new InvocationTargetException(illegalAccessException);
            }
        }

        public Class getPropertyType() {
            return this.prop.getValueType();
        }

        public Class getPropertyEditorClass() {
            return this.prop.getPropertyEditor().getClass();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public void firePropertyChange() {
            this.support.firePropertyChange("value", null, null);
        }

        public Object[] getBeans() {
            return new Object[]{this.node};
        }

        public FeatureDescriptor getFeatureDescriptor() {
            return this.prop;
        }
    }

    private class PropertyPanelTableCell
    extends AbstractCellEditor
    implements TableModelListener,
    PropertyChangeListener,
    TableCellEditor,
    TableCellRenderer {
        private WrapperPropertyModel propModel;
        private Node node;
        private Node.Property prop;
        private TableCellRenderer headerRenderer;
        private NullPanel nullPanel;
        private Border nullPanelBorder;
        private Border nullPanelFocusBorder;
        private HashMap panelCache;

        private PropertyPanelTableCell() {
            this.headerRenderer = TableSheet.this.table.getTableHeader().getDefaultRenderer();
            this.nullPanelBorder = new CompoundBorder(new MatteBorder(0, 0, 1, 1, SystemColor.controlDkShadow), new MatteBorder(1, 1, 0, 0, SystemColor.controlLtHighlight));
            this.nullPanelFocusBorder = new CompoundBorder(new CompoundBorder(this.nullPanelBorder, new EmptyBorder(1, 1, 1, 1)), new MatteBorder(1, 1, 1, 1, UIManager.getColor("Button.focus")));
            this.panelCache = new HashMap();
        }

        public Object getCellEditorValue() {
            return null;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.prop = (Node.Property)object;
            this.node = TableSheet.this.tableModel.nodeForRow(n);
            this.propModel = new WrapperPropertyModel(this.node, this.prop);
            this.node.addPropertyChangeListener(this);
            TableSheet.this.tableModel.addTableModelListener(this);
            FocusHackedPropertyPanel focusHackedPropertyPanel = new FocusHackedPropertyPanel(this.propModel, this.prop.canWrite() ? 0 : 1);
            return focusHackedPropertyPanel;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (propModel != null) {
                        propModel.firePropertyChange();
                    }
                }
            });
        }

        public boolean stopCellEditing() {
            if (this.prop != null) {
                this.detachEditor();
            }
            return super.stopCellEditing();
        }

        public void cancelCellEditing() {
            if (this.prop != null) {
                this.detachEditor();
            }
            super.cancelCellEditing();
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = TableSheet.this.table.getEditingRow();
            int n2 = TableSheet.this.table.getEditingColumn();
            if (n < 0 || n2 < 0 || n >= TableSheet.this.tableModel.getRowCount() || n2 >= TableSheet.this.tableModel.getColumnCount() || this.prop != TableSheet.this.tableModel.getValueAt(n, n2)) {
                this.cancelCellEditing();
            }
        }

        private void detachEditor() {
            this.node.removePropertyChangeListener(this);
            TableSheet.this.tableModel.removeTableModelListener(this);
            this.node = null;
            this.prop = null;
            this.propModel = null;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n == -1) {
                Component component = this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JComponent) {
                    ((JComponent)component).setToolTipText(TableSheet.this.tableModel.propertyForColumn(n2).getShortDescription());
                }
                return component;
            }
            Node.Property property = (Node.Property)object;
            Node node = TableSheet.this.tableModel.nodeForRow(n);
            if (property != null) {
                Integer n3 = new Integer(node.hashCode() * property.hashCode());
                FocusedPropertyPanel focusedPropertyPanel = (FocusedPropertyPanel)this.panelCache.get(n3);
                if (focusedPropertyPanel == null) {
                    WrapperPropertyModel wrapperPropertyModel = new WrapperPropertyModel(node, property);
                    focusedPropertyPanel = new FocusedPropertyPanel(wrapperPropertyModel, 0);
                    this.panelCache.put(n3, focusedPropertyPanel);
                } else {
                    ((WrapperPropertyModel)focusedPropertyPanel.getModel()).firePropertyChange();
                }
                focusedPropertyPanel.setFocused(bl2);
                focusedPropertyPanel.setToolTipText(property.getShortDescription());
                return focusedPropertyPanel;
            }
            if (this.nullPanel == null) {
                this.nullPanel = new NullPanel(node);
                this.nullPanel.setOpaque(true);
            } else {
                this.nullPanel.setNode(node);
            }
            if (bl2) {
                this.nullPanel.setBorder(this.nullPanelFocusBorder);
            } else {
                this.nullPanel.setBorder(this.nullPanelBorder);
            }
            return this.nullPanel;
        }
    }
}

