/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.PasteType;

final class TreeViewDropSupport
implements DropTargetListener,
Runnable {
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    TreePath lastPath;
    protected TreeView view;
    protected JTree tree;

    public TreeViewDropSupport(TreeView treeView, JTree jTree, boolean bl) {
        this.view = treeView;
        this.tree = jTree;
        this.dropTargetPopupAllowed = bl;
    }

    public void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        TreePath treePath = this.getTreePath(dropTargetDragEvent);
        if (treePath == null) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            this.lastPath = treePath;
            NodeRenderer.dragEnter(treePath.getLastPathComponent());
            this.tree.paintImmediately(this.tree.getPathBounds(treePath));
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        TreePath treePath = this.getTreePath(dropTargetDragEvent);
        if (treePath == null) {
            dropTargetDragEvent.rejectDrag();
            if (this.lastPath != null) {
                NodeRenderer.dragExit();
                this.tree.repaint(this.tree.getPathBounds(this.lastPath));
                this.lastPath = null;
            }
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            if (this.lastPath != null && !this.lastPath.equals(treePath)) {
                NodeRenderer.dragExit();
                this.tree.repaint(this.tree.getPathBounds(this.lastPath));
            }
            if (!treePath.equals(this.lastPath)) {
                NodeRenderer.dragEnter(treePath.getLastPathComponent());
                this.tree.repaint(this.tree.getPathBounds(treePath));
                this.lastPath = treePath;
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.lastPath != null) {
            NodeRenderer.dragExit();
            this.tree.repaint(this.tree.getPathBounds(this.lastPath));
            this.lastPath = null;
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        Node node = null;
        int n = dropTargetDropEvent.getDropAction();
        if (treePath == null || (n & this.view.getAllowedDropActions()) == 0 || (node = DragDropUtilities.secureFindNode(treePath.getLastPathComponent())) == null) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        PasteType[] pasteTypeArray = DragDropUtilities.getPasteTypes(node, dropTargetDropEvent.getTransferable());
        if (pasteTypeArray == null || pasteTypeArray.length == 0) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        dropTargetDropEvent.acceptDrop(n);
        if (this.dropTargetPopupAllowed) {
            DragDropUtilities.createDropFinishPopup(pasteTypeArray).show(this.tree, Math.max(point.x - 5, 0), Math.max(point.y - 5, 0));
        } else {
            DragDropUtilities.performDrop(pasteTypeArray[0]);
        }
        TreeCellEditor treeCellEditor = this.tree.getCellEditor();
        if (treeCellEditor instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)treeCellEditor).setDnDActive(false);
        }
        dropTargetDropEvent.dropComplete(true);
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        this.getDropTarget().setActive(bl);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    TreePath getTreePath(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropAction();
        if ((n & this.view.getAllowedDropActions()) == 0) {
            return null;
        }
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        return treePath != null && DragDropUtilities.secureFindNode(treePath.getLastPathComponent()) != null ? treePath : null;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.tree, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }
}

