/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.rmi.MarshalledObject;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultAttributes
implements AbstractFileSystem.Attr,
AbstractFileSystem.List {
    static final long serialVersionUID = -5801291358293736478L;
    public static final String ATTR_NAME = "filesystem";
    public static final String ATTR_EXT = "attributes";
    public static final String ATTR_NAME_EXT = "filesystem.attributes";
    private static final String ATTR_NAME_EXT_XML = System.getProperty("org.openide.filesystems.DefaultAttributes.ATTR_NAME_EXT_XML", ".nbattrs");
    private AbstractFileSystem.Info info;
    private AbstractFileSystem.Change change;
    private AbstractFileSystem.List list;
    private transient Map cache;
    private static final String PUBLIC_ID = "-//NetBeans//DTD DefaultAttributes 1.0//EN";
    private static final String DTD_PATH = "org/openide/filesystems/attributes.dtd";
    static /* synthetic */ Class class$org$openide$filesystems$DefaultAttributes;

    public DefaultAttributes(AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
        this.info = info;
        this.change = change;
        this.list = list;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Object object = AbstractFileSystem.readImpl("change", getField);
        Object object2 = AbstractFileSystem.readImpl("info", getField);
        Object object3 = AbstractFileSystem.readImpl("list", getField);
        this.change = (AbstractFileSystem.Change)object;
        this.info = (AbstractFileSystem.Info)object2;
        this.list = (AbstractFileSystem.List)object3;
    }

    public String[] children(String string) {
        String[] stringArray = this.list.children(string);
        int n = 0;
        if (stringArray == null) {
            return null;
        }
        int n2 = stringArray.length;
        if (n2 == 1) {
            if (Utilities.getOperatingSystem() == 8192 && stringArray[0] != null && string != null && stringArray[0].equalsIgnoreCase("_nbattrs.")) {
                try {
                    this.change.delete(string + "/" + stringArray[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                stringArray[0] = new String(ATTR_NAME_EXT_XML);
            }
            if (ATTR_NAME_EXT_XML.equals(stringArray[0]) || ATTR_NAME_EXT.equals(stringArray[0])) {
                try {
                    this.change.delete(string + "/" + stringArray[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new String[0];
            }
        }
        int n3 = 0;
        while (n3 < n2) {
            if (Utilities.getOperatingSystem() == 8192 && stringArray[n3] != null && string != null && stringArray[n3].equalsIgnoreCase("_nbattrs.")) {
                try {
                    File file = new File(string + "/" + ".nbattrs");
                    if (!file.exists()) {
                        this.cache = null;
                        this.copyVMSAttrFile(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                stringArray[n3] = new String(ATTR_NAME_EXT_XML);
            }
            if (ATTR_NAME_EXT.equals(stringArray[n3]) || ATTR_NAME_EXT_XML.equals(stringArray[n3])) {
                stringArray[n3] = null;
                if (++n >= 2) break;
            }
            ++n3;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyVMSAttrFile(String string) throws IOException {
        OutputStream outputStream;
        block10: {
            InputStream inputStream = null;
            outputStream = null;
            try {
                try {
                    this.change.createData(string + "/" + ATTR_NAME_EXT_XML);
                    inputStream = this.info.inputStream(string + "/" + "_nbattrs.");
                    outputStream = this.info.outputStream(string + "/" + ATTR_NAME_EXT_XML);
                    byte[] byArray = new byte[256];
                    while (true) {
                        int n;
                        if ((n = inputStream.read(byArray, 0, 256)) < 0) {
                            inputStream.close();
                            inputStream = null;
                            break;
                        }
                        outputStream.write(byArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    Object var7_8 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream == null) return;
                    outputStream.close();
                    return;
                }
                Object var7_7 = null;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            inputStream.close();
        }
        if (outputStream == null) return;
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readAttribute(String string, String string2) {
        Table table;
        String[] stringArray = new String[2];
        DefaultAttributes.split(string, stringArray);
        DefaultAttributes defaultAttributes = this;
        synchronized (defaultAttributes) {
            table = this.loadTable(stringArray[0]);
        }
        return table.getAttr(stringArray[1], string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAttribute(String string, String string2, Object object) throws IOException {
        String[] stringArray = new String[2];
        DefaultAttributes.split(string, stringArray);
        while (true) {
            int n;
            Table table;
            DefaultAttributes defaultAttributes = this;
            synchronized (defaultAttributes) {
                table = this.loadTable(stringArray[0]);
                n = table.version;
            }
            Object object2 = table.getAttr(stringArray[1], string2);
            if (object2 == object || object != null && object.equals(object2)) {
                return;
            }
            DefaultAttributes defaultAttributes2 = this;
            synchronized (defaultAttributes2) {
                Table table2 = this.loadTable(stringArray[0]);
                if (table == table2 && n == table2.version) {
                    if (object == null) {
                        table.setAttr(stringArray[1], string2, null);
                    } else {
                        int n2 = XMLMapAttr.Attr.distinguishObject(object);
                        if (n2 == XMLMapAttr.Attr.isValid("SERIALVALUE")) {
                            table.setAttr(stringArray[1], string2, object);
                        } else {
                            table.setAttr(stringArray[1], string2, new XMLMapAttr.Attr(n2, object.toString()));
                        }
                    }
                    this.saveTable(stringArray[0], table);
                    return;
                }
            }
        }
    }

    public synchronized Enumeration attributes(String string) {
        String[] stringArray = new String[2];
        DefaultAttributes.split(string, stringArray);
        Table table = this.loadTable(stringArray[0]);
        return table.attrs(stringArray[1]);
    }

    public synchronized void renameAttributes(String string, String string2) {
        try {
            String[] stringArray = new String[2];
            DefaultAttributes.split(string, stringArray);
            Table table = this.loadTable(stringArray[0]);
            Map map = (Map)table.remove(stringArray[1]);
            if (map == null) {
                return;
            }
            DefaultAttributes.split(string2, stringArray);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!FileUtil.transientAttributes.contains(entry.getKey())) continue;
                iterator.remove();
            }
            table.put(stringArray[1], map);
            this.saveTable(stringArray[0], table);
        }
        catch (IOException iOException) {
            ExternalUtil.exception(iOException);
        }
    }

    public synchronized void deleteAttributes(String string) {
        try {
            String[] stringArray = new String[2];
            DefaultAttributes.split(string, stringArray);
            Table table = this.loadTable(stringArray[0]);
            if (table.remove(stringArray[1]) != null) {
                this.saveTable(stringArray[0], table);
            }
        }
        catch (IOException iOException) {
            ExternalUtil.exception(iOException);
        }
    }

    private Map getCache() {
        if (this.cache == null) {
            this.cache = new HashMap(31);
        }
        return this.cache;
    }

    private static void split(String string, String[] stringArray) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            stringArray[0] = "";
            stringArray[1] = string;
            return;
        }
        stringArray[0] = string.substring(0, n);
        stringArray[1] = ++n == string.length() ? "" : string.substring(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTable(String string, Table table) throws IOException {
        String string2 = (string.length() == 0 ? "" : string + '/') + ATTR_NAME_EXT_XML;
        if (this.info.folder(string2)) {
            if (table.size() == 0) {
                return;
            }
            this.change.createData(string2);
        } else if (table.size() == 0) {
            this.change.delete(string2);
            return;
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.info.outputStream(string2)), "UTF8"));
        try {
            table.writeToXML(printWriter);
            printWriter.flush();
            Object var6_5 = null;
            printWriter.close();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            printWriter.close();
            throw throwable;
        }
    }

    private Table loadTable(String string) {
        Table table;
        Reference reference = (Reference)this.getCache().get(string);
        if (reference != null && (table = (Table)reference.get()) != null) {
            return table;
        }
        table = this.load(string);
        table.attach(string, this);
        this.getCache().put(string, new SoftReference<Table>(table));
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table load(String string) {
        String[] stringArray = new String[]{(string.length() == 0 ? "" : string + '/') + ATTR_NAME_EXT_XML, (string.length() == 0 ? "" : string + '/') + ATTR_NAME_EXT};
        int n = 0;
        while (n < stringArray.length) {
            if (this.info.size(stringArray[n]) > 0L) {
                try {
                    Table table;
                    InputStream inputStream = this.info.inputStream(stringArray[n]);
                    try {
                        table = DefaultAttributes.loadTable(inputStream, stringArray[n]);
                        Object var7_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return table;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ExternalUtil.exception(fileNotFoundException);
                }
            }
            ++n;
        }
        return new Table();
    }

    static Table loadTable(InputStream inputStream, String string) {
        block4: {
            Table table = new Table();
            boolean bl = false;
            try {
                PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 4);
                bl = DefaultAttributes.isSerialized(pushbackInputStream);
                if (bl) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(pushbackInputStream);
                    NbObjectInputStream nbObjectInputStream = new NbObjectInputStream(bufferedInputStream);
                    Object object = nbObjectInputStream.readObject();
                    if (object instanceof Table) {
                        return (Table)object;
                    }
                    break block4;
                }
                table.readFromXML(pushbackInputStream, false);
                return table;
            }
            catch (Exception exception) {
                IOException iOException = new IOException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = DefaultAttributes.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "EXC_DefAttrReadErr") + ": " + string);
                ExternalUtil.copyAnnotation(iOException, exception);
                ExternalUtil.exception(iOException);
            }
        }
        return new Table();
    }

    private static final boolean isSerialized(PushbackInputStream pushbackInputStream) throws IOException {
        int[] nArray = new int[]{172, 237, 0, 5};
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        pushbackInputStream.read(byArray, 0, byArray.length);
        pushbackInputStream.unread(byArray);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = n = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
            if (nArray[n2] != n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    synchronized void removeTable(String string) {
        this.getCache().remove(string);
    }

    static boolean acceptName(String string) {
        return string.endsWith(ATTR_NAME_EXT) || string.endsWith(ATTR_NAME_EXT_XML);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class InnerParser
    extends HandlerBase {
        private ElementHandler[] elmKeyService;
        private String tagInProcess = "";
        private String publicId;
        private String publicURL;

        InnerParser(String string, String string2, ElementHandler[] elementHandlerArray) {
            this.elmKeyService = elementHandlerArray;
            this.publicId = string;
            this.publicURL = string2;
        }

        public void parseXML(String string, boolean bl) throws IOException, SAXException, ParserConfigurationException {
            Parser parser = this.getParser(bl);
            parser.parse(string);
        }

        public void parseXML(InputStream inputStream, boolean bl) throws IOException, SAXException, ParserConfigurationException {
            InputSource inputSource = new InputSource(inputStream);
            Parser parser = this.getParser(bl);
            parser.parse(inputSource);
        }

        private Parser getParser(boolean bl) throws IOException, SAXException, ParserConfigurationException {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.setNamespaceAware(false);
            Parser parser = sAXParserFactory.newSAXParser().getParser();
            if (parser == null) {
                throw new InternalError(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = DefaultAttributes.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "EXC_UnreachableCode"));
            }
            parser.setEntityResolver(this);
            parser.setDocumentHandler(this);
            parser.setErrorHandler(this);
            return parser;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            this.tagInProcess = string = string.trim();
            int n = 0;
            while (n < this.elmKeyService.length) {
                if (this.elmKeyService[n].isMyTag(string) != -1) {
                    this.elmKeyService[n].startElement(string, attributeList);
                    return;
                }
                ++n;
            }
            throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = DefaultAttributes.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "XML_UnknownElement") + " " + string);
        }

        public void endElement(String string) throws SAXException {
            int n = 0;
            while (n < this.elmKeyService.length) {
                if (this.elmKeyService[n].isMyTag(string.trim()) != -1) {
                    this.elmKeyService[n].endElement(string.trim());
                    return;
                }
                ++n;
            }
            throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = DefaultAttributes.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "XML_UnknownElement") + " " + string);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            int n3 = 0;
            while (n3 < this.elmKeyService.length) {
                if (this.elmKeyService[n3].isMyTag(this.tagInProcess) != -1) {
                    this.elmKeyService[n3].characters(cArray, n, n2);
                    return;
                }
                ++n3;
            }
            throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = DefaultAttributes.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "XML_UnknownElement") + " " + this.tagInProcess);
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (string != null && string.equals(this.publicId)) {
                return new InputSource(this.publicURL);
            }
            return new InputSource(string2);
        }
    }

    static abstract class ElementHandler {
        private int mandatAttrCount;

        ElementHandler() {
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            if (!this.checkAttributes(attributeList, hashMap, hashMap2)) {
                throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = DefaultAttributes.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "XML_InaccurateParam") + ": " + string);
            }
            this.internalStartElement(string, hashMap, hashMap2);
        }

        protected void internalStartElement(String string, HashMap hashMap, HashMap hashMap2) throws SAXException {
        }

        protected void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        protected void endElement(String string) throws SAXException {
        }

        protected String[] getKeys() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        protected String[] getMandatoryAttrs() {
            String[] stringArray = new String[]{};
            return this.getKeys();
        }

        protected String[] getAllowedAttrs() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        private int isMyTag(String string) {
            return this.isInArray(string, this.getKeys());
        }

        private int isAllowedAttr(String string) {
            return this.isInArray(string, this.getAllowedAttrs());
        }

        private boolean isMandatOK() {
            return this.mandatAttrCount == this.getMandatoryAttrs().length;
        }

        private int isMandatoryAttr(String string) {
            int n = this.isInArray(string, this.getMandatoryAttrs());
            if (n != -1) {
                ++this.mandatAttrCount;
            }
            return n;
        }

        private int isInArray(String string, String[] stringArray) {
            if (stringArray == null || string == null) {
                return -1;
            }
            String string2 = string.trim();
            int n = 0;
            while (n < stringArray.length) {
                if (string2.equalsIgnoreCase(stringArray[n])) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private boolean checkAttributes(AttributeList attributeList, HashMap hashMap, HashMap hashMap2) {
            this.mandatAttrCount = 0;
            if (attributeList == null) {
                return false;
            }
            int n = 0;
            while (n < attributeList.getLength()) {
                String string;
                if (this.isMandatoryAttr(attributeList.getName(n)) != -1) {
                    string = attributeList.getName(n).toUpperCase();
                    hashMap.put(string, attributeList.getValue(n));
                } else if (this.isAllowedAttr(attributeList.getName(n)) != -1) {
                    string = attributeList.getName(n).toUpperCase();
                    hashMap2.put(string, attributeList.getValue(n));
                }
                ++n;
            }
            return this.isMandatOK();
        }
    }

    static final class Table
    extends HashMap
    implements Externalizable {
        static final long serialVersionUID = 2353458763249746934L;
        private transient String name;
        private transient DefaultAttributes attrs;
        private transient int version = 0;

        public Table() {
            super(11);
        }

        public void attach(String string, DefaultAttributes defaultAttributes) {
            this.name = string;
            this.attrs = defaultAttributes;
        }

        protected void finalize() {
            this.attrs.removeTable(this.name);
        }

        public Object getAttr(String string, String string2) {
            XMLMapAttr xMLMapAttr = (XMLMapAttr)this.get(string);
            if (xMLMapAttr != null) {
                Object object = null;
                try {
                    object = xMLMapAttr.getAttribute(string2);
                }
                catch (Exception exception) {
                    ExternalUtil.annotate((Throwable)exception, "fileName = " + string);
                    ExternalUtil.exception(exception);
                }
                if (object == null) {
                    return null;
                }
                if (!(object instanceof NbMarshalledObject)) {
                    return object;
                }
                NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)object;
                try {
                    return nbMarshalledObject == null ? null : nbMarshalledObject.get();
                }
                catch (IOException iOException) {
                    ExternalUtil.log("Cannot load attribute " + string2 + " from " + string);
                    ExternalUtil.exception(iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExternalUtil.log("Cannot load attribute " + string2 + " from " + string);
                    ExternalUtil.exception(classNotFoundException);
                }
            }
            return null;
        }

        final void setMarshalledAttr(String string, String string2, NbMarshalledObject nbMarshalledObject) {
            this.setAttr(string, string2, nbMarshalledObject);
        }

        final void setAttr(String string, String string2, Object object) {
            Map map = (Map)this.get(string);
            if (map == null) {
                map = new XMLMapAttr();
                this.put(string, map);
            }
            map.put(string2, object);
            ++this.version;
        }

        public Enumeration attrs(String string) {
            Map map = (Map)this.get(string);
            if (map == null) {
                return EmptyEnumeration.EMPTY;
            }
            HashSet hashSet = new HashSet(map.keySet());
            return Collections.enumeration(hashSet);
        }

        private ElementHandler parseFirstLevel() {
            ElementHandler elementHandler = new ElementHandler(this){
                private final String[] ELM_KEYS;
                private final String[] MANDAT_ATTR_KEYS;
                private final /* synthetic */ Table this$0;
                {
                    this.this$0 = table;
                    this.ELM_KEYS = new String[]{"ATTRIBUTES"};
                    this.MANDAT_ATTR_KEYS = new String[]{"VERSION"};
                }

                public void internalStartElement(String string, HashMap hashMap, HashMap hashMap2) throws SAXException {
                }

                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }
            };
            return elementHandler;
        }

        private ElementHandler parseSecondLevel(StringBuffer stringBuffer) {
            ElementHandler elementHandler = new ElementHandler(this, stringBuffer){
                private final String[] ELM_KEYS;
                private final String[] MANDAT_ATTR_KEYS;
                private final /* synthetic */ StringBuffer val$fileName;
                private final /* synthetic */ Table this$0;
                {
                    this.this$0 = table;
                    this.val$fileName = stringBuffer;
                    this.ELM_KEYS = new String[]{"FILEOBJECT"};
                    this.MANDAT_ATTR_KEYS = new String[]{"NAME"};
                }

                public void internalStartElement(String string, HashMap hashMap, HashMap hashMap2) throws SAXException {
                    this.val$fileName.delete(0, this.val$fileName.length());
                    String string2 = (String)hashMap.get("NAME");
                    if (string2 == null) {
                        string2 = (String)hashMap.get("name");
                    }
                    if (string2 != null) {
                        this.val$fileName.append(string2);
                    }
                }

                public void endElement(String string) throws SAXException {
                }

                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }
            };
            return elementHandler;
        }

        private ElementHandler parseThirdLevel(StringBuffer stringBuffer) {
            ElementHandler elementHandler = new ElementHandler(this, stringBuffer){
                private final String[] ELM_KEYS;
                private final String[] MANDAT_ATTR_KEYS;
                private final /* synthetic */ StringBuffer val$fileName;
                private final /* synthetic */ Table this$0;
                {
                    this.this$0 = table;
                    this.val$fileName = stringBuffer;
                    this.ELM_KEYS = new String[]{"ATTR"};
                    this.MANDAT_ATTR_KEYS = new String[]{"NAME"};
                }

                public void internalStartElement(String string, HashMap hashMap, HashMap hashMap2) throws SAXException {
                    if (hashMap2.isEmpty()) {
                        return;
                    }
                    String string2 = (String)hashMap.get("NAME");
                    if (string2 == null) {
                        string2 = (String)hashMap.get("name");
                    }
                    if (string2 == null) {
                        return;
                    }
                    Iterator<Map.Entry<K, V>> iterator = hashMap2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> entry = iterator.next();
                        if (XMLMapAttr.Attr.isValid((String)entry.getKey()) == -1) continue;
                        XMLMapAttr.Attr attr = new XMLMapAttr.Attr((String)entry.getKey(), (String)entry.getValue());
                        this.this$0.setAttr(this.val$fileName.toString(), string2, attr);
                    }
                }

                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }

                protected String[] getAllowedAttrs() {
                    return XMLMapAttr.Attr.getAttrTypes();
                }
            };
            return elementHandler;
        }

        public void writeToXML(PrintWriter printWriter) {
            Iterator iterator = this.keySet().iterator();
            XMLMapAttr.writeHeading(printWriter);
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                XMLMapAttr xMLMapAttr = (XMLMapAttr)this.get(string);
                if (xMLMapAttr == null || xMLMapAttr.isEmpty()) continue;
                xMLMapAttr.write(printWriter, string, "    ");
            }
            XMLMapAttr.writeEnding(printWriter);
        }

        public void readFromXML(InputStream inputStream, boolean bl) throws SAXException {
            StringBuffer stringBuffer = new StringBuffer();
            ElementHandler[] elementHandlerArray = new ElementHandler[]{this.parseFirstLevel(), this.parseSecondLevel(stringBuffer), this.parseThirdLevel(stringBuffer)};
            String string = this.getClass().getClassLoader().getResource(DefaultAttributes.DTD_PATH).toString();
            InnerParser innerParser = new InnerParser(DefaultAttributes.PUBLIC_ID, string, elementHandlerArray);
            try {
                innerParser.parseXML(inputStream, bl);
            }
            catch (Exception exception) {
                throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(NbBundle.getMessage(class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = DefaultAttributes.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes, "EXC_DefAttrReadErr")), exception);
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map = (Map)this.get(string);
                if (map == null || map.isEmpty()) continue;
                objectOutput.writeObject(string);
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    String string2 = (String)entry.getKey();
                    Object v = entry.getValue();
                    if (string2 == null || v == null) continue;
                    objectOutput.writeObject(string2);
                    objectOutput.writeObject(v);
                }
                objectOutput.writeObject(null);
            }
            objectOutput.writeObject(null);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            String string;
            while ((string = (String)objectInput.readObject()) != null) {
                String string2;
                while ((string2 = (String)objectInput.readObject()) != null) {
                    Object object = objectInput.readObject();
                    if (object instanceof MarshalledObject) {
                        object = ((MarshalledObject)object).get();
                        object = new NbMarshalledObject(object);
                    }
                    if (!(object instanceof NbMarshalledObject)) continue;
                    this.setAttr(string, string2, object);
                }
            }
        }
    }
}

