/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.Externalizable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.WeakListener;

final class MultiFileObject
extends AbstractFolder
implements FileChangeListener {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    private Set delegates;
    private FileObject leader;
    private Reference lock;
    private FileChangeListener weakL = new MfoWeakListener(this);
    private FileObject lastAttrCacheFile;
    private String lastAttrCacheName = "";
    private static final FileSystem.AtomicAction markAtomicAction = new FileSystem.AtomicAction(){

        public void run() {
        }
    };

    public MultiFileObject(MultiFileSystem multiFileSystem, MultiFileObject multiFileObject, String string) {
        super(multiFileSystem, multiFileObject, string);
        this.update();
        if (this.leader == null) {
            this.leader = new AbstractFileObject.Invalid(string);
        }
    }

    public MultiFileObject(MultiFileSystem multiFileSystem) {
        this(multiFileSystem, null, "");
    }

    public FileSystem getLeaderFileSystem() throws FileStateInvalidException {
        return this.leader.getFileSystem();
    }

    private void freeLastAttrCache() {
        this.lastAttrCacheFile = null;
        this.lastAttrCacheName = "";
    }

    private void update() {
        Object object;
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        FileSystem[] fileSystemArray = multiFileSystem.getDelegates();
        Set set = this.delegates == null ? Collections.EMPTY_SET : this.delegates;
        HashSet<Object> hashSet = new HashSet<Object>(fileSystemArray.length * 2);
        Object object2 = null;
        String string = this.toString();
        int n = 0;
        while (n < fileSystemArray.length) {
            if (fileSystemArray[n] != null && (object = multiFileSystem.findResourceOn(fileSystemArray[n], string)) != null) {
                hashSet.add(object);
                if (!set.remove(object)) {
                    ((FileObject)object).addFileChangeListener(this.weakL);
                }
                if (object2 == null && ((FileObject)object).isValid()) {
                    object2 = object;
                }
            }
            ++n;
        }
        object = set.iterator();
        while (object.hasNext()) {
            FileObject fileObject = (FileObject)object.next();
            fileObject.removeFileChangeListener(this.weakL);
        }
        if (object2 != null) {
            if (object2 != this.leader && this.leader != null) {
                if (this.isData() && this.isValid()) {
                    this.fileChanged0(new FileEvent(this));
                }
                this.getMultiFileSystem().notifyMigration(this);
            }
            this.leader = object2;
        }
        this.delegates = hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAll() {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        try {
            multiFileSystem.beginAtomicAction();
            Enumeration enumeration = this.existingSubFiles(true);
            while (enumeration.hasMoreElements()) {
                MultiFileObject multiFileObject = (MultiFileObject)enumeration.nextElement();
                if (multiFileObject.isFolder() && !multiFileObject.isInitialized()) continue;
                multiFileObject.freeLastAttrCache();
                multiFileObject.refresh(true);
            }
            Object var5_4 = null;
            multiFileSystem.finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            multiFileSystem.finishAtomicAction();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAllAfterSetDelegates(FileSystem[] fileSystemArray) {
        try {
            this.getMultiFileSystem().beginAtomicAction();
            FileSystem[] fileSystemArray2 = this.getMultiFileSystem().getDelegates();
            Enumeration enumeration = this.existingSubFiles(true);
            while (enumeration.hasMoreElements()) {
                MultiFileObject multiFileObject = (MultiFileObject)enumeration.nextElement();
                if (multiFileObject.isFolder() && !multiFileObject.isInitialized()) continue;
                if (multiFileObject.hasListeners()) {
                    String string = multiFileObject.toString();
                    FileObject fileObject = this.findLeader(fileSystemArray, string);
                    FileObject fileObject2 = this.findLeader(fileSystemArray2, string);
                    if (fileObject != null && fileObject2 != null && fileObject != fileObject2) {
                        multiFileObject.fileAttributeChanged0(new FileAttributeEvent(multiFileObject, null, null, null));
                    }
                }
                multiFileObject.freeLastAttrCache();
                multiFileObject.refresh(true);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.getMultiFileSystem().finishAtomicAction();
            throw throwable;
        }
        this.getMultiFileSystem().finishAtomicAction();
    }

    private FileObject findLeader(FileSystem[] fileSystemArray, String string) {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        int n = 0;
        while (n < fileSystemArray.length) {
            FileObject fileObject = multiFileSystem.findResourceOn(fileSystemArray[n], string);
            if (fileObject != null) {
                return fileObject;
            }
            ++n;
        }
        return null;
    }

    private MultiFileSystem getMultiFileSystem() {
        return (MultiFileSystem)this.getFileSystem();
    }

    private MultiFileObject getMultiChild(String string) {
        return (MultiFileObject)this.getChild(string);
    }

    private FileObject writable() throws IOException {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        FileSystem fileSystem = multiFileSystem.createWritableOn(this.toString());
        if (fileSystem != this.leader.getFileSystem()) {
            Object object;
            if (this.leader.isFolder()) {
                this.leader = FileUtil.createFolder(this.root(fileSystem), this.toString());
            } else {
                object = FileUtil.createFolder(this.root(fileSystem), this.getParent().toString());
                this.leader = this.leader.copy((FileObject)object, this.leader.getName(), this.leader.getExt());
            }
            object = this.lock == null ? null : this.lock.get();
            if (object != null) {
                ((MfLock)object).addLock(this.leader);
            }
        }
        return this.leader;
    }

    private Enumeration delegates() {
        return this.getMultiFileSystem().delegates(this.toString());
    }

    private static void updateFoldersLock(FileObject fileObject) throws IOException {
        while (fileObject != null) {
            MultiFileObject multiFileObject = (MultiFileObject)fileObject;
            MfLock mfLock = multiFileObject.lock == null ? null : multiFileObject.lock.get();
            if (mfLock != null) {
                multiFileObject.writable();
            }
            fileObject = fileObject.getParent();
        }
    }

    protected final String[] list() {
        String[] stringArray;
        Properties properties = new Properties();
        LinkedList<String> linkedList = new LinkedList<String>();
        HashSet<String> hashSet = new HashSet<String>(101);
        Enumeration enumeration = this.delegates();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (stringArray == null || !stringArray.isFolder()) continue;
            FileObject[] fileObjectArray = stringArray.getChildren();
            Properties properties2 = null;
            int n = 0;
            while (n < fileObjectArray.length) {
                block9: {
                    String string;
                    block8: {
                        string = fileObjectArray[n].getNameExt();
                        if (!string.endsWith("_hidden")) break block8;
                        String string2 = string.substring(0, string.length() - "_hidden".length());
                        if (properties2 == null) {
                            properties2 = new Properties(properties);
                        }
                        properties2.setProperty(string2, string2);
                        if (!this.getMultiFileSystem().getPropagateMasks()) break block9;
                    }
                    if (!hashSet.contains(string) && properties.getProperty(string) == null) {
                        hashSet.add(string);
                        linkedList.add(string);
                    }
                }
                ++n;
            }
            if (properties2 == null) continue;
            properties = properties2;
        }
        if (this.getMultiFileSystem().getPropagateMasks()) {
            linkedList.removeAll(properties.keySet());
        }
        stringArray = linkedList.toArray(new String[linkedList.size()]);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(String string, String string2, boolean bl, boolean bl2) {
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                this.update();
                super.refresh(string, string2, bl, bl2);
            }
            this.validFlag &= this.leader.isValid();
            Object var8_7 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    protected final AbstractFolder createFile(String string) {
        return new MultiFileObject(this.getMultiFileSystem(), this, string);
    }

    public boolean isFolder() {
        return this.parent == null || this.leader.isFolder();
    }

    public Date lastModified() {
        return this.leader.lastModified();
    }

    public boolean isData() {
        return this.leader.isData();
    }

    public boolean isReadOnly() {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        if (multiFileSystem.isReadOnly()) {
            return true;
        }
        if (this.leader.isReadOnly()) {
            try {
                FileSystem fileSystem = multiFileSystem.createWritableOn(this.toString());
                return fileSystem == this.leader.getFileSystem();
            }
            catch (IOException iOException) {
                return true;
            }
        }
        return false;
    }

    public String getMIMEType() {
        return this.leader.getMIMEType();
    }

    public long getSize() {
        return this.leader.getSize();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return this.leader.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        try {
            FileLock fileLock2;
            FileObject fileObject;
            this.getFileSystem().beginAtomicAction(markAtomicAction);
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                MfLock mfLock = this.testLock(fileLock);
                fileObject = this.writable();
                fileLock2 = mfLock.findLock(fileObject);
            }
            OutputStream outputStream = fileObject.getOutputStream(fileLock2);
            Object var8_8 = null;
            this.getFileSystem().finishAtomicAction();
            return outputStream;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public synchronized FileLock lock() throws IOException {
        Object object;
        if (this.lock != null && (object = (FileLock)this.lock.get()) != null) {
            throw new FileAlreadyLockedException(this.toString());
        }
        object = this.getMultiFileSystem().createLocksOn(this.toString());
        MfLock mfLock = new MfLock(this.leader, this.delegates(), (Set)object);
        this.lock = new WeakReference<MfLock>(mfLock);
        return mfLock;
    }

    private MfLock testLock(FileLock fileLock) throws IOException {
        if (this.lock == null) {
            FSException.io("EXC_InvalidLock", fileLock, this.toString(), this.getMultiFileSystem().getDisplayName(), this.lock);
        }
        if (this.lock.get() != fileLock) {
            FSException.io("EXC_InvalidLock", fileLock, this.toString(), this.getMultiFileSystem().getDisplayName(), this.lock.get());
        }
        return (MfLock)fileLock;
    }

    public void setImportant(boolean bl) {
        Enumeration enumeration = this.delegates();
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            fileObject.setImportant(bl);
        }
        if (!bl) {
            this.getMultiFileSystem().markUnimportant(this);
        }
    }

    private static final Object voidify(Object object) {
        if (object == null) {
            return new VoidValue(0);
        }
        if (object instanceof VoidValue) {
            VoidValue voidValue = (VoidValue)object;
            return new VoidValue(voidValue.level + 1);
        }
        return object;
    }

    private static final Object devoidify(Object object) {
        if (object instanceof VoidValue) {
            VoidValue voidValue = (VoidValue)object;
            if (voidValue.level == 0) {
                return null;
            }
            return new VoidValue(voidValue.level - 1);
        }
        return object;
    }

    public Object getAttribute(String string) {
        return this.getAttribute(string, this.toString());
    }

    private final Object getAttribute(String string, String string2) {
        Object object;
        Serializable serializable;
        String string3 = string2.length() == 0 ? null : string2.replace('/', '\\') + '\\' + string;
        Serializable serializable2 = this.lastAttrCacheFile;
        String string4 = this.lastAttrCacheName;
        if (serializable2 != null && serializable2 != this && string4.equals(string)) {
            if (((FileObject)serializable2).isRoot() && string3 != null) {
                try {
                    serializable = ((FileObject)serializable2).getFileSystem();
                    if (!(serializable instanceof XMLFileSystem) && (object = this.getAttribute((FileObject)(serializable2 = ((FileSystem)serializable).getRoot()), string3, "")) != null) {
                        return MultiFileObject.devoidify(object);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if ((object = this.getAttribute((FileObject)serializable2, string, ((FileObject)serializable2).toString())) != null) {
                return MultiFileObject.devoidify(object);
            }
        }
        object = this.getMultiFileSystem().getDelegates();
        try {
            serializable2 = this.getLeaderFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            serializable2 = null;
        }
        int n = 0;
        while (n < ((FileSystem[])object).length) {
            if (object[n] != null) {
                Object object2;
                serializable = this.getMultiFileSystem().findResourceOn(object[n], string2);
                if (serializable != null && (object2 = this.getAttribute((FileObject)serializable, string, ((FileObject)serializable).toString())) != null) {
                    return MultiFileObject.devoidify(object2);
                }
                if (string3 != null && !(object[n] instanceof XMLFileSystem) && (object2 = this.getAttribute((FileObject)(serializable = object[n].getRoot()), string3, "")) != null) {
                    return MultiFileObject.devoidify(object2);
                }
            }
            ++n;
        }
        return null;
    }

    private Object getAttribute(FileObject fileObject, String string, String string2) {
        Object object = fileObject instanceof MultiFileObject ? ((MultiFileObject)fileObject).getAttribute(string, string2) : (fileObject instanceof AbstractFileObject ? ((AbstractFileObject)fileObject).getAttribute(string, string2) : fileObject.getAttribute(string));
        if (object != null) {
            this.lastAttrCacheFile = fileObject;
            this.lastAttrCacheName = string;
        }
        return object;
    }

    public void setAttribute(String string, Object object) throws IOException {
        this.setAttribute(string, object, true);
    }

    void setAttribute(String string, Object object, boolean bl) throws IOException {
        String string2 = this.toString();
        FileSystem fileSystem = this.getMultiFileSystem().createWritableOn(string2);
        FileObject fileObject = this.getMultiFileSystem().findResourceOn(fileSystem, string2);
        Object object2 = null;
        String string3 = string;
        if (bl) {
            object2 = this.getAttribute(string);
        }
        if (fileObject == null) {
            fileObject = fileSystem.getRoot();
            string3 = string2.replace('/', '\\') + '\\' + string;
        }
        this.lastAttrCacheFile = fileObject;
        this.lastAttrCacheName = string3;
        if (fileObject instanceof AbstractFolder) {
            ((AbstractFolder)fileObject).setAttribute(string3, MultiFileObject.voidify(object), false);
        } else {
            bl = bl && fileObject.isRoot();
            fileObject.setAttribute(string3, MultiFileObject.voidify(object));
        }
        if (bl && object2 != object && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent(this, string, object2, object));
        }
    }

    public Enumeration getAttributes() {
        return this.getAttributes(this.toString());
    }

    private final Enumeration getAttributes(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        FileSystem[] fileSystemArray = this.getMultiFileSystem().getDelegates();
        String string2 = string.length() == 0 ? null : string.replace('/', '\\') + '\\';
        int n = 0;
        while (n < fileSystemArray.length) {
            if (fileSystemArray[n] != null) {
                String string3;
                Enumeration enumeration;
                FileObject fileObject = this.getMultiFileSystem().findResourceOn(fileSystemArray[n], string);
                if (fileObject != null) {
                    enumeration = fileObject instanceof MultiFileObject ? ((MultiFileObject)fileObject).getAttributes(string) : (fileObject instanceof AbstractFileObject ? ((AbstractFileObject)fileObject).getAttributes(string) : fileObject.getAttributes());
                    while (enumeration.hasMoreElements()) {
                        string3 = (String)enumeration.nextElement();
                        hashSet.add(string3);
                    }
                }
                if (string2 != null) {
                    fileObject = fileSystemArray[n].getRoot();
                    enumeration = fileObject instanceof MultiFileObject ? ((MultiFileObject)fileObject).getAttributes("") : (fileObject instanceof AbstractFileObject ? ((AbstractFileObject)fileObject).getAttributes("") : fileObject.getAttributes());
                    while (enumeration.hasMoreElements()) {
                        string3 = (String)enumeration.nextElement();
                        if (!string3.startsWith(string2)) continue;
                        hashSet.add(string3.substring(string2.length()));
                    }
                }
            }
            ++n;
        }
        return Collections.enumeration(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createFolder(String string) throws IOException {
        MultiFileObject multiFileObject;
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject2 = this;
            synchronized (multiFileObject2) {
                MultiFileSystem multiFileSystem = this.getMultiFileSystem();
                if (multiFileSystem.isReadOnly()) {
                    FSException.io("EXC_FSisRO", multiFileSystem.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", string, multiFileSystem.getDisplayName());
                }
                String string2 = this.toString() + '/' + string;
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", string, this.toString(), multiFileSystem.getDisplayName());
                }
                if (this.getFileObject(string) != null) {
                    FSException.io("EXC_FolderAlreadyExist", string, multiFileSystem.getDisplayName());
                }
                FileSystem fileSystem = multiFileSystem.createWritableOn(string2);
                FileUtil.createFolder(this.root(fileSystem), string2);
                this.getMultiFileSystem().unmaskFile(fileSystem, string2);
                this.refresh(string, null, true, false);
                multiFileObject = this.getMultiChild(string);
                if (multiFileObject == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.toString(), string));
                }
                FileObject[] fileObjectArray = multiFileObject.getChildren();
                int n = 0;
                while (n < fileObjectArray.length) {
                    this.getMultiFileSystem().maskFile(fileSystem, fileObjectArray[n].toString());
                    ++n;
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(multiFileObject), false);
                }
            }
            Object var11_10 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
        return multiFileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createData(String string, String string2) throws IOException {
        MultiFileObject multiFileObject;
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject2 = this;
            synchronized (multiFileObject2) {
                String string3;
                MultiFileSystem multiFileSystem = this.getMultiFileSystem();
                if (multiFileSystem.isReadOnly()) {
                    FSException.io("EXC_FSisRO", multiFileSystem.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", string, multiFileSystem.getDisplayName());
                }
                String string4 = string3 = "".equals(string2) ? string : string + '.' + string2;
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", string3, this.toString(), multiFileSystem.getDisplayName());
                }
                if (this.getFileObject(string, string2) != null) {
                    FSException.io("EXC_DataAlreadyExist", string3, multiFileSystem.getDisplayName());
                }
                String string5 = this.toString() + '/' + string3;
                FileSystem fileSystem = multiFileSystem.createWritableOn(string5);
                FileUtil.createData(this.root(fileSystem), string5);
                this.getMultiFileSystem().unmaskFile(fileSystem, string5);
                this.refresh(string3, null, true, false);
                multiFileObject = this.getMultiChild(string3);
                if (multiFileObject == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.toString(), string3));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(multiFileObject), true);
                }
            }
            Object var11_10 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
        return multiFileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(FileLock fileLock, String string, String string2) throws IOException {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        if (this.parent == null) {
            FSException.io("EXC_CannotRenameRoot", multiFileSystem.getDisplayName());
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                Object object;
                MfLock mfLock = this.testLock(fileLock);
                String string3 = this.parent.toString() + '/' + string;
                if (this.isData()) {
                    string3 = string3 + '.' + string2;
                }
                String string4 = this.toString();
                if (this.isReadOnly()) {
                    FSException.io("EXC_CannotRename", this.toString(), this.getMultiFileSystem().getDisplayName(), string3);
                }
                if (this.getFileSystem().isReadOnly()) {
                    FSException.io("EXC_FSisRO", this.getMultiFileSystem().getDisplayName());
                }
                String string5 = this.getName();
                String string6 = this.getExt();
                FileSystem fileSystem = multiFileSystem.createWritableOnForRename(string4, string3);
                if (fileSystem == this.leader.getFileSystem()) {
                    this.leader.rename(mfLock.findLock(this.leader), string, string2);
                    this.getMultiFileSystem().unmaskFile(fileSystem, string3);
                    MultiFileObject.copyContent(this, this.leader);
                } else {
                    object = this.leader;
                    if (this.isData()) {
                        FileObject fileObject = FileUtil.createFolder(this.root(fileSystem), this.getParent().toString());
                        this.leader = this.leader.copy(fileObject, string, string2);
                        MultiFileObject.copyAttrs(this, this.leader);
                    } else {
                        FileObject fileObject = FileUtil.createFolder(this.root(fileSystem), string3);
                        MultiFileObject.copyContent(this, fileObject);
                        this.leader = fileObject;
                        this.name = string;
                        this.update();
                    }
                    mfLock.changeLocks((FileObject)object, this.leader);
                }
                if (this.getMultiFileSystem().delegates(string4).hasMoreElements()) {
                    this.getMultiFileSystem().maskFile(fileSystem, string4);
                    MultiFileObject.updateFoldersLock(this.getParent());
                }
                if (this.isData()) {
                    string = string + '.' + string2;
                }
                object = this.name;
                this.name = string;
                this.parent.refresh(string, (String)object);
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, string5, string6));
                }
            }
            Object var16_16 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FileLock fileLock) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", this.getMultiFileSystem().getDisplayName());
        }
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                Object object;
                MfLock mfLock = this.testLock(fileLock);
                String string = this.toString();
                FileSystem fileSystem = multiFileSystem.createWritableOn(string);
                Enumeration enumeration = multiFileSystem.delegates(string);
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    object = (FileObject)enumeration.nextElement();
                    FileLock fileLock2 = mfLock.findLock((FileObject)object);
                    if (fileLock2 != null) {
                        ((FileObject)object).delete(fileLock2);
                        continue;
                    }
                    bl = true;
                }
                if (bl) {
                    this.getMultiFileSystem().maskFile(fileSystem, string);
                    MultiFileObject.updateFoldersLock(this.getParent());
                }
                object = this.name;
                this.validFlag = false;
                this.parent.refresh(null, (String)object, true, false);
                if (this.hasAtLeastOneListeners()) {
                    this.fileDeleted0(new FileEvent(this));
                }
            }
            Object var13_12 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        return this.leader.copy(fileObject, string, string2);
    }

    public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        MultiFileSystem multiFileSystem = this.getMultiFileSystem();
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", multiFileSystem.getDisplayName());
        }
        MfLock mfLock = this.testLock(fileLock);
        FileLock fileLock2 = mfLock.findLock(this.leader);
        FileSystem fileSystem = multiFileSystem.createWritableOn(this.toString());
        if (multiFileSystem.isReadOnly()) {
            FSException.io("EXC_FSisRO", multiFileSystem.getDisplayName());
        }
        if (fileLock2 == null && this.leader.getFileSystem() != fileSystem) {
            this.leader = this.writable();
            fileLock2 = mfLock.findLock(this.leader);
        }
        this.getMultiFileSystem().maskFile(fileSystem, this.toString());
        MultiFileObject.updateFoldersLock(this.getParent());
        return this.leader.move(fileLock2, fileObject, string, string2);
    }

    public final void refresh(boolean bl) {
        Enumeration enumeration = this.delegates();
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            fileObject.refresh(bl);
        }
        super.refresh(bl);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        if (!MultiFileSystem.isMaskFile(fileEvent.getFile())) {
            this.updateAll();
        } else {
            this.update();
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        if (!MultiFileSystem.isMaskFile(fileEvent.getFile())) {
            this.updateAll();
        } else {
            this.update();
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject = this;
        if (fileEvent.getSource() == this.leader && this.hasAtLeastOneListeners() && !fileEvent.firedFrom(markAtomicAction)) {
            if (!fileEvent.getFile().equals(fileEvent.getSource())) {
                fileObject = this.getFileObject(fileEvent.getFile().getName(), fileEvent.getFile().getExt());
            }
            if (fileObject != null) {
                this.fileChanged1(new FileEvent((FileObject)this, fileObject, fileEvent.getTime()));
            }
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        if (!MultiFileSystem.isMaskFile(fileEvent.getFile())) {
            this.updateAll();
        } else {
            this.refresh();
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.refresh();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        if (!this.hasAtLeastOneListeners() || this.leader == null) {
            return;
        }
        if (fileAttributeEvent.getFile() != this.leader && fileAttributeEvent.getName() != null && this.leader.getAttribute(fileAttributeEvent.getName()) != null) {
            return;
        }
        if (fileAttributeEvent.getFile() != this.leader && fileAttributeEvent.getNewValue() != null && fileAttributeEvent.getName() != null && !fileAttributeEvent.getNewValue().equals(this.getAttribute(fileAttributeEvent.getName()))) {
            return;
        }
        this.fileAttributeChanged0(new FileAttributeEvent(this, fileAttributeEvent.getName(), fileAttributeEvent.getOldValue(), fileAttributeEvent.getNewValue()));
    }

    private static void copyContent(FileObject fileObject, FileObject fileObject2) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        MultiFileObject.copyAttrs(fileObject, fileObject2);
        int n = 0;
        while (n < fileObjectArray.length) {
            FileObject fileObject3 = fileObjectArray[n];
            if (!MultiFileSystem.isMaskFile(fileObject3) && fileObject2.getFileObject(fileObject3.getName(), fileObject3.getExt()) == null) {
                FileObject fileObject4;
                if (fileObject3.isData()) {
                    fileObject4 = FileUtil.copyFile(fileObject3, fileObject2, fileObject3.getName(), fileObject3.getExt());
                    if (fileObject4 != null) {
                        MultiFileObject.copyAttrs(fileObject3, fileObject4);
                    }
                } else {
                    fileObject4 = fileObject2.createFolder(fileObject3.getName());
                    MultiFileObject.copyContent(fileObject3, fileObject4);
                }
            }
            ++n;
        }
    }

    private static void copyAttrs(FileObject fileObject, FileObject fileObject2) {
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = fileObject.getAttribute(string);
            try {
                fileObject2.setAttribute(string, object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private FileObject root(FileSystem fileSystem) {
        return this.getMultiFileSystem().findResourceOn(fileSystem, "");
    }

    static class MfoWeakListener
    extends WeakListener.FileChange {
        public MfoWeakListener(FileChangeListener fileChangeListener) {
            super(fileChangeListener);
        }
    }

    private class MfLock
    extends FileLock {
        private Map map = new HashMap(11);

        public MfLock(FileObject fileObject, Enumeration enumeration, Set set) throws IOException {
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (!set.contains(fileObject2.getFileSystem())) continue;
                FileLock fileLock = fileObject2.lock();
                this.map.put(fileObject2, fileLock);
            }
        }

        public FileLock findLock(FileObject fileObject) {
            return (FileLock)this.map.get(fileObject);
        }

        public void addLock(FileObject fileObject) throws IOException {
            this.map.put(fileObject, fileObject.lock());
        }

        public void changeLocks(FileObject fileObject, FileObject fileObject2) throws IOException {
            FileLock fileLock = (FileLock)this.map.remove(fileObject);
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            this.addLock(fileObject2);
        }

        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                Iterator iterator = this.map.values().iterator();
                while (iterator.hasNext()) {
                    FileLock fileLock = (FileLock)iterator.next();
                    fileLock.releaseLock();
                }
                this.map.clear();
                MultiFileObject.this.lock = null;
            }
        }
    }

    private static final class VoidValue
    implements Externalizable {
        int level;
        private static final long serialVersionUID = -2743645909916238684L;

        VoidValue(int n) {
            this.level = n;
        }

        public String toString() {
            return "org.openide.filesystems.MultiFileObject.VoidValue#" + this.level;
        }

        public VoidValue() {
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.level);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.level = objectInput.readInt();
        }
    }
}

