/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.util.RequestProcessor;

final class RefreshRequest
implements Runnable {
    private static final int REFRESH_COUNT = 30;
    private Reference system;
    private Enumeration en;
    private int refreshTime;
    private RequestProcessor.Task task;

    public RefreshRequest(AbstractFileSystem abstractFileSystem, int n) {
        this.system = new WeakReference<AbstractFileSystem>(abstractFileSystem);
        this.refreshTime = n;
        this.task = RequestProcessor.postRequest(this, n, 1);
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public synchronized void stop() {
        this.refreshTime = 0;
        if (this.task == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RefreshRequest refreshRequest;
        RequestProcessor.Task task;
        int n;
        RefreshRequest refreshRequest2 = this;
        synchronized (refreshRequest2) {
            n = this.refreshTime;
            if (n <= 0) {
                return;
            }
            task = this.task;
        }
        try {
            this.task = null;
            this.doLoop(n);
            Object var6_5 = null;
            refreshRequest = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            RefreshRequest refreshRequest3 = this;
            synchronized (refreshRequest3) {
                this.task = task;
                this.notifyAll();
            }
            task.schedule(n);
            throw throwable;
        }
        synchronized (refreshRequest) {
            this.task = task;
            this.notifyAll();
        }
        task.schedule(n);
    }

    private void doLoop(int n) {
        AbstractFileSystem abstractFileSystem = (AbstractFileSystem)this.system.get();
        if (abstractFileSystem == null) {
            return;
        }
        if (this.en == null || !this.en.hasMoreElements()) {
            this.en = RefreshRequest.existingFolders(abstractFileSystem);
        }
        int n2 = 0;
        while (n2 < 30 && this.en.hasMoreElements()) {
            AbstractFolder abstractFolder = (AbstractFolder)this.en.nextElement();
            if (abstractFolder != null && (!abstractFolder.isFolder() || abstractFolder.isInitialized())) {
                abstractFolder.refresh();
            }
            if (this.refreshTime <= 0) {
                return;
            }
            ++n2;
        }
        if (!this.en.hasMoreElements()) {
            this.en = null;
        }
    }

    private static Enumeration existingFolders(AbstractFileSystem abstractFileSystem) {
        return abstractFileSystem.existingFileObjects(abstractFileSystem.getAbstractRoot());
    }
}

