/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.TreeSelectionEvent;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ClassNamePanel
extends JPanel
implements DocumentListener,
WizardDescriptor.FinishPanel {
    private ChangeListener listener;
    private String extension;
    DataFolder targetFolder;
    private JPanel namePanel;
    private JLabel jLabel1;
    private JTextField className;
    static /* synthetic */ Class class$org$openide$loaders$ClassNamePanel;

    public ClassNamePanel() {
        this.initComponents();
        this.setName(ClassNamePanel.getString("LAB_NewClassPanelName"));
        this.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.className.getDocument().addDocumentListener(this);
        this.className.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        ResourceBundle resourceBundle = NbBundle.getBundle(class$org$openide$loaders$ClassNamePanel == null ? (class$org$openide$loaders$ClassNamePanel = ClassNamePanel.class$("org.openide.loaders.ClassNamePanel")) : class$org$openide$loaders$ClassNamePanel);
        this.jLabel1.setDisplayedMnemonic(resourceBundle.getString("CTL_TemplateClassName_Mnemonic").charAt(0));
        this.setClassName("");
        this.putClientProperty("WizardPanel_contentData", new String[]{this.getName()});
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
        this.className.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TemplateClassName"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ClassNamePanel"));
    }

    public Dimension getPreferredSize() {
        return TemplateWizard.PREF_DIM;
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.className = new JTextField();
        this.setLayout(new BorderLayout(0, 8));
        this.setPreferredSize(new Dimension(560, 520));
        this.namePanel.setLayout(new GridBagLayout());
        this.namePanel.setPreferredSize(new Dimension(0, 0));
        this.jLabel1.setText(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_TemplateClassName"));
        this.jLabel1.setLabelFor(this.className);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagConstraints.anchor = 17;
        this.namePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.className.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ClassNamePanel.this.classNameFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.namePanel.add((Component)this.className, gridBagConstraints);
        this.add((Component)this.namePanel, "Center");
    }

    private void packageNameFocusGained(FocusEvent focusEvent) {
    }

    private void packageModelChanged(ListDataEvent listDataEvent) {
    }

    private void classNameFocusGained(FocusEvent focusEvent) {
        if (Utilities.getOperatingSystem() == 8 | Utilities.getOperatingSystem() == 256) {
            return;
        }
        this.className.selectAll();
    }

    private void templatesTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.className.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ClassNamePanel.this.className.getText().equals("")) {
                        ClassNamePanel.this.setClassName("");
                    }
                    ClassNamePanel.this.fireStateChanged();
                }
            });
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public HelpCtx getHelp() {
        return new HelpCtx(class$org$openide$loaders$ClassNamePanel == null ? (class$org$openide$loaders$ClassNamePanel = ClassNamePanel.class$("org.openide.loaders.ClassNamePanel")) : class$org$openide$loaders$ClassNamePanel);
    }

    public boolean isValid() {
        FileObject fileObject = this.targetFolder.getPrimaryFile().getFileObject(this.className.getText(), this.extension);
        return fileObject == null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    private void setClassName(String string) {
        String string2 = string;
        if (string == null || string.length() == 0) {
            string2 = ClassNamePanel.defaultClassName();
        }
        this.className.getDocument().removeDocumentListener(this);
        this.className.setText(string2);
        this.className.getDocument().addDocumentListener(this);
        if (string == null || string.length() == 0) {
            this.className.selectAll();
        }
    }

    public String getClassName() {
        return this.className.getText();
    }

    static String defaultClassName() {
        return ClassNamePanel.getString("FMT_DefaultClassName");
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$loaders$ClassNamePanel == null ? (class$org$openide$loaders$ClassNamePanel = ClassNamePanel.class$("org.openide.loaders.ClassNamePanel")) : class$org$openide$loaders$ClassNamePanel).getString(string);
    }

    public Component getComponent() {
        return this;
    }

    public void readSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        DataObject dataObject = templateWizard.getTemplate();
        if (dataObject != null) {
            this.extension = dataObject.getPrimaryFile().getExt();
        }
        try {
            this.targetFolder = templateWizard.getTargetFolder();
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify(iOException);
        }
    }

    public void storeSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        String string = this.className.getText();
        if (string.equals(ClassNamePanel.defaultClassName())) {
            string = null;
        }
        templateWizard.setTargetName(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

