/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceNode;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLSettingsSupport;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.TopComponent;

public class InstanceDataObject
extends MultiDataObject
implements InstanceCookie.Of {
    static final long serialVersionUID = -6134784731744777123L;
    private static final String EA_INSTANCE_CLASS = "instanceClass";
    private static final String EA_INSTANCE_CREATE = "instanceCreate";
    private static final String EA_INSTANCE_OF = "instanceOf";
    static final String EA_NAME = "name";
    private static final int SAVE_DELAY = 2000;
    private static final ThreadLocal TL_INSTANCE = new ThreadLocal();
    private static final char OPEN = '[';
    private static final char CLOSE = ']';
    public static final String INSTANCE = "instance";
    static final String SER_EXT = "ser";
    static final String XML_EXT = "settings";
    private static final String ICON_NAME = "icon";
    private static final String DISPLAY_NAME = "name";
    private Instance ser;
    private boolean initedEditorSupport;
    private boolean savingCanceled = false;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Instance processor");
    private final ErrorManager err;
    private final Object IDO_LOCK = new Object();
    private final Object COOKIE_CHNG_LOCK = new Object();
    private static final int MAX_FILENAME_LENGTH = 50;
    private FileLock fileLock;
    private final Saver saver = new Saver(this);
    static /* synthetic */ Class class$org$openide$util$SharedClassObject;
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$org$openide$nodes$Node$Handle;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject$SettingsEditorSupport;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$org$openide$loaders$XMLSettingsSupport$BrokenSettings;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject$SettingsInstance;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public InstanceDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        String string = "org.openide.loaders.InstanceDataObject." + fileObject.getPackageNameExt('.', '.');
        this.err = TopManager.getDefault().getErrorManager().getInstance(string);
        if (fileObject.hasExt(SER_EXT)) {
            this.ser = new Ser(this);
            this.getCookieSet().add(this.ser);
            this.initedEditorSupport = true;
        } else if (fileObject.hasExt(XML_EXT)) {
            this.ser = new SettingsInstance(this, TL_INSTANCE.get());
            this.getCookieSet().add(this.ser);
            this.initedEditorSupport = false;
        } else {
            this.ser = new Ser(this);
            this.initedEditorSupport = true;
        }
    }

    private Object getLock() {
        return this.IDO_LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instanceCookieChanged() {
        if (!this.getPrimaryFile().hasExt(XML_EXT) || !this.isValid()) {
            return;
        }
        Object object = this.COOKIE_CHNG_LOCK;
        synchronized (object) {
            if (((SettingsInstance)this.ser).doNotCheckContent) {
                return;
            }
            SettingsInstance settingsInstance = new SettingsInstance(this, null);
            ((SettingsInstance)this.ser).doNotCheckContent = true;
            ((SettingsInstance)this.ser).setInstance(null);
            CookieSet cookieSet = this.getCookieSet();
            this.ser = settingsInstance;
            cookieSet.add(settingsInstance);
            if (settingsInstance.instanceOf(class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = InstanceDataObject.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject)) {
                try {
                    settingsInstance.instanceCreate();
                }
                catch (Exception exception) {
                    TopManager.getDefault().notifyException(exception);
                }
            }
        }
    }

    private static FileObject findFO(DataFolder dataFolder, String string, String string2) {
        FileObject fileObject = dataFolder.getPrimaryFile();
        String string3 = string2.replace('.', '-');
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.hasExt(INSTANCE) || (string == null ? !string3.equals(InstanceDataObject.getName(fileObject2)) : !string.equals(InstanceDataObject.getName(fileObject2))) || !string2.equals(Ser.getClassName(fileObject2))) continue;
            return fileObject2;
        }
        return null;
    }

    private static String getName(FileObject fileObject) {
        String string = (String)fileObject.getAttribute("name");
        if (string != null) {
            return string;
        }
        string = fileObject.getName();
        int n = string.indexOf(91);
        return InstanceDataObject.unescape(n < 0 ? string : string.substring(0, n));
    }

    public static InstanceDataObject find(DataFolder dataFolder, String string, String string2) {
        FileObject fileObject = InstanceDataObject.findFO(dataFolder, string, string2);
        if (fileObject != null) {
            try {
                return (InstanceDataObject)DataObject.find(fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static InstanceDataObject find(DataFolder dataFolder, String string, Class clazz) {
        return InstanceDataObject.find(dataFolder, string, clazz.getName());
    }

    public static InstanceDataObject create(DataFolder dataFolder, final String string, final String string2) throws IOException {
        final FileObject fileObject = dataFolder.getPrimaryFile();
        if (string != null && string.length() == 0) {
            throw new IOException("name cannot be empty");
        }
        FileObject fileObject2 = InstanceDataObject.findFO(dataFolder, string, string2);
        if (fileObject2 == null) {
            final FileObject[] fileObjectArray = new FileObject[1];
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    String string3 = string == null ? FileUtil.findFreeFileName(fileObject, string2.replace('.', '-'), InstanceDataObject.INSTANCE) : InstanceDataObject.escape(string);
                    fileObjectArray[0] = fileObject.createData(string3, InstanceDataObject.INSTANCE);
                    fileObjectArray[0].setAttribute(InstanceDataObject.EA_INSTANCE_CLASS, string2);
                }
            });
            fileObject2 = fileObjectArray[0];
        }
        return (InstanceDataObject)DataObject.find(fileObject2);
    }

    public static InstanceDataObject create(DataFolder dataFolder, String string, Class clazz) throws IOException {
        return InstanceDataObject.create(dataFolder, string, clazz.getName());
    }

    public static InstanceDataObject create(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo) throws IOException {
        if (string != null && string.length() == 0) {
            throw new IOException("name cannot be empty");
        }
        return Creator.createInstanceDataObject(dataFolder, string, object, moduleInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstanceDataObject storeSettings(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo) throws IOException {
        InstanceDataObject instanceDataObject;
        Object var4_4 = null;
        Object var5_5 = null;
        FileObject fileObject = null;
        FileObject fileObject2 = dataFolder.getPrimaryFile();
        ByteArrayOutputStream byteArrayOutputStream = SettingsInstance.saveInstance2Buffer(object, moduleInfo);
        fileObject = fileObject2.getFileObject(string, XML_EXT);
        if (fileObject == null) {
            fileObject = fileObject2.createData(string, XML_EXT);
        }
        String string2 = "org.openide.loaders.InstanceDataObject." + fileObject.getPackageNameExt('.', '.');
        ErrorManager errorManager = TopManager.getDefault().getErrorManager().getInstance(string2);
        errorManager.log("createData.size: " + fileObject.getSize());
        try {
            TL_INSTANCE.set(object);
            instanceDataObject = (InstanceDataObject)DataObject.find(fileObject);
            Object var13_12 = null;
            TL_INSTANCE.set(null);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            TL_INSTANCE.set(null);
            throw throwable;
        }
        SettingsInstance settingsInstance = (SettingsInstance)instanceDataObject.ser;
        settingsInstance.setInstance(object);
        instanceDataObject.getSaver().save(byteArrayOutputStream);
        errorManager.log("createdData.size: " + fileObject.getSize());
        return instanceDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean remove(DataFolder dataFolder, String string, String string2) {
        FileLock fileLock = null;
        try {
            try {
                FileObject fileObject = InstanceDataObject.findFO(dataFolder, string, string2);
                if (fileObject == null) {
                    boolean bl = false;
                    Object var7_8 = null;
                    if (fileLock == null) return bl;
                    fileLock.releaseLock();
                    return bl;
                }
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                boolean bl = false;
                Object var7_10 = null;
                if (fileLock == null) return bl;
                fileLock.releaseLock();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        Object var7_9 = null;
        if (fileLock == null) return true;
        fileLock.releaseLock();
        return true;
    }

    public static boolean remove(DataFolder dataFolder, String string, Class clazz) {
        return InstanceDataObject.remove(dataFolder, string, clazz.getName());
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = InstanceSupport.findHelp(this);
        if (helpCtx != null) {
            return helpCtx;
        }
        return new HelpCtx(class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = InstanceDataObject.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject);
    }

    protected Node createNodeDelegate() {
        try {
            if (this.getPrimaryFile().getFileSystem() != Repository.getDefault().getDefaultFileSystem()) {
                return new DataNode(this, Children.LEAF);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            TopManager.getDefault().getErrorManager().notify(1, fileStateInvalidException);
            return new DataNode(this, Children.LEAF);
        }
        try {
            if (this.instanceOf(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = InstanceDataObject.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)) {
                Node node = (Node)this.instanceCreate();
                return new CookieAdjustingFilter(node);
            }
            if (this.instanceOf(class$org$openide$nodes$Node$Handle == null ? (class$org$openide$nodes$Node$Handle = InstanceDataObject.class$("org.openide.nodes.Node$Handle")) : class$org$openide$nodes$Node$Handle)) {
                Node.Handle handle = (Node.Handle)this.instanceCreate();
                return new CookieAdjustingFilter(handle.getNode());
            }
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify(1, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(1, classNotFoundException);
        }
        return new InstanceNode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = super.getCookie(clazz);
        if (cookie == null && clazz.isAssignableFrom(class$org$openide$loaders$InstanceDataObject$SettingsEditorSupport == null ? (class$org$openide$loaders$InstanceDataObject$SettingsEditorSupport = InstanceDataObject.class$("org.openide.loaders.InstanceDataObject$SettingsEditorSupport")) : class$org$openide$loaders$InstanceDataObject$SettingsEditorSupport)) {
            Object object = this.getLock();
            synchronized (object) {
                if (!this.initedEditorSupport) {
                    this.initedEditorSupport = true;
                    cookie = new SettingsEditorSupport(this);
                    this.getCookieSet().add(cookie);
                }
            }
        } else if (cookie != null && cookie instanceof SettingsInstance && !((SettingsInstance)cookie).isModuleEnabled()) {
            cookie = null;
        }
        return cookie;
    }

    private InstanceCookie.Of delegateIC() {
        return this.ser;
    }

    public String instanceName() {
        InstanceCookie.Of of = this.delegateIC();
        return of.instanceName();
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        InstanceCookie.Of of = this.delegateIC();
        return of.instanceClass();
    }

    public boolean instanceOf(Class clazz) {
        return this.delegateIC().instanceOf(clazz);
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        InstanceCookie.Of of = this.delegateIC();
        return of.instanceCreate();
    }

    public String getName() {
        String string = (String)this.getPrimaryFile().getAttribute("name");
        if (string != null) {
            return string;
        }
        string = super.getName();
        int n = string.indexOf(91);
        return InstanceDataObject.unescape(n < 0 ? string : string.substring(0, n));
    }

    protected FileObject handleRename(String string) throws IOException {
        FileObject fileObject = this.getPrimaryFile();
        fileObject.setAttribute("name", string);
        return fileObject;
    }

    static String escape(String string) {
        boolean bl = string.startsWith(" ") || string.endsWith(" ") || string.indexOf("  ") != -1;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '/' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '<' || c == '>' || c == '?' || c == '*' || c == '|' || c == ' ' && bl || c == '.' || c == '\"' || c < ' ' || c > '~' || c == '#') {
                stringBuffer.append('#');
                String string2 = Integer.toString(c, 16).toUpperCase();
                if (string2.length() < 4) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 3) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String unescape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '#') {
                block6: {
                    if (n2 + 4 >= n) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                        System.err.println("trailing garbage in instance name: " + string);
                        break;
                    }
                    try {
                        char[] cArray = new char[4];
                        string.getChars(n2 + 1, n2 + 5, cArray, 0);
                        stringBuffer.append((char)Integer.parseInt(new String(cArray), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block6;
                        numberFormatException.printStackTrace();
                    }
                }
                n2 += 4;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String escapeAndCut(String string) {
        int n = 50;
        String string2 = InstanceDataObject.escape(string);
        if (string2.length() <= n) {
            return string2;
        }
        String string3 = Integer.toHexString(string2.hashCode());
        n = n > string3.length() ? (n - string3.length()) / 2 : 1;
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(string2.length() - n);
        return string4 + string3 + string5;
    }

    final void scheduleSave() {
        if (this.isSavingCanceled()) {
            return;
        }
        this.doFileLock();
        this.ser.getSaveTask().schedule(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock doFileLock() {
        Object object = this.getLock();
        synchronized (object) {
            block6: {
                if (this.fileLock == null) break block6;
                FileLock fileLock = this.fileLock;
                return fileLock;
            }
            try {
                this.fileLock = this.getPrimaryFile().lock();
            }
            catch (IOException iOException) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.annotate((Throwable)iOException, this.getPrimaryFile().toString());
                errorManager.notify(1, iOException);
            }
            FileLock fileLock = this.fileLock;
            return fileLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relaseFileLock() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fileLock == null) {
                return;
            }
            this.fileLock.releaseLock();
            this.fileLock = null;
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        try {
            if (this.getPrimaryFile().hasExt(XML_EXT)) {
                InstanceCookie instanceCookie = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                Object object = instanceCookie.instanceCreate();
                InstanceDataObject instanceDataObject = this.createSettingsFile(dataFolder, string, object);
                SettingsInstance settingsInstance = (SettingsInstance)this.ser;
                settingsInstance.setInstance(null);
                return instanceDataObject;
            }
            if (!this.getPrimaryFile().hasExt(INSTANCE) && (class$java$io$Serializable == null ? (class$java$io$Serializable = InstanceDataObject.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.instanceClass())) {
                InstanceCookie instanceCookie = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                Object object = instanceCookie.instanceCreate();
                return DataObject.find(this.createSerFile(dataFolder, string, object));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(1, classNotFoundException);
        }
        return super.handleCreateFromTemplate(dataFolder, string);
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        try {
            if (this.getPrimaryFile().hasExt(XML_EXT)) {
                InstanceCookie instanceCookie = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                Object object = instanceCookie.instanceCreate();
                return this.createSettingsFile(dataFolder, this.getNodeDelegate().getDisplayName(), object);
            }
            if (!this.getPrimaryFile().hasExt(INSTANCE) && (class$java$io$Serializable == null ? (class$java$io$Serializable = InstanceDataObject.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.instanceClass())) {
                InstanceCookie instanceCookie = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                Object object = instanceCookie.instanceCreate();
                return DataObject.find(this.createSerFile(dataFolder, this.getNodeDelegate().getDisplayName(), object));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(1, classNotFoundException);
        }
        return super.handleCopy(dataFolder);
    }

    protected void handleDelete() throws IOException {
        this.savingCanceled = true;
        if (this.ser != null) {
            RequestProcessor.Task task = this.ser.getSaveTask();
            task.cancel();
            if (this.ser.isSaving() && !task.isFinished()) {
                task.waitFinished();
            }
        }
        this.relaseFileLock();
        super.handleDelete();
    }

    private boolean isSavingCanceled() {
        return this.savingCanceled;
    }

    protected void dispose() {
        RequestProcessor.Task task;
        this.savingCanceled = true;
        if (this.ser != null && ((task = this.ser.getSaveTask()).getDelay() > 0 || this.ser.isSaving() && !task.isFinished())) {
            task.waitFinished();
        }
        this.relaseFileLock();
        super.dispose();
    }

    private InstanceDataObject createSettingsFile(DataFolder dataFolder, String string, Object object) throws IOException {
        String string2;
        Object object2;
        Object object3;
        FileObject fileObject = dataFolder.getPrimaryFile();
        if (object instanceof ServiceType) {
            object3 = (ServiceType)object;
            string = string == null ? ((ServiceType)object3).getName() : string;
            object2 = string;
            int n = 1;
            while (TopManager.getDefault().getServices().find((String)object2) != null) {
                object2 = new StringBuffer(string.length() + 2).append(string).append('_').append(n).toString();
                ++n;
            }
            if (!((String)object2).equals(((ServiceType)object3).getName())) {
                object = object3 = ((ServiceType)object3).createClone();
                ((ServiceType)object3).setName((String)object2);
            }
            string2 = InstanceDataObject.escapeAndCut((String)object2);
        } else {
            string2 = string == null ? this.getPrimaryFile().getName() : InstanceDataObject.escapeAndCut(string);
        }
        string2 = FileUtil.findFreeFileName(dataFolder.getPrimaryFile(), string2, this.getPrimaryFile().getExt());
        object3 = (SettingsInstance)this.ser;
        object2 = InstanceDataObject.storeSettings(dataFolder, string2, object, ((SettingsInstance)object3).getModuleInfo());
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject createSerFile(DataFolder dataFolder, String string, Object object) throws IOException {
        FileObject fileObject;
        FileLock fileLock;
        block7: {
            fileLock = null;
            OutputStream outputStream = null;
            fileObject = null;
            try {
                FileObject fileObject2 = dataFolder.getPrimaryFile();
                if (string == null) {
                    string = FileUtil.findFreeFileName(dataFolder.getPrimaryFile(), this.getPrimaryFile().getName(), this.getPrimaryFile().getExt());
                }
                if ((fileObject = fileObject2.getFileObject(string, SER_EXT)) == null) {
                    fileObject = fileObject2.createData(string, SER_EXT);
                }
                fileLock = fileObject.lock();
                outputStream = fileObject.getOutputStream(fileLock);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                Object var10_9 = null;
                if (outputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                throw throwable;
            }
            outputStream.close();
        }
        if (fileLock != null) {
            fileLock.releaseLock();
        }
        return fileObject;
    }

    final void setCustomClassLoader(ClassLoader classLoader) {
        if (this.ser instanceof Ser) {
            ((Ser)this.ser).setCustomClassLoader(classLoader);
        }
    }

    private Saver getSaver() {
        return this.saver;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Saver
    implements FileSystem.AtomicAction {
        private InstanceDataObject dobj;
        private ByteArrayOutputStream buf;

        private Saver(InstanceDataObject instanceDataObject) {
            this.dobj = instanceDataObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException {
            FileObject fileObject = this.dobj.getPrimaryFile();
            Object object = this.dobj.getLock();
            synchronized (object) {
                block8: {
                    block7: {
                        this.dobj.err.log("saving");
                        try {
                            FileLock fileLock = this.dobj.doFileLock();
                            if (fileLock == null) {
                                Object var9_4 = null;
                                break block7;
                            }
                            OutputStream outputStream = fileObject.getOutputStream(fileLock);
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);
                            try {
                                this.buf.writeTo(bufferedOutputStream);
                                this.dobj.err.log("saved");
                                Object var7_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_10 = null;
                                ((OutputStream)bufferedOutputStream).close();
                                throw throwable;
                            }
                            ((OutputStream)bufferedOutputStream).close();
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var9_6 = null;
                            this.dobj.relaseFileLock();
                            throw throwable;
                        }
                    }
                    this.dobj.relaseFileLock();
                    return;
                }
                Object var9_5 = null;
                this.dobj.relaseFileLock();
                return;
            }
        }

        public void save(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            this.buf = byteArrayOutputStream;
            this.dobj.getPrimaryFile().getFileSystem().runAtomicAction(this);
            this.buf = null;
        }

        public boolean isFiredFromMe(FileEvent fileEvent) {
            return fileEvent.firedFrom(this);
        }
    }

    private static class Creator
    implements FileSystem.AtomicAction {
        private ModuleInfo mi = null;
        private DataFolder folder = null;
        private Object instance = null;
        private String name = null;
        private InstanceDataObject result = null;
        private static final Creator me = new Creator();

        private Creator() {
        }

        public void run() throws IOException {
            FileObject fileObject = this.folder.getPrimaryFile();
            String string = this.name;
            if (string == null) {
                string = this.instance.getClass().getName().replace('.', '-');
                string = FileUtil.findFreeFileName(fileObject, string, InstanceDataObject.XML_EXT);
            } else {
                String string2 = InstanceDataObject.escape(string);
                string = fileObject.getFileObject(string2, InstanceDataObject.XML_EXT) == null ? InstanceDataObject.escapeAndCut(string) : string2;
            }
            this.result = InstanceDataObject.storeSettings(this.folder, string, this.instance, this.mi);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InstanceDataObject createInstanceDataObject(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo) throws IOException {
            Creator creator = me;
            synchronized (creator) {
                if (moduleInfo == null) {
                    moduleInfo = SettingsInstance.getModuleInfo(object.getClass());
                }
                Creator.me.mi = moduleInfo;
                Creator.me.folder = dataFolder;
                Creator.me.instance = object;
                Creator.me.name = string;
                dataFolder.getPrimaryFile().getFileSystem().runAtomicAction(me);
                Creator.me.mi = null;
                Creator.me.folder = null;
                Creator.me.instance = null;
                Creator.me.name = null;
                InstanceDataObject instanceDataObject = Creator.me.result;
                Creator.me.result = null;
                InstanceDataObject instanceDataObject2 = instanceDataObject;
                return instanceDataObject2;
            }
        }

        public static boolean isFiredFromMe(FileEvent fileEvent) {
            return fileEvent.firedFrom(me);
        }
    }

    static interface Instance
    extends Runnable,
    InstanceCookie.Of {
        public RequestProcessor.Task getSaveTask();

        public boolean isSaving();
    }

    private static class SettingsEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 69354975290667322L;

        public SettingsEnv(InstanceDataObject instanceDataObject) {
            super(instanceDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((InstanceDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (SettingsEditorSupport)this.getDataObject().getCookie(class$org$openide$loaders$InstanceDataObject$SettingsEditorSupport == null ? (class$org$openide$loaders$InstanceDataObject$SettingsEditorSupport = InstanceDataObject.class$("org.openide.loaders.InstanceDataObject$SettingsEditorSupport")) : class$org$openide$loaders$InstanceDataObject$SettingsEditorSupport);
        }
    }

    private class SettingsEditorSupport
    extends DataEditorSupport
    implements EditorCookie,
    EditCookie,
    CloseCookie {
        public SettingsEditorSupport(InstanceDataObject instanceDataObject2) {
            super(instanceDataObject2, new SettingsEnv(instanceDataObject2));
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            InstanceDataObject instanceDataObject = (InstanceDataObject)this.getDataObject();
            if (instanceDataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = InstanceDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == null) {
                instanceDataObject.setModified(true);
                instanceDataObject.getCookieSet().add(new Save());
            }
            return true;
        }

        protected void notifyUnmodified() {
            InstanceDataObject instanceDataObject = (InstanceDataObject)this.getDataObject();
            SaveCookie saveCookie = (SaveCookie)instanceDataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = InstanceDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (saveCookie != null) {
                instanceDataObject.getCookieSet().remove(saveCookie);
                instanceDataObject.setModified(false);
            }
            super.notifyUnmodified();
        }

        private class Save
        implements SaveCookie {
            private Save() {
            }

            public void save() throws IOException {
                SettingsEditorSupport.this.saveDocument();
                SettingsEditorSupport.this.getDataObject().setModified(false);
            }
        }
    }

    static final class SettingsInstance
    implements InstanceCookie.Origin,
    PropertyChangeListener,
    Instance,
    FileChangeListener {
        private static boolean aModuleHasBeenChanged = false;
        private InstanceDataObject dobj;
        private WeakReference weakInst = new WeakReference<Object>(null);
        private final Object INSTANCE_LOCK = new Object();
        private RequestProcessor.Task task;
        private PropertyChangeListener moduleListener;
        private XMLSettingsSupport.SettingsRecognizer settings = null;
        private boolean doNotCheckContent = false;
        private Boolean knownToBeTemplate = null;
        private final Object MODULE_LST_LOCK = new Object();
        private static HashMap modules = null;
        private static Lookup.Result modulesResult = null;
        private static final Object MODULES_LOCK = new Object();
        private boolean saving = false;

        public SettingsInstance(InstanceDataObject instanceDataObject, Object object) {
            this.dobj = instanceDataObject;
            FileObject fileObject = this.dobj.getPrimaryFile();
            fileObject.addFileChangeListener(WeakListener.fileChange(this, this.dobj.getPrimaryFile()));
            this.setInstance(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XMLSettingsSupport.SettingsRecognizer getSettings(boolean bl) throws IOException {
            Object object = this.dobj.getLock();
            synchronized (object) {
                block5: {
                    if (this.settings != null) break block5;
                    this.settings = new XMLSettingsSupport.SettingsRecognizer(bl, this.dobj.getPrimaryFile());
                    this.settings.parse();
                    XMLSettingsSupport.SettingsRecognizer settingsRecognizer = this.settings;
                    return settingsRecognizer;
                }
                if (!bl && !this.settings.isAllRead()) {
                    this.settings.setAllRead(false);
                    this.settings.parse();
                }
                XMLSettingsSupport.SettingsRecognizer settingsRecognizer = this.settings;
                return settingsRecognizer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object instanceCreate() throws IOException, ClassNotFoundException {
            XMLSettingsSupport.SettingsRecognizer settingsRecognizer;
            if (!this.isModuleEnabled()) {
                return new XMLSettingsSupport.BrokenSettings(this.getSettings(true).getCodeName());
            }
            Object object = null;
            boolean bl = false;
            Object object2 = this.INSTANCE_LOCK;
            synchronized (object2) {
                block8: {
                    object = this.weakInst.get();
                    if (object == null) break block8;
                    Object object3 = object;
                    return object3;
                }
                settingsRecognizer = this.getSettings(false);
                if ((class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = InstanceDataObject.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).isAssignableFrom(settingsRecognizer.instanceClass())) {
                    bl = true;
                } else {
                    object = settingsRecognizer.instanceCreate();
                    this.weakInst = new WeakReference<Object>(object);
                }
            }
            if (bl) {
                object = settingsRecognizer.instanceCreate();
                this.weakInst = new WeakReference<Object>(object);
            }
            this.registerPropertyListener(object);
            return object;
        }

        private void registerPropertyListener(Object object) {
            try {
                Method method = object.getClass().getMethod("addPropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = InstanceDataObject.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
                method.invoke(object, this);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        private void unregisterPropertyListener(Object object) {
            try {
                Method method = object.getClass().getMethod("removePropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = InstanceDataObject.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
                method.invoke(object, this);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            if (!this.isModuleEnabled()) {
                return class$org$openide$loaders$XMLSettingsSupport$BrokenSettings == null ? (class$org$openide$loaders$XMLSettingsSupport$BrokenSettings = InstanceDataObject.class$("org.openide.loaders.XMLSettingsSupport$BrokenSettings")) : class$org$openide$loaders$XMLSettingsSupport$BrokenSettings;
            }
            Object t = this.weakInst.get();
            if (t != null) {
                return t.getClass();
            }
            XMLSettingsSupport.SettingsRecognizer settingsRecognizer = this.getSettings(false);
            return settingsRecognizer.instanceClass();
        }

        public boolean instanceOf(Class clazz) {
            Exception exception;
            if (!this.isModuleEnabled()) {
                return (class$org$openide$loaders$XMLSettingsSupport$BrokenSettings == null ? (class$org$openide$loaders$XMLSettingsSupport$BrokenSettings = InstanceDataObject.class$("org.openide.loaders.XMLSettingsSupport$BrokenSettings")) : class$org$openide$loaders$XMLSettingsSupport$BrokenSettings).isAssignableFrom(clazz);
            }
            try {
                if (aModuleHasBeenChanged && clazz.getClassLoader() != ClassLoader.getSystemClassLoader()) {
                    Class clazz2 = this.getSettings(true).instanceClass();
                    return clazz.isAssignableFrom(clazz2);
                }
                return this.getSettings(true).getInstanceOf().contains(clazz.getName());
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception = classNotFoundException;
            }
            ErrorManager errorManager = TopManager.getDefault().getErrorManager();
            errorManager.annotate((Throwable)exception, this.dobj.getPrimaryFile().toString());
            errorManager.notify(1, exception);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isModuleEnabled() {
            XMLSettingsSupport.SettingsRecognizer settingsRecognizer;
            try {
                settingsRecognizer = this.getSettings(true);
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify(1, iOException);
                return false;
            }
            if (settingsRecognizer.getCodeName() == null || settingsRecognizer.getCodeName().length() == 0) {
                return true;
            }
            ModuleInfo moduleInfo = SettingsInstance.getModule(settingsRecognizer.getCodeNameBase());
            if (moduleInfo == null) {
                return false;
            }
            Object object = this.MODULE_LST_LOCK;
            synchronized (object) {
                if (this.moduleListener == null) {
                    this.moduleListener = new PropertyChangeListener(this, moduleInfo){
                        private boolean previous;
                        private final /* synthetic */ ModuleInfo val$m;
                        private final /* synthetic */ SettingsInstance this$0;
                        {
                            this.this$0 = settingsInstance;
                            this.val$m = moduleInfo;
                            this.previous = this.val$m.isEnabled();
                        }

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                                boolean bl;
                                if (!Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                                    SettingsInstance.access$802(true);
                                    bl = this.previous;
                                } else {
                                    bl = !this.previous;
                                }
                                this.previous = this.val$m.isEnabled();
                                if (bl) {
                                    InstanceDataObject.access$1000(SettingsInstance.access$900(this.this$0));
                                }
                            }
                        }
                    };
                    moduleInfo.addPropertyChangeListener(WeakListener.propertyChange(this.moduleListener, moduleInfo));
                }
            }
            if (!moduleInfo.isEnabled()) {
                return false;
            }
            if (settingsRecognizer.getCodeNameRelease() > moduleInfo.getCodeNameRelease()) {
                return false;
            }
            return settingsRecognizer.getSpecificationVersion() == null || settingsRecognizer.getSpecificationVersion().compareTo(moduleInfo.getSpecificationVersion()) <= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ModuleInfo getModule(String string) {
            Collection collection = null;
            if (modules == null) {
                collection = SettingsInstance.getModulesResult().allInstances();
            }
            Object object = MODULES_LOCK;
            synchronized (object) {
                if (modules == null) {
                    SettingsInstance.fillModules(collection);
                }
                ModuleInfo moduleInfo = (ModuleInfo)modules.get(string);
                return moduleInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Lookup.Result getModulesResult() {
            Object object = MODULES_LOCK;
            synchronized (object) {
                if (modulesResult == null) {
                    modulesResult = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = InstanceDataObject.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo));
                    modulesResult.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent lookupEvent) {
                            Collection collection = SettingsInstance.access$1100().allInstances();
                            Object object = SettingsInstance.access$1200();
                            synchronized (object) {
                                SettingsInstance.access$1300(collection);
                            }
                        }
                    });
                }
                Lookup.Result result = modulesResult;
                return result;
            }
        }

        private static void fillModules(Collection collection) {
            HashMap<String, ModuleInfo> hashMap = new HashMap<String, ModuleInfo>((collection.size() << 2) / 3 + 1);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
                hashMap.put(moduleInfo.getCodeNameBase(), moduleInfo);
            }
            modules = hashMap;
        }

        private static ModuleInfo getModuleInfo(Class clazz) {
            Iterator iterator = SettingsInstance.getModulesResult().allInstances().iterator();
            while (iterator.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
                if (!moduleInfo.owns(clazz)) continue;
                return moduleInfo;
            }
            return null;
        }

        public String instanceName() {
            Object t = this.weakInst.get();
            if (t != null) {
                return t.getClass().getName();
            }
            try {
                return this.getSettings(true).instanceName();
            }
            catch (IOException iOException) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.annotate((Throwable)iOException, this.dobj.getPrimaryFile().toString());
                errorManager.notify(1, iOException);
                return "";
            }
        }

        private void saveInstance() {
            if (!this.isModuleEnabled()) {
                return;
            }
            Object t = this.weakInst.get();
            if (t == null || !this.dobj.isValid() || !(t instanceof Serializable)) {
                return;
            }
            try {
                this.dobj.getSaver().save(SettingsInstance.saveInstance2Buffer(t, this.getModuleInfo()));
            }
            catch (IOException iOException) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.annotate((Throwable)iOException, NbBundle.getMessage(class$org$openide$loaders$InstanceDataObject$SettingsInstance == null ? (class$org$openide$loaders$InstanceDataObject$SettingsInstance = InstanceDataObject.class$("org.openide.loaders.InstanceDataObject$SettingsInstance")) : class$org$openide$loaders$InstanceDataObject$SettingsInstance, "EXC_SettingsSave", this.dobj.getPrimaryFile()));
                errorManager.notify(iOException);
            }
        }

        private void synchronizeName(Object object) {
            Method method;
            try {
                try {
                    method = object.getClass().getMethod("getDisplayName", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method = object.getClass().getMethod("getName", null);
                }
            }
            catch (Exception exception) {
                return;
            }
            try {
                String string = (String)method.invoke(object, null);
                String string2 = this.dobj.getName();
                if (!string.equals(string2)) {
                    this.dobj.getPrimaryFile().setAttribute("name", string);
                    this.dobj.firePropertyChange("name", string2, string);
                } else if (this.dobj.getPrimaryFile().getAttribute("name") == null) {
                    this.dobj.getPrimaryFile().setAttribute("name", string);
                }
            }
            catch (Exception exception) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.annotate((Throwable)exception, this.dobj.getPrimaryFile().toString());
                errorManager.notify(1, exception);
            }
        }

        private static ByteArrayOutputStream saveInstance2Buffer(Object object, ModuleInfo moduleInfo) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            XMLSettingsSupport.storeToXML10(object, byteArrayOutputStream, moduleInfo);
            return byteArrayOutputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.saving = true;
            try {
                this.saveInstance();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.dobj.relaseFileLock();
                this.saving = false;
                throw throwable;
            }
            this.dobj.relaseFileLock();
            this.saving = false;
        }

        public FileObject instanceOrigin() {
            return this.dobj.getPrimaryFile();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (Boolean.FALSE.equals(propertyChangeEvent.getPropagationId())) {
                return;
            }
            if (this.doNotCheckContent) {
                return;
            }
            if (this.knownToBeTemplate == null) {
                Boolean bl = this.knownToBeTemplate = this.dobj.isTemplate() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.knownToBeTemplate.booleanValue()) {
                return;
            }
            if (propertyChangeEvent.getSource() instanceof TopComponent) {
                return;
            }
            this.dobj.scheduleSave();
            String string = propertyChangeEvent.getPropertyName();
            if (string != null && (string.equals("name") || string.equals("displayName"))) {
                this.synchronizeName(propertyChangeEvent.getSource());
            }
            this.dobj.err.log(-5, "propertyChange.propName = " + string);
        }

        ModuleInfo getModuleInfo() {
            ModuleInfo moduleInfo = null;
            try {
                moduleInfo = SettingsInstance.getModule(this.getSettings(true).getCodeNameBase());
                if (moduleInfo == null) {
                    moduleInfo = SettingsInstance.getModuleInfo(this.instanceClass());
                }
            }
            catch (Exception exception) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.annotate((Throwable)exception, this.dobj.getPrimaryFile().toString());
                errorManager.notify(1, exception);
            }
            return moduleInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setInstance(Object object) {
            Object object2 = this.INSTANCE_LOCK;
            synchronized (object2) {
                Object t = this.weakInst.get();
                if (t == object) {
                    return;
                }
                this.weakInst = new WeakReference<Object>(object);
                if (t != null) {
                    this.unregisterPropertyListener(t);
                }
                if (object == null) {
                    return;
                }
                this.registerPropertyListener(object);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            if (this.doNotCheckContent) {
                return;
            }
            if (Creator.isFiredFromMe(fileEvent) || this.dobj.getSaver().isFiredFromMe(fileEvent)) {
                return;
            }
            this.dobj.instanceCookieChanged();
        }

        public RequestProcessor.Task getSaveTask() {
            if (this.task == null) {
                this.task = PROCESSOR.create(this);
            }
            return this.task;
        }

        public boolean isSaving() {
            return this.saving;
        }

        static /* synthetic */ boolean access$802(boolean bl) {
            aModuleHasBeenChanged = bl;
            return aModuleHasBeenChanged;
        }

        static /* synthetic */ InstanceDataObject access$900(SettingsInstance settingsInstance) {
            return settingsInstance.dobj;
        }

        static /* synthetic */ Lookup.Result access$1100() {
            return SettingsInstance.getModulesResult();
        }

        static /* synthetic */ Object access$1200() {
            return MODULES_LOCK;
        }

        static /* synthetic */ void access$1300(Collection collection) {
            SettingsInstance.fillModules(collection);
        }
    }

    private static final class Ser
    extends InstanceSupport.Origin
    implements Instance {
        private Reference bean = new WeakReference<Object>(null);
        private long saveTime;
        private ClassLoader customClassLoader = null;
        private InstanceDataObject dobj;
        private RequestProcessor.Task task;
        private boolean saving = false;

        public Ser(InstanceDataObject instanceDataObject) {
            super(instanceDataObject.getPrimaryEntry());
            this.dobj = instanceDataObject;
        }

        public String instanceName() {
            FileObject fileObject = this.entry().getFile();
            if (!fileObject.hasExt(InstanceDataObject.INSTANCE)) {
                return super.instanceName();
            }
            return Ser.getClassName(fileObject);
        }

        private static String getClassName(FileObject fileObject) {
            Object object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_CLASS);
            if (object instanceof String) {
                return Utilities.translate((String)object);
            }
            if (object != null) {
                TopManager.getDefault().getErrorManager().log(1, "instanceClass was a " + object.getClass().getName());
            }
            String string = fileObject.getName();
            int n = string.indexOf(91) + 1;
            int n2 = string.indexOf(93);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (n < n2) {
                string = string.substring(n, n2);
            }
            string = string.replace('-', '.');
            string = Utilities.translate(string);
            return string;
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            Class clazz = super.instanceClass(this.customClassLoader);
            Ser.updateListOfClasses(clazz, this.entry().getFile());
            return clazz;
        }

        public boolean instanceOf(Class clazz) {
            Object object;
            FileObject fileObject = this.entry().getFile();
            if (fileObject.lastModified().getTime() <= this.saveTime && (object = this.bean.get()) != null) {
                return clazz.isInstance(object);
            }
            object = Ser.inListOfClasses(clazz, this.entry().getFile());
            if (object == null) {
                return super.instanceOf(clazz);
            }
            return (Boolean)object;
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            FileObject fileObject = this.entry().getFile();
            Object object = fileObject.lastModified().getTime() <= this.saveTime ? (Object)this.bean.get() : null;
            if (object != null) {
                return object;
            }
            this.saveTime = fileObject.lastModified().getTime();
            if (this.saveTime < System.currentTimeMillis()) {
                this.saveTime = System.currentTimeMillis();
            }
            if (fileObject.hasExt(InstanceDataObject.INSTANCE)) {
                object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_CREATE);
            }
            if (object == null) {
                object = super.instanceCreate();
            }
            this.bean = new WeakReference<Object>(object);
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.saving = true;
                this.runImpl();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.dobj.relaseFileLock();
                this.saving = false;
                throw throwable;
            }
            this.dobj.relaseFileLock();
            this.saving = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runImpl() {
            Object t = this.bean.get();
            if (t == null) {
                return;
            }
            try {
                FileLock fileLock = this.dobj.doFileLock();
                if (fileLock == null) {
                    return;
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.entry().getFile().getOutputStream(fileLock));
                try {
                    objectOutputStream.writeObject(t);
                    this.saveTime = this.entry().getFile().lastModified().getTime();
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    objectOutputStream.close();
                    throw throwable;
                }
                objectOutputStream.close();
                {
                }
            }
            catch (IOException iOException) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.annotate((Throwable)iOException, NbBundle.getMessage(class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = InstanceDataObject.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject, "EXC_CannotSaveBean", this.instanceName(), this.entry().getFile().getPackageNameExt('/', '.')));
                errorManager.notify(iOException);
            }
        }

        private static Boolean inListOfClasses(Class clazz, FileObject fileObject) {
            Object object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_OF);
            if (object instanceof String) {
                String string = clazz.getName();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",;:");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!string.equals(string2)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (object != null) {
                TopManager.getDefault().getErrorManager().log(1, "instanceOf was a " + object.getClass().getName());
            }
            return null;
        }

        private static void updateListOfClasses(Class clazz, FileObject fileObject) {
            boolean bl;
            StringBuffer stringBuffer = null;
            Object object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_OF);
            if (object instanceof String) {
                bl = false;
                stringBuffer = new StringBuffer(1024);
                HashSet<String> hashSet = new HashSet<String>(101);
                hashSet.add("java.lang.Object");
                Ser.collectType(clazz, stringBuffer, hashSet);
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",;:");
                while (stringTokenizer.hasMoreTokens()) {
                    if (hashSet.contains(stringTokenizer.nextToken())) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            if (bl) {
                try {
                    fileObject.setAttribute(InstanceDataObject.EA_INSTANCE_OF, stringBuffer.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private static boolean collectType(Class clazz, StringBuffer stringBuffer, HashSet hashSet) {
            if (clazz == null) {
                return false;
            }
            String string = clazz.getName();
            if (hashSet.contains(string)) {
                return false;
            }
            hashSet.add(string);
            if (Ser.collectType(clazz.getSuperclass(), stringBuffer, hashSet)) {
                stringBuffer.append(',');
            }
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (Ser.collectType(classArray[n], stringBuffer, hashSet)) {
                    stringBuffer.append(',');
                }
                ++n;
            }
            stringBuffer.append(string);
            return true;
        }

        final void setCustomClassLoader(ClassLoader classLoader) {
            this.customClassLoader = classLoader;
        }

        public RequestProcessor.Task getSaveTask() {
            if (this.task == null) {
                this.task = PROCESSOR.create(this);
            }
            return this.task;
        }

        public boolean isSaving() {
            return this.saving;
        }
    }

    private final class CookieAdjustingFilter
    extends FilterNode {
        public CookieAdjustingFilter(Node node) {
            super(node);
        }

        public Node.Cookie getCookie(Class clazz) {
            if (clazz == (class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = InstanceDataObject.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject) || clazz == (class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = InstanceDataObject.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject)) {
                return InstanceDataObject.this;
            }
            return super.getCookie(clazz);
        }

        public Node.Handle getHandle() {
            return this.getOriginal().getHandle();
        }

        public boolean equals(Object object) {
            return this == object || this.getOriginal().equals(object) || object != null && object.equals(this.getOriginal());
        }

        public int hashCode() {
            return this.getOriginal().hashCode();
        }
    }
}

