/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.beans.Beans;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.openide.ServiceType;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataLoader;
import org.openide.modules.IllegalModuleException;
import org.openide.modules.ModuleDescription;
import org.openide.nodes.Node;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExClipboard;

public abstract class ManifestSection {
    String name;
    private String className;
    private Object result;
    private ModuleDescription descr;
    static /* synthetic */ Class class$org$openide$util$SharedClassObject;
    static /* synthetic */ Class class$org$openide$modules$ManifestSection;

    ManifestSection(String string, ModuleDescription moduleDescription) throws IllegalModuleException {
        this.name = string;
        this.descr = moduleDescription;
        this.className = ModuleDescription.createPackageName(string);
    }

    public Class getSectionClass() throws Exception {
        if (this.name.endsWith(".class")) {
            return this.descr.cl.loadClass(this.className);
        }
        return this.getInstance().getClass();
    }

    Object createInstance() throws Exception {
        Object object = null;
        try {
            Class<?> clazz;
            if (this.name.endsWith(".class") && (class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = ManifestSection.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).isAssignableFrom(clazz = this.descr.cl.loadClass(this.className))) {
                object = SharedClassObject.findObject(clazz, true);
            }
            if (object == null) {
                object = Beans.instantiate(this.descr.cl, this.className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.descr.showLoader();
            throw classNotFoundException;
        }
        if (this.name.endsWith(".class") && object.getClass().getClassLoader() != this.descr.cl) {
            this.descr.badClasses.add(object.getClass());
        }
        return object;
    }

    synchronized Object getInstance() throws Exception {
        if (this.result instanceof Exception) {
            ((Exception)this.result).fillInStackTrace();
            throw (Exception)this.result;
        }
        if (this.result == null) {
            try {
                this.result = this.createInstance();
            }
            catch (Exception exception) {
                this.result = exception;
                throw exception;
            }
            catch (Throwable throwable) {
                this.result = new ClassNotFoundException(ManifestSection.exceptionMessage(throwable));
                throw (Exception)this.result;
            }
        }
        return this.result;
    }

    void release() {
        this.result = null;
    }

    static String exceptionMessage(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(throwable.getClass().getName());
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    abstract void invokeIterator(Iterator var1) throws Exception;

    static ManifestSection createSection(String string, Attributes attributes, ModuleDescription moduleDescription) throws IllegalModuleException {
        String string2 = attributes.getValue(ModuleDescription.TAG_SECTION_CLASS);
        if (string2 == null) {
            return null;
        }
        if (string2.equalsIgnoreCase("Action")) {
            return new ActionSection(string, attributes, moduleDescription);
        }
        if (string2.equalsIgnoreCase("Option")) {
            return new OptionSection(string, attributes, moduleDescription);
        }
        if (string2.equalsIgnoreCase("Loader")) {
            return new LoaderSection(string, attributes, moduleDescription);
        }
        if (string2.equalsIgnoreCase("Filesystem")) {
            return new FileSystemSection(string, attributes, moduleDescription);
        }
        if (string2.equalsIgnoreCase("Node")) {
            return new NodeSection(string, attributes, moduleDescription);
        }
        if (string2.equalsIgnoreCase("Service")) {
            return new ServiceSection(string, attributes, moduleDescription);
        }
        if (string2.equalsIgnoreCase("Debugger")) {
            return new DebuggerSection(string, attributes, moduleDescription);
        }
        if (string2.equalsIgnoreCase("ClipboardConvertor")) {
            return new ClipboardConvertorSection(string, attributes, moduleDescription);
        }
        throw new IllegalModuleException(MessageFormat.format(NbBundle.getBundle(class$org$openide$modules$ManifestSection == null ? (class$org$openide$modules$ManifestSection = ManifestSection.class$("org.openide.modules.ManifestSection")) : class$org$openide$modules$ManifestSection).getString("EXC_IllegalModuleClass"), string, string2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
            System.err.println("WARNING: use of deprecated class org.openide.modules.ManifestSection");
            Thread.dumpStack();
        }
    }

    public static final class ClipboardConvertorSection
    extends ManifestSection {
        ClipboardConvertorSection(String string, Attributes attributes, ModuleDescription moduleDescription) throws IllegalModuleException {
            super(string, moduleDescription);
        }

        public ExClipboard.Convertor getConvertor() throws InstantiationException {
            try {
                return (ExClipboard.Convertor)super.getInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException(ManifestSection.exceptionMessage(exception));
            }
        }

        void invokeIterator(Iterator iterator) throws Exception {
            iterator.processClipboardConvertor(this);
        }
    }

    public static final class NodeSection
    extends ManifestSection {
        public static final String TYPE_ROOTS = "roots";
        public static final String TYPE_ENVIRONMENT = "environment";
        public static final String TYPE_SESSION = "session";
        private String type;

        NodeSection(String string, Attributes attributes, ModuleDescription moduleDescription) throws IllegalModuleException {
            super(string, moduleDescription);
            this.type = attributes.getValue(ModuleDescription.TAG_NODE_TYPE);
        }

        public Node getNode() throws InstantiationException {
            try {
                return (Node)super.getInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException(ManifestSection.exceptionMessage(exception));
            }
        }

        public String getType() {
            return this.type;
        }

        void invokeIterator(Iterator iterator) throws Exception {
            iterator.processNode(this);
        }
    }

    public static final class FileSystemSection
    extends ManifestSection {
        private Attributes attr;

        FileSystemSection(String string, Attributes attributes, ModuleDescription moduleDescription) throws IllegalModuleException {
            super(string, moduleDescription);
            this.attr = attributes;
        }

        public String getName() {
            String string = NbBundle.getLocalizedValue(this.attr, ModuleDescription.TAG_FILESYSTEM_NAME);
            if (string == null) {
                return MessageFormat.format(NbBundle.getBundle(class$org$openide$modules$ManifestSection == null ? (class$org$openide$modules$ManifestSection = ManifestSection.class$("org.openide.modules.ManifestSection")) : class$org$openide$modules$ManifestSection).getString("CTL_Repository_Unknown"), this.name);
            }
            return string;
        }

        public HelpCtx getHelpCtx() {
            String string = this.attr.getValue(ModuleDescription.TAG_FILESYSTEM_HELP);
            return string == null ? HelpCtx.DEFAULT_HELP : new HelpCtx(string);
        }

        public FileSystem createFileSystem() throws InstantiationException {
            try {
                return (FileSystem)super.createInstance();
            }
            catch (Exception exception) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    exception.printStackTrace();
                }
                throw new InstantiationException(ManifestSection.exceptionMessage(exception));
            }
        }

        void invokeIterator(Iterator iterator) throws Exception {
            iterator.processFileSystem(this);
        }
    }

    public static final class ServiceSection
    extends ManifestSection {
        private Attributes attr;

        ServiceSection(String string, Attributes attributes, ModuleDescription moduleDescription) throws IllegalModuleException {
            super(string, moduleDescription);
            this.attr = attributes;
        }

        public boolean isDefault() {
            return Boolean.valueOf(this.attr.getValue(ModuleDescription.TAG_SERVICE_DEFAULT));
        }

        public ServiceType getServiceType() throws InstantiationException {
            try {
                return (ServiceType)super.getInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException(ManifestSection.exceptionMessage(exception));
            }
        }

        public ServiceType createServiceType() throws InstantiationException {
            try {
                return (ServiceType)super.createInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException(ManifestSection.exceptionMessage(exception));
            }
        }

        void invokeIterator(Iterator iterator) throws Exception {
            iterator.processService(this);
        }
    }

    public static final class DebuggerSection
    extends ManifestSection {
        DebuggerSection(String string, Attributes attributes, ModuleDescription moduleDescription) throws IllegalModuleException {
            super(string, moduleDescription);
        }

        public Debugger getDebugger() throws InstantiationException {
            try {
                return (Debugger)super.getInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException(ManifestSection.exceptionMessage(exception));
            }
        }

        void invokeIterator(Iterator iterator) throws Exception {
            iterator.processDebugger(this);
        }
    }

    public static final class LoaderSection
    extends ManifestSection {
        private String[] installAfter;
        private String[] installBefore;

        LoaderSection(String string, Attributes attributes, ModuleDescription moduleDescription) throws IllegalModuleException {
            super(string, moduleDescription);
            String string2;
            LinkedList<String> linkedList;
            StringTokenizer stringTokenizer;
            String string3 = attributes.getValue(ModuleDescription.TAG_INSTALL_AFTER);
            if (string3 != null) {
                stringTokenizer = new StringTokenizer(string3, ", ");
                linkedList = new LinkedList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals("")) continue;
                    linkedList.add(string2);
                }
                this.installAfter = linkedList.toArray(new String[linkedList.size()]);
            } else {
                this.installAfter = null;
            }
            string3 = attributes.getValue(ModuleDescription.TAG_INSTALL_BEFORE);
            if (string3 != null) {
                stringTokenizer = new StringTokenizer(string3, ", ");
                linkedList = new LinkedList();
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals("")) continue;
                    linkedList.add(string2);
                }
                this.installBefore = linkedList.toArray(new String[linkedList.size()]);
            } else {
                this.installBefore = null;
            }
        }

        public DataLoader getLoader() throws InstantiationException {
            try {
                return (DataLoader)super.getInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException(ManifestSection.exceptionMessage(exception));
            }
        }

        public String[] getInstallAfter() {
            return this.installAfter;
        }

        public String[] getInstallBefore() {
            return this.installBefore;
        }

        void invokeIterator(Iterator iterator) throws Exception {
            iterator.processLoader(this);
        }
    }

    public static final class OptionSection
    extends ManifestSection {
        OptionSection(String string, Attributes attributes, ModuleDescription moduleDescription) throws IllegalModuleException {
            super(string, moduleDescription);
        }

        public SystemOption getOption() throws InstantiationException {
            try {
                return (SystemOption)super.getInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException(ManifestSection.exceptionMessage(exception));
            }
        }

        void invokeIterator(Iterator iterator) throws Exception {
            iterator.processOption(this);
        }
    }

    public static final class ActionSection
    extends ManifestSection {
        private String toolbar;
        private String menu;
        private String key;

        ActionSection(String string, Attributes attributes, ModuleDescription moduleDescription) throws IllegalModuleException {
            super(string, moduleDescription);
        }

        public SystemAction getAction() throws InstantiationException {
            try {
                return (SystemAction)super.getInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException(ManifestSection.exceptionMessage(exception));
            }
        }

        void invokeIterator(Iterator iterator) throws Exception {
            iterator.processAction(this);
        }
    }

    public static interface Iterator {
        public void processAction(ActionSection var1) throws InstantiationException;

        public void processOption(OptionSection var1) throws InstantiationException;

        public void processLoader(LoaderSection var1) throws InstantiationException;

        public void processDebugger(DebuggerSection var1) throws InstantiationException;

        public void processService(ServiceSection var1) throws InstantiationException;

        public void processFileSystem(FileSystemSection var1) throws InstantiationException;

        public void processNode(NodeSection var1) throws InstantiationException;

        public void processClipboardConvertor(ClipboardConvertorSection var1) throws InstantiationException;
    }
}

