/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.openide.modules.SpecificationVersion;

public abstract class ModuleInfo {
    public static final String PROP_ENABLED = "enabled";
    private final Set listeners = new HashSet(5);

    protected ModuleInfo() {
    }

    public abstract String getCodeNameBase();

    public abstract int getCodeNameRelease();

    public abstract String getCodeName();

    public String getDisplayName() {
        String string = (String)this.getLocalizedAttribute("OpenIDE-Module-Name");
        if (string != null) {
            return string;
        }
        return this.getCodeNameBase();
    }

    public abstract SpecificationVersion getSpecificationVersion();

    public String getImplementationVersion() {
        return (String)this.getAttribute("OpenIDE-Module-Implementation-Version");
    }

    public abstract boolean isEnabled();

    public abstract Object getAttribute(String var1);

    public abstract Object getLocalizedAttribute(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeListener[] propertyChangeListenerArray;
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
            propertyChangeListenerArray = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < propertyChangeListenerArray.length) {
            propertyChangeListenerArray[n].propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public abstract Set getDependencies();

    public abstract boolean owns(Class var1);
}

