/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class FilterNode
extends Node {
    private Node original;
    private PropertyChangeListener propL;
    private NodeListener nodeL;
    private int delegateMask;
    protected static final int DELEGATE_SET_NAME = 1;
    protected static final int DELEGATE_GET_NAME = 2;
    protected static final int DELEGATE_SET_DISPLAY_NAME = 4;
    protected static final int DELEGATE_GET_DISPLAY_NAME = 8;
    protected static final int DELEGATE_SET_SHORT_DESCRIPTION = 16;
    protected static final int DELEGATE_GET_SHORT_DESCRIPTION = 32;
    protected static final int DELEGATE_DESTROY = 64;
    protected static final int DELEGATE_GET_ACTIONS = 128;
    protected static final int DELEGATE_GET_CONTEXT_ACTIONS = 256;
    private static final int DELEGATE_ALL = 511;
    private boolean pchlAttached = false;
    static /* synthetic */ Class class$org$openide$nodes$FilterNode;
    static /* synthetic */ Class class$org$openide$nodes$FilterNode$Children;

    public FilterNode(Node node) {
        this(node, node.isLeaf() ? org.openide.nodes.Children.LEAF : new Children(node));
    }

    public FilterNode(Node node, org.openide.nodes.Children children) {
        super(children);
        this.original = node;
        this.init();
    }

    private void init() {
        this.original.addNodeListener(this.getNodeListener());
        this.delegateMask = 511;
    }

    void notifyPropertyChangeListenerAdded(PropertyChangeListener propertyChangeListener) {
        if (!this.pchlAttached) {
            this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = true;
        }
    }

    void notifyPropertyChangeListenerRemoved(PropertyChangeListener propertyChangeListener) {
        if (this.getPropertyChangeListenersCount() == 0) {
            this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = false;
        }
    }

    protected void finalize() {
        this.original.removePropertyChangeListener(this.getPropertyChangeListener());
        this.original.removeNodeListener(this.getNodeListener());
    }

    protected final void enableDelegation(int n) {
        if ((n & 0xFFFFFE00) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + n);
        }
        this.delegateMask |= n;
    }

    protected final void disableDelegation(int n) {
        if ((n & 0xFFFFFE00) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + n);
        }
        this.delegateMask &= ~n;
    }

    private final boolean delegating(int n) {
        return (this.delegateMask & n) != 0;
    }

    public Node cloneNode() {
        if (this.isDefault()) {
            return new FilterNode(this.original);
        }
        return new FilterNode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void changeOriginal(Node node, boolean bl) {
        if (!(!bl || this.getChildren() instanceof Children || this.getChildren() == Children.LEAF && node.isLeaf())) {
            throw new IllegalStateException("Can't change implicitly defined Children on FilterNode");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        Node.PropertySet[] propertySetArray = null;
        try {
            Children.PR.enterWriteAccess();
            string = this.original.getName();
            string2 = this.original.getDisplayName();
            string3 = this.original.getShortDescription();
            propertySetArray = this.original.getPropertySets();
            this.original.removeNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            }
            this.original = node;
            this.original.addNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            }
            if (bl && !node.isLeaf()) {
                ((Children)this.getChildren()).changeOriginal(node);
            }
            Object var8_7 = null;
            Children.PR.exitWriteAccess();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Children.PR.exitWriteAccess();
            throw throwable;
        }
        this.fireCookieChange();
        this.fireNameChange(string, node.getName());
        this.fireDisplayNameChange(string2, node.getDisplayName());
        this.fireShortDescriptionChange(string3, node.getShortDescription());
        this.fireIconChange();
        this.fireOpenedIconChange();
        this.firePropertySetsChange(propertySetArray, node.getPropertySets());
    }

    public void setName(String string) {
        if (this.delegating(1)) {
            this.original.setName(string);
        } else {
            super.setName(string);
        }
    }

    public String getName() {
        if (this.delegating(2)) {
            return this.original.getName();
        }
        return super.getName();
    }

    public void setDisplayName(String string) {
        if (this.delegating(4)) {
            this.original.setDisplayName(string);
        } else {
            super.setDisplayName(string);
        }
    }

    public String getDisplayName() {
        if (this.delegating(8)) {
            return this.original.getDisplayName();
        }
        return super.getDisplayName();
    }

    public void setShortDescription(String string) {
        if (this.delegating(16)) {
            this.original.setShortDescription(string);
        } else {
            super.setShortDescription(string);
        }
    }

    public String getShortDescription() {
        if (this.delegating(32)) {
            return this.original.getShortDescription();
        }
        return super.getShortDescription();
    }

    public Image getIcon(int n) {
        return this.original.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        return this.original.getOpenedIcon(n);
    }

    public HelpCtx getHelpCtx() {
        return this.original.getHelpCtx();
    }

    public boolean canRename() {
        return this.original.canRename();
    }

    public boolean canDestroy() {
        return this.original.canDestroy();
    }

    public void destroy() throws IOException {
        if (this.delegating(64)) {
            this.original.destroy();
        } else {
            super.destroy();
        }
    }

    private final void originalDestroyed() {
        try {
            super.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Node.PropertySet[] getPropertySets() {
        return this.original.getPropertySets();
    }

    public Transferable clipboardCopy() throws IOException {
        return this.original.clipboardCopy();
    }

    public Transferable clipboardCut() throws IOException {
        return this.original.clipboardCut();
    }

    public boolean canCopy() {
        return this.original.canCopy();
    }

    public boolean canCut() {
        return this.original.canCut();
    }

    public Transferable drag() throws IOException {
        return this.original.drag();
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        return this.original.getDropType(transferable, n, n2);
    }

    public PasteType[] getPasteTypes(Transferable transferable) {
        return this.original.getPasteTypes(transferable);
    }

    public NewType[] getNewTypes() {
        return this.original.getNewTypes();
    }

    public SystemAction[] getActions() {
        if (this.delegating(128)) {
            return this.original.getActions();
        }
        return super.getActions();
    }

    public SystemAction[] getContextActions() {
        if (this.delegating(256)) {
            return this.original.getContextActions();
        }
        return super.getContextActions();
    }

    public SystemAction getDefaultAction() {
        return this.original.getDefaultAction();
    }

    public boolean hasCustomizer() {
        return this.original.hasCustomizer();
    }

    public Component getCustomizer() {
        return this.original.getCustomizer();
    }

    public Node.Cookie getCookie(Class clazz) {
        return this.original.getCookie(clazz);
    }

    public Node.Handle getHandle() {
        if (!this.isDefault()) {
            return null;
        }
        Node.Handle handle = this.original.getHandle();
        if (handle == null) {
            return null;
        }
        return new FilterHandle(handle);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.isDefault()) {
            return false;
        }
        return this.original.equals(object) || object.equals(this.original);
    }

    public int hashCode() {
        return this.isDefault() ? this.original.hashCode() : super.hashCode();
    }

    protected Node getOriginal() {
        return this.original;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeAdapter(this);
    }

    protected NodeListener createNodeListener() {
        return new NodeAdapter(this);
    }

    synchronized PropertyChangeListener getPropertyChangeListener() {
        if (this.propL == null) {
            this.propL = this.createPropertyChangeListener();
        }
        return this.propL;
    }

    synchronized NodeListener getNodeListener() {
        if (this.nodeL == null) {
            this.nodeL = this.createNodeListener();
        }
        return this.nodeL;
    }

    private boolean isDefault() {
        if (this.getClass() != (class$org$openide$nodes$FilterNode == null ? (class$org$openide$nodes$FilterNode = FilterNode.class$("org.openide.nodes.FilterNode")) : class$org$openide$nodes$FilterNode)) {
            return false;
        }
        org.openide.nodes.Children children = this.getChildren();
        return this.original.isLeaf() && children == Children.LEAF || !this.original.isLeaf() && children.getClass() == (class$org$openide$nodes$FilterNode$Children == null ? (class$org$openide$nodes$FilterNode$Children = FilterNode.class$("org.openide.nodes.FilterNode$Children")) : class$org$openide$nodes$FilterNode$Children) && ((Children)children).original == this.original;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class FilterHandle
    implements Node.Handle {
        private Node.Handle original;
        static final long serialVersionUID = 7928908039428333839L;

        public FilterHandle(Node.Handle handle) {
            this.original = handle;
        }

        public Node getNode() throws IOException {
            return new FilterNode(this.original.getNode());
        }

        public String toString() {
            return "FilterHandle[" + this.original + "]";
        }
    }

    private static class ChildrenAdapter
    implements NodeListener,
    Runnable {
        private WeakReference children;

        public ChildrenAdapter(Children children) {
            this.children = new WeakReference<Children>(children);
        }

        public void run() {
            Children children = (Children)this.children.get();
            if (children != null) {
                Object[] objectArray = children.original.getChildren().getNodes();
                children.setKeys(objectArray);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenAdded(nodeMemberEvent);
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenRemoved(nodeMemberEvent);
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenReordered(nodeReorderEvent);
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }
    }

    public static class Children
    extends Children.Keys
    implements Cloneable {
        protected Node original;
        private ChildrenAdapter nodeL;

        public Children(Node node) {
            this.original = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void changeOriginal(Node node) {
            try {
                boolean bl;
                org.openide.nodes.Children.PR.enterWriteAccess();
                boolean bl2 = bl = this.nodeL != null;
                if (bl) {
                    this.original.removeNodeListener(this.nodeL);
                    this.nodeL = null;
                }
                this.original = node;
                if (bl) {
                    this.addNotifyImpl();
                }
                Object var4_3 = null;
                org.openide.nodes.Children.PR.exitWriteAccess();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                org.openide.nodes.Children.PR.exitWriteAccess();
                throw throwable;
            }
        }

        protected void finalize() {
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
            }
            this.nodeL = null;
        }

        public Object clone() {
            return new Children(this.original);
        }

        protected void addNotify() {
            this.addNotifyImpl();
        }

        private void addNotifyImpl() {
            this.nodeL = new ChildrenAdapter(this);
            this.original.addNodeListener(this.nodeL);
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
                this.nodeL = null;
            }
        }

        protected Node copyNode(Node node) {
            return node.cloneNode();
        }

        public Node findChild(String string) {
            this.original.getChildren().findChild(string);
            return super.findChild(string);
        }

        protected Node[] createNodes(Object object) {
            Node node = (Node)object;
            return new Node[]{this.copyNode(node)};
        }

        public boolean add(Node[] nodeArray) {
            return this.original.getChildren().add(nodeArray);
        }

        public boolean remove(Node[] nodeArray) {
            return this.original.getChildren().remove(nodeArray);
        }

        protected void filterChildrenAdded(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        protected void filterChildrenRemoved(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        protected void filterChildrenReordered(NodeReorderEvent nodeReorderEvent) {
            this.updateKeys();
        }

        private void updateKeys() {
            ChildrenAdapter childrenAdapter = this.nodeL;
            if (childrenAdapter != null) {
                childrenAdapter.run();
            }
        }
    }

    protected static class NodeAdapter
    implements NodeListener {
        private WeakReference fn;
        private WeakReference children;

        public NodeAdapter(FilterNode filterNode) {
            this.fn = new WeakReference<FilterNode>(filterNode);
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FilterNode filterNode = (FilterNode)this.fn.get();
            if (filterNode == null) {
                return;
            }
            this.propertyChange(filterNode, propertyChangeEvent);
        }

        protected void propertyChange(FilterNode filterNode, PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("parentNode")) {
                return;
            }
            if (string.equals("displayName")) {
                filterNode.fireOwnPropertyChange("displayName", (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("name")) {
                filterNode.fireOwnPropertyChange("name", (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("shortDescription")) {
                filterNode.fireOwnPropertyChange("shortDescription", (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("icon")) {
                filterNode.fireIconChange();
                return;
            }
            if (string.equals("openedIcon")) {
                filterNode.fireOpenedIconChange();
                return;
            }
            if (string.equals("propertySets")) {
                filterNode.firePropertySetsChange((Node.PropertySet[])propertyChangeEvent.getOldValue(), (Node.PropertySet[])propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("cookie")) {
                filterNode.fireCookieChange();
                return;
            }
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public final void nodeDestroyed(NodeEvent nodeEvent) {
            FilterNode filterNode = (FilterNode)this.fn.get();
            if (filterNode == null) {
                return;
            }
            filterNode.originalDestroyed();
        }
    }

    protected static class PropertyChangeAdapter
    implements PropertyChangeListener {
        private WeakReference fn;

        public PropertyChangeAdapter(FilterNode filterNode) {
            this.fn = new WeakReference<FilterNode>(filterNode);
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FilterNode filterNode = (FilterNode)this.fn.get();
            if (filterNode == null) {
                return;
            }
            this.propertyChange(filterNode, propertyChangeEvent);
        }

        protected void propertyChange(FilterNode filterNode, PropertyChangeEvent propertyChangeEvent) {
            filterNode.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

