/*
 * Decompiled with CFR 0.152.
 */
package org.openide.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextProxy;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.openide.TopManager;
import org.openide.options.SystemOption;
import org.openide.util.io.NbMarshalledObject;

public abstract class ContextSystemOption
extends SystemOption
implements BeanContextProxy {
    protected BeanContext beanContext = this.getBeanContext();
    private static Object ctxt = new Object();
    private static final long serialVersionUID = -781528552645947127L;

    public final void addOption(SystemOption systemOption) {
        this.getBeanContext().add(systemOption);
    }

    public final void removeOption(SystemOption systemOption) {
        this.getBeanContext().remove(systemOption);
    }

    public final SystemOption[] getOptions() {
        Object[] objectArray = this.getBeanContext().toArray();
        int n = 0;
        int n2 = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof SystemOption) {
                if (n > n2) {
                    objectArray[n2] = objectArray[n];
                }
                ++n2;
            }
            ++n;
        }
        SystemOption[] systemOptionArray = new SystemOption[n2];
        System.arraycopy(objectArray, 0, systemOptionArray, 0, n2);
        return systemOptionArray;
    }

    public final BeanContextChild getBeanContextProxy() {
        return this.getBeanContext();
    }

    private BeanContext getBeanContext() {
        return (BeanContext)this.getProperty(ctxt);
    }

    protected void initialize() {
        super.initialize();
        this.putProperty(ctxt, new OptionBeanContext(this));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        Iterator iterator = this.getBeanContext().iterator();
        Object[] objectArray = this.getBeanContext().toArray();
        Arrays.sort(objectArray, new ClassComparator());
        int n = 0;
        while (n < objectArray.length) {
            objectOutput.writeObject(new NbMarshalledObject(objectArray[n]));
            ++n;
        }
        objectOutput.writeObject(null);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof BeanContext) {
            this.beanContext = (BeanContext)object;
        } else {
            BeanContext beanContext = this.getBeanContext();
            while (object != null) {
                NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)object;
                try {
                    beanContext.add(nbMarshalledObject.get());
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    TopManager.getDefault().getErrorManager().notify(1, throwable);
                }
                object = objectInput.readObject();
            }
        }
    }

    private static class OptionBeanContext
    extends BeanContextSupport
    implements PropertyChangeListener {
        private ContextSystemOption parent = null;
        private static final long serialVersionUID = 3532434266136225440L;

        public OptionBeanContext(ContextSystemOption contextSystemOption) {
            this.parent = contextSystemOption;
        }

        public boolean add(Object object) {
            if (!(object instanceof SystemOption)) {
                throw new IllegalArgumentException();
            }
            boolean bl = super.add(object);
            if (bl) {
                ((SystemOption)object).addPropertyChangeListener(this);
            }
            return bl;
        }

        public boolean remove(Object object) {
            if (!(object instanceof SystemOption)) {
                throw new IllegalArgumentException();
            }
            boolean bl = super.remove(object);
            if (bl) {
                ((SystemOption)object).removePropertyChangeListener(this);
            }
            return bl;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.parent != null) {
                this.parent.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class ClassComparator
    implements Comparator {
        ClassComparator() {
        }

        public int compare(Object object, Object object2) {
            return object.getClass().getName().compareTo(object2.getClass().getName());
        }
    }
}

