/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.MemberElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class ConstructorElement
extends MemberElement {
    private static final ElementFormat HEADER_FORMAT = new ElementFormat("{m,,\" \"}{n}({a}){e,\" throws \",}");
    static final long serialVersionUID = 4794977239847390179L;

    public ConstructorElement() {
        this(new Memory(), null);
    }

    public ConstructorElement(Impl impl, ClassElement classElement) {
        super(impl, classElement);
    }

    public Object clone() {
        return new ConstructorElement(new Memory(this), null);
    }

    final Impl getConstructorImpl() {
        return (Impl)this.impl;
    }

    public int getModifiersMask() {
        return 7;
    }

    public final MethodParameter[] getParameters() {
        return this.getConstructorImpl().getParameters();
    }

    public final void setParameters(MethodParameter[] methodParameterArray) throws SourceException {
        this.getConstructorImpl().setParameters(methodParameterArray);
    }

    public final Identifier[] getExceptions() {
        return this.getConstructorImpl().getExceptions();
    }

    public final void setExceptions(Identifier[] identifierArray) throws SourceException {
        this.getConstructorImpl().setExceptions(identifierArray);
    }

    public final void setBody(String string) throws SourceException {
        this.getConstructorImpl().setBody(string);
    }

    public final String getBody() {
        return this.getConstructorImpl().getBody();
    }

    public final JavaDoc.Method getJavaDoc() {
        return this.getConstructorImpl().getJavaDoc();
    }

    public void print(ElementPrinter elementPrinter) throws ElementPrinterInterruptException {
        this.printerMark(elementPrinter, 0);
        JavaDoc.Method method = this.getJavaDoc();
        if (method != null && !method.isEmpty()) {
            this.printerMark(elementPrinter, 2);
            Element.printJavaDoc(method, elementPrinter);
            this.printerMark(elementPrinter, 3);
            elementPrinter.println("");
        }
        this.printerMark(elementPrinter, 4);
        elementPrinter.print(this.getFormat().format(this));
        this.printerMark(elementPrinter, 5);
        String string = this.getBody();
        ClassElement classElement = this.getDeclaringClass();
        if (classElement != null && classElement.isInterface() || Modifier.isAbstract(this.getModifiers()) || string == null) {
            elementPrinter.print(";");
        } else {
            elementPrinter.print(" {");
            this.printerMark(elementPrinter, 6);
            elementPrinter.print(string);
            this.printerMark(elementPrinter, 7);
            elementPrinter.print("}");
        }
        this.printerMark(elementPrinter, 1);
    }

    void printerMark(ElementPrinter elementPrinter, int n) throws ElementPrinterInterruptException {
        elementPrinter.markConstructor(this, n);
    }

    ElementFormat getFormat() {
        return HEADER_FORMAT;
    }

    static class Memory
    extends MemberElement.Memory
    implements Impl {
        private MethodParameter[] parameters;
        private Identifier[] exceptions;
        private String body;
        private JavaDoc.Method javaDoc;
        static final long serialVersionUID = -4826478874004410760L;

        Memory() {
            this.exceptions = new Identifier[0];
            this.parameters = new MethodParameter[0];
            this.body = "";
            this.javaDoc = JavaDocSupport.createMethodJavaDoc(null);
        }

        Memory(ConstructorElement constructorElement) {
            super(constructorElement);
            this.exceptions = constructorElement.getExceptions();
            this.parameters = constructorElement.getParameters();
            this.body = constructorElement.getBody();
            this.javaDoc = constructorElement.getJavaDoc().isEmpty() ? JavaDocSupport.createMethodJavaDoc(null) : JavaDocSupport.createMethodJavaDoc(constructorElement.getJavaDoc().getRawText());
        }

        public MethodParameter[] getParameters() {
            return this.parameters;
        }

        public void setParameters(MethodParameter[] methodParameterArray) {
            MethodParameter[] methodParameterArray2 = this.parameters;
            this.parameters = methodParameterArray;
            this.firePropertyChange("parameters", methodParameterArray2, methodParameterArray);
        }

        public Identifier[] getExceptions() {
            return this.exceptions;
        }

        public void setExceptions(Identifier[] identifierArray) {
            Identifier[] identifierArray2 = this.exceptions;
            this.exceptions = identifierArray;
            this.firePropertyChange("exceptions", identifierArray2, identifierArray);
        }

        public void setBody(String string) throws SourceException {
            String string2 = this.body;
            this.body = string;
            this.firePropertyChange("body", string2, this.body);
        }

        public String getBody() {
            return this.body;
        }

        public JavaDoc.Method getJavaDoc() {
            return this.javaDoc;
        }

        public Object readResolve() {
            return new ConstructorElement(this, null);
        }
    }

    public static class Key {
        private Type[] params;

        public Key(Type[] typeArray) {
            this.params = typeArray;
        }

        public Key(ConstructorElement constructorElement) {
            MethodParameter[] methodParameterArray = constructorElement.getParameters();
            this.params = new Type[methodParameterArray.length];
            int n = 0;
            while (n < methodParameterArray.length) {
                this.params[n] = methodParameterArray[n].getType();
                ++n;
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            return Arrays.equals(this.params, ((Key)object).params);
        }

        public int hashCode() {
            int n = this.params.length;
            if (n == 0) {
                return 0;
            }
            if (n == 1) {
                return this.params[0].getFullString().hashCode();
            }
            return this.params[0].getFullString().hashCode() ^ this.params[n - 1].getFullString().hashCode();
        }
    }

    public static interface Impl
    extends MemberElement.Impl {
        public static final long serialVersionUID = -8757076629808175158L;

        public MethodParameter[] getParameters();

        public void setParameters(MethodParameter[] var1) throws SourceException;

        public Identifier[] getExceptions();

        public void setExceptions(Identifier[] var1) throws SourceException;

        public void setBody(String var1) throws SourceException;

        public String getBody();

        public JavaDoc.Method getJavaDoc();
    }
}

